/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.JsonWebKey;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.KeyAttributes;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.KeyReleasePolicy;
import java.io.IOException;
import java.util.Map;

public class KeyBundle
implements JsonSerializable<KeyBundle> {
    private JsonWebKey key;
    private KeyAttributes attributes;
    private Map<String, String> tags;
    private Boolean managed;
    private KeyReleasePolicy releasePolicy;

    public JsonWebKey getKey() {
        return this.key;
    }

    public KeyBundle setKey(JsonWebKey key) {
        this.key = key;
        return this;
    }

    public KeyAttributes getAttributes() {
        return this.attributes;
    }

    public KeyBundle setAttributes(KeyAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public KeyBundle setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Boolean isManaged() {
        return this.managed;
    }

    KeyBundle setManaged(Boolean managed) {
        this.managed = managed;
        return this;
    }

    public KeyReleasePolicy getReleasePolicy() {
        return this.releasePolicy;
    }

    public KeyBundle setReleasePolicy(KeyReleasePolicy releasePolicy) {
        this.releasePolicy = releasePolicy;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("key", this.key);
        jsonWriter.writeJsonField("attributes", this.attributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("release_policy", this.releasePolicy);
        return jsonWriter.writeEndObject();
    }

    public static KeyBundle fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyBundle deserializedKeyBundle = new KeyBundle();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    deserializedKeyBundle.key = JsonWebKey.fromJson(reader);
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    deserializedKeyBundle.attributes = KeyAttributes.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedKeyBundle.tags = tags;
                    continue;
                }
                if ("managed".equals(fieldName)) {
                    deserializedKeyBundle.managed = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("release_policy".equals(fieldName)) {
                    deserializedKeyBundle.releasePolicy = KeyReleasePolicy.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyBundle;
        });
    }
}

