/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.KeyPropertiesHelper;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.KeyVaultKeysUtils;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models.KeyReleasePolicy;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public class KeyProperties
implements JsonSerializable<KeyProperties> {
    Boolean enabled;
    Boolean exportable;
    OffsetDateTime notBefore;
    String version;
    OffsetDateTime expiresOn;
    OffsetDateTime createdOn;
    OffsetDateTime updatedOn;
    String recoveryLevel;
    String name;
    String id;
    private Map<String, String> tags;
    Boolean managed;
    Integer recoverableDays;
    KeyReleasePolicy releasePolicy;
    private String hsmPlatform;

    public Integer getRecoverableDays() {
        return this.recoverableDays;
    }

    public KeyReleasePolicy getReleasePolicy() {
        return this.releasePolicy;
    }

    public KeyProperties setReleasePolicy(KeyReleasePolicy releasePolicy) {
        this.releasePolicy = releasePolicy;
        return this;
    }

    public String getRecoveryLevel() {
        return this.recoveryLevel;
    }

    public String getName() {
        return this.name;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public KeyProperties setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Boolean isExportable() {
        return this.exportable;
    }

    public KeyProperties setExportable(Boolean exportable) {
        this.exportable = exportable;
        return this;
    }

    public OffsetDateTime getNotBefore() {
        return this.notBefore;
    }

    public KeyProperties setNotBefore(OffsetDateTime notBefore) {
        this.notBefore = notBefore;
        return this;
    }

    public OffsetDateTime getExpiresOn() {
        return this.expiresOn;
    }

    public KeyProperties setExpiresOn(OffsetDateTime expiresOn) {
        this.expiresOn = expiresOn;
        return this;
    }

    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    public OffsetDateTime getUpdatedOn() {
        return this.updatedOn;
    }

    public String getId() {
        return this.id;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public KeyProperties setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Boolean isManaged() {
        return this.managed;
    }

    public String getVersion() {
        return this.version;
    }

    public String getHsmPlatform() {
        return this.hsmPlatform;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeStringField("kid", this.id).writeMapField("tags", this.tags, JsonWriter::writeString).writeJsonField("release_policy", this.releasePolicy).writeEndObject();
    }

    public static KeyProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyProperties properties = new KeyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kid".equals(fieldName)) {
                    properties.id = reader.getString();
                    KeyVaultKeysUtils.unpackId(properties.id, name -> {
                        properties.name = name;
                    }, version -> {
                        properties.version = version;
                    });
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    properties.tags = reader.readMap(JsonReader::getString);
                    continue;
                }
                if ("immutable".equals(fieldName)) {
                    properties.managed = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("recoverableDays".equals(fieldName)) {
                    properties.recoverableDays = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("release_policy".equals(fieldName)) {
                    properties.releasePolicy = KeyReleasePolicy.fromJson(reader);
                    continue;
                }
                if ("attributes".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("enabled".equals(fieldName)) {
                            properties.enabled = reader.getNullable(JsonReader::getBoolean);
                            continue;
                        }
                        if ("exportable".equals(fieldName)) {
                            properties.exportable = reader.getNullable(JsonReader::getBoolean);
                            continue;
                        }
                        if ("nbf".equals(fieldName)) {
                            properties.notBefore = reader.getNullable(KeyVaultKeysUtils::epochToOffsetDateTime);
                            continue;
                        }
                        if ("exp".equals(fieldName)) {
                            properties.expiresOn = reader.getNullable(KeyVaultKeysUtils::epochToOffsetDateTime);
                            continue;
                        }
                        if ("created".equals(fieldName)) {
                            properties.createdOn = reader.getNullable(KeyVaultKeysUtils::epochToOffsetDateTime);
                            continue;
                        }
                        if ("updated".equals(fieldName)) {
                            properties.updatedOn = reader.getNullable(KeyVaultKeysUtils::epochToOffsetDateTime);
                            continue;
                        }
                        if ("recoveryLevel".equals(fieldName)) {
                            properties.recoveryLevel = reader.getString();
                            continue;
                        }
                        if ("recoverableDays".equals(fieldName)) {
                            properties.recoverableDays = reader.getNullable(JsonReader::getInt);
                            continue;
                        }
                        if ("hsmPlatform".equals(fieldName)) {
                            properties.hsmPlatform = reader.getString();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                reader.skipChildren();
            }
            return properties;
        });
    }

    static {
        KeyPropertiesHelper.setAccessor(new KeyPropertiesHelper.KeyPropertiesAccessor(){

            @Override
            public void setCreatedOn(KeyProperties keyProperties, OffsetDateTime createdOn) {
                keyProperties.createdOn = createdOn;
            }

            @Override
            public void setUpdatedOn(KeyProperties keyProperties, OffsetDateTime updatedOn) {
                keyProperties.updatedOn = updatedOn;
            }

            @Override
            public void setRecoveryLevel(KeyProperties keyProperties, String recoveryLevel) {
                keyProperties.recoveryLevel = recoveryLevel;
            }

            @Override
            public void setName(KeyProperties keyProperties, String name) {
                keyProperties.name = name;
            }

            @Override
            public void setVersion(KeyProperties keyProperties, String version) {
                keyProperties.version = version;
            }

            @Override
            public void setId(KeyProperties keyProperties, String id) {
                keyProperties.id = id;
            }

            @Override
            public void setManaged(KeyProperties keyProperties, Boolean managed) {
                keyProperties.managed = managed;
            }

            @Override
            public void setRecoverableDays(KeyProperties keyProperties, Integer recoverableDays) {
                keyProperties.recoverableDays = recoverableDays;
            }

            @Override
            public void setHsmPlatform(KeyProperties keyProperties, String hsmPlatform) {
                keyProperties.hsmPlatform = hsmPlatform;
            }
        });
    }
}

