/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.implementation.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.implementation.models.SecretAttributes;
import java.io.IOException;
import java.util.Map;

public class SecretBundle
implements JsonSerializable<SecretBundle> {
    private String value;
    private String id;
    private String contentType;
    private SecretAttributes attributes;
    private Map<String, String> tags;
    private String kid;
    private Boolean managed;

    public String getValue() {
        return this.value;
    }

    public SecretBundle setValue(String value) {
        this.value = value;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public SecretBundle setId(String id) {
        this.id = id;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public SecretBundle setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public SecretAttributes getAttributes() {
        return this.attributes;
    }

    public SecretBundle setAttributes(SecretAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public SecretBundle setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String getKid() {
        return this.kid;
    }

    SecretBundle setKid(String kid) {
        this.kid = kid;
        return this;
    }

    public Boolean isManaged() {
        return this.managed;
    }

    SecretBundle setManaged(Boolean managed) {
        this.managed = managed;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("contentType", this.contentType);
        jsonWriter.writeJsonField("attributes", this.attributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString((String)element));
        return jsonWriter.writeEndObject();
    }

    public static SecretBundle fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SecretBundle deserializedSecretBundle = new SecretBundle();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    deserializedSecretBundle.value = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedSecretBundle.id = reader.getString();
                    continue;
                }
                if ("contentType".equals(fieldName)) {
                    deserializedSecretBundle.contentType = reader.getString();
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    deserializedSecretBundle.attributes = SecretAttributes.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedSecretBundle.tags = tags;
                    continue;
                }
                if ("kid".equals(fieldName)) {
                    deserializedSecretBundle.kid = reader.getString();
                    continue;
                }
                if ("managed".equals(fieldName)) {
                    deserializedSecretBundle.managed = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecretBundle;
        });
    }
}

