/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.blob;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceClient;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.ResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.SimpleResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.BlobAsyncClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.BlobContainerClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.BlobServiceAsyncClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.BlobServiceClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.BlobServiceVersion;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.AzureBlobStorageImplBuilder;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.accesshelpers.BlobItemConstructorProxy;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.models.BlobHierarchyListSegment;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.models.BlobSignedIdentifierWrapper;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.models.ContainersFilterBlobsHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.models.ContainersGetAccessPolicyHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.models.ContainersGetAccountInfoHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.models.ContainersGetPropertiesHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.models.ContainersListBlobFlatSegmentHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.models.ContainersListBlobHierarchySegmentHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.models.EncryptionScope;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.models.FilterBlobSegment;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.models.ListBlobsFlatSegmentResponse;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.models.ListBlobsHierarchySegmentResponse;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.util.BlobSasImplUtil;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.util.ModelHelper;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobContainerAccessPolicies;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobContainerEncryptionScope;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobContainerProperties;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobItem;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobRequestConditions;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobSignedIdentifier;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobStorageException;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.CpkInfo;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.CustomerProvidedKey;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.ListBlobsIncludeItem;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.ListBlobsOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.PublicAccessType;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.StorageAccountInfo;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.TaggedBlobItem;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.UserDelegationKey;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.options.BlobContainerCreateOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.options.FindBlobsOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.sas.BlobServiceSasSignatureValues;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation.SasImplUtils;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation.StorageImplUtils;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;

@ServiceClient(builder=BlobContainerClientBuilder.class, isAsync=true)
public final class BlobContainerAsyncClient {
    public static final String ROOT_CONTAINER_NAME = "$root";
    public static final String STATIC_WEBSITE_CONTAINER_NAME = "$web";
    public static final String LOG_CONTAINER_NAME = "$logs";
    private static final ClientLogger LOGGER = new ClientLogger(BlobContainerAsyncClient.class);
    private final AzureBlobStorageImpl azureBlobStorage;
    private final String accountName;
    private final String containerName;
    private final BlobServiceVersion serviceVersion;
    private final CpkInfo customerProvidedKey;
    private final EncryptionScope encryptionScope;
    private final BlobContainerEncryptionScope blobContainerEncryptionScope;

    BlobContainerAsyncClient(HttpPipeline pipeline, String url, BlobServiceVersion serviceVersion, String accountName, String containerName, CpkInfo customerProvidedKey, EncryptionScope encryptionScope, BlobContainerEncryptionScope blobContainerEncryptionScope) {
        this.azureBlobStorage = new AzureBlobStorageImplBuilder().pipeline(pipeline).url(url).version(serviceVersion.getVersion()).buildClient();
        this.serviceVersion = serviceVersion;
        this.accountName = accountName;
        this.containerName = containerName;
        this.customerProvidedKey = customerProvidedKey;
        this.encryptionScope = encryptionScope;
        this.blobContainerEncryptionScope = blobContainerEncryptionScope;
        try {
            URI.create(this.getBlobContainerUrl());
        }
        catch (IllegalArgumentException ex) {
            throw LOGGER.logExceptionAsError(ex);
        }
    }

    public BlobAsyncClient getBlobAsyncClient(String blobName) {
        return this.getBlobAsyncClient(blobName, null);
    }

    public BlobAsyncClient getBlobAsyncClient(String blobName, String snapshot) {
        return new BlobAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getBlobContainerName(), blobName, snapshot, this.getCustomerProvidedKey(), this.encryptionScope);
    }

    public BlobAsyncClient getBlobVersionAsyncClient(String blobName, String versionId) {
        return new BlobAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getBlobContainerName(), blobName, null, this.getCustomerProvidedKey(), this.encryptionScope, versionId);
    }

    public String getAccountUrl() {
        return this.azureBlobStorage.getUrl();
    }

    public String getBlobContainerUrl() {
        return this.azureBlobStorage.getUrl() + "/" + this.containerName;
    }

    public String getBlobContainerName() {
        return this.containerName;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public BlobServiceAsyncClient getServiceAsyncClient() {
        return this.getServiceClientBuilder().buildAsyncClient();
    }

    BlobServiceClientBuilder getServiceClientBuilder() {
        CustomerProvidedKey encryptionKey = this.customerProvidedKey == null ? null : new CustomerProvidedKey(this.customerProvidedKey.getEncryptionKey());
        return new BlobServiceClientBuilder().endpoint(this.getBlobContainerUrl()).pipeline(this.getHttpPipeline()).serviceVersion(this.serviceVersion).blobContainerEncryptionScope(this.blobContainerEncryptionScope).encryptionScope(this.getEncryptionScope()).customerProvidedKey(encryptionKey);
    }

    public BlobServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.azureBlobStorage.getHttpPipeline();
    }

    public CpkInfo getCustomerProvidedKey() {
        return this.customerProvidedKey;
    }

    public String getEncryptionScope() {
        if (this.encryptionScope == null) {
            return null;
        }
        return this.encryptionScope.getEncryptionScope();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> exists() {
        return this.existsWithResponse().flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> existsWithResponse() {
        try {
            return FluxUtil.withContext(this::existsWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    Mono<Response<Boolean>> existsWithResponse(Context context) {
        return this.getPropertiesWithResponse(null, context).map(cp -> new SimpleResponse<Boolean>((Response<?>)cp, true)).onErrorResume(t -> t instanceof BlobStorageException && ((BlobStorageException)t).getStatusCode() == 404, t -> {
            HttpResponse response = ((BlobStorageException)t).getResponse();
            return Mono.just(new SimpleResponse<Boolean>(response.getRequest(), response.getStatusCode(), response.getHeaders(), false));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> create() {
        return this.createWithResponse(null, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createWithResponse(Map<String, String> metadata, PublicAccessType accessType) {
        try {
            return FluxUtil.withContext(context -> this.createWithResponse(metadata, accessType, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    Mono<Response<Void>> createWithResponse(Map<String, String> metadata, PublicAccessType accessType, Context context) {
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.getContainers().createNoCustomHeadersWithResponseAsync(this.containerName, null, metadata, accessType, null, this.blobContainerEncryptionScope, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> createIfNotExists() {
        return this.createIfNotExistsWithResponse(null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> createIfNotExistsWithResponse(BlobContainerCreateOptions options) {
        try {
            return this.createIfNotExistsWithResponse(options, null);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    Mono<Response<Boolean>> createIfNotExistsWithResponse(BlobContainerCreateOptions options, Context context) {
        try {
            options = options == null ? new BlobContainerCreateOptions() : options;
            return this.createWithResponse(options.getMetadata(), options.getPublicAccessType(), context).map(response -> new SimpleResponse<Boolean>((Response<?>)response, true)).onErrorResume(t -> t instanceof BlobStorageException && ((BlobStorageException)t).getStatusCode() == 409, t -> {
                HttpResponse response = ((BlobStorageException)t).getResponse();
                return Mono.just(new SimpleResponse<Boolean>(response.getRequest(), response.getStatusCode(), response.getHeaders(), false));
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> delete() {
        return this.deleteWithResponse(null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponse(BlobRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.deleteWithResponse(requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    Mono<Response<Void>> deleteWithResponse(BlobRequestConditions requestConditions, Context context) {
        BlobRequestConditions blobRequestConditions = requestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        if (!ModelHelper.validateNoETag(requestConditions)) {
            throw LOGGER.logExceptionAsError(new UnsupportedOperationException("ETag access conditions are not supported for this API."));
        }
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.getContainers().deleteNoCustomHeadersWithResponseAsync(this.containerName, null, requestConditions.getLeaseId(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), null, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> deleteIfExists() {
        return this.deleteIfExistsWithResponse(null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> deleteIfExistsWithResponse(BlobRequestConditions requestConditions) {
        try {
            return this.deleteIfExistsWithResponse(requestConditions, null);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    Mono<Response<Boolean>> deleteIfExistsWithResponse(BlobRequestConditions requestConditions, Context context) {
        requestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        try {
            return this.deleteWithResponse(requestConditions, context).map(response -> new SimpleResponse<Boolean>((Response<?>)response, true)).onErrorResume(t -> t instanceof BlobStorageException && ((BlobStorageException)t).getStatusCode() == 404, t -> {
                HttpResponse response = ((BlobStorageException)t).getResponse();
                return Mono.just(new SimpleResponse<Boolean>(response.getRequest(), response.getStatusCode(), response.getHeaders(), false));
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobContainerProperties> getProperties() {
        return this.getPropertiesWithResponse(null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlobContainerProperties>> getPropertiesWithResponse(String leaseId) {
        try {
            return FluxUtil.withContext(context -> this.getPropertiesWithResponse(leaseId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    Mono<Response<BlobContainerProperties>> getPropertiesWithResponse(String leaseId, Context context) {
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.getContainers().getPropertiesWithResponseAsync(this.containerName, null, leaseId, null, context).map(rb -> {
            ContainersGetPropertiesHeaders hd = (ContainersGetPropertiesHeaders)rb.getDeserializedHeaders();
            BlobContainerProperties properties = new BlobContainerProperties(hd.getXMsMeta(), hd.getETag(), hd.getLastModified(), hd.getXMsLeaseDuration(), hd.getXMsLeaseState(), hd.getXMsLeaseStatus(), hd.getXMsBlobPublicAccess(), Boolean.TRUE.equals(hd.isXMsHasImmutabilityPolicy()), Boolean.TRUE.equals(hd.isXMsHasLegalHold()), hd.getXMsDefaultEncryptionScope(), hd.isXMsDenyEncryptionScopeOverride(), hd.isXMsImmutableStorageWithVersioningEnabled());
            return new SimpleResponse<BlobContainerProperties>((Response<?>)rb, properties);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setMetadata(Map<String, String> metadata) {
        return this.setMetadataWithResponse(metadata, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setMetadataWithResponse(Map<String, String> metadata, BlobRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.setMetadataWithResponse(metadata, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    Mono<Response<Void>> setMetadataWithResponse(Map<String, String> metadata, BlobRequestConditions requestConditions, Context context) {
        context = context == null ? Context.NONE : context;
        BlobRequestConditions blobRequestConditions = requestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        if (!ModelHelper.validateNoETag(requestConditions) || requestConditions.getIfUnmodifiedSince() != null) {
            throw LOGGER.logExceptionAsError(new UnsupportedOperationException("If-Modified-Since is the only HTTP access condition supported for this API"));
        }
        return this.azureBlobStorage.getContainers().setMetadataNoCustomHeadersWithResponseAsync(this.containerName, null, requestConditions.getLeaseId(), metadata, requestConditions.getIfModifiedSince(), null, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobContainerAccessPolicies> getAccessPolicy() {
        return this.getAccessPolicyWithResponse(null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlobContainerAccessPolicies>> getAccessPolicyWithResponse(String leaseId) {
        try {
            return FluxUtil.withContext(context -> this.getAccessPolicyWithResponse(leaseId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    Mono<Response<BlobContainerAccessPolicies>> getAccessPolicyWithResponse(String leaseId, Context context) {
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.getContainers().getAccessPolicyWithResponseAsync(this.containerName, null, leaseId, null, context).map(response -> new SimpleResponse<BlobContainerAccessPolicies>((Response<?>)response, new BlobContainerAccessPolicies(((ContainersGetAccessPolicyHeaders)response.getDeserializedHeaders()).getXMsBlobPublicAccess(), ((BlobSignedIdentifierWrapper)response.getValue()).items())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setAccessPolicy(PublicAccessType accessType, List<BlobSignedIdentifier> identifiers) {
        return this.setAccessPolicyWithResponse(accessType, identifiers, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setAccessPolicyWithResponse(PublicAccessType accessType, List<BlobSignedIdentifier> identifiers, BlobRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.setAccessPolicyWithResponse(accessType, identifiers, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    Mono<Response<Void>> setAccessPolicyWithResponse(PublicAccessType accessType, List<BlobSignedIdentifier> identifiers, BlobRequestConditions requestConditions, Context context) {
        BlobRequestConditions blobRequestConditions = requestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        if (!ModelHelper.validateNoETag(requestConditions)) {
            throw LOGGER.logExceptionAsError(new UnsupportedOperationException("ETag access conditions are not supported for this API."));
        }
        List<BlobSignedIdentifier> finalIdentifiers = ModelHelper.truncateTimeForBlobSignedIdentifier(identifiers);
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.getContainers().setAccessPolicyNoCustomHeadersWithResponseAsync(this.containerName, null, requestConditions.getLeaseId(), accessType, requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), null, finalIdentifiers, context);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BlobItem> listBlobs() {
        return this.listBlobs(new ListBlobsOptions());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BlobItem> listBlobs(ListBlobsOptions options) {
        return this.listBlobs(options, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BlobItem> listBlobs(ListBlobsOptions options, String continuationToken) {
        try {
            return this.listBlobsFlatWithOptionalTimeout(options, continuationToken, null);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError(LOGGER, ex);
        }
    }

    PagedFlux<BlobItem> listBlobsFlatWithOptionalTimeout(ListBlobsOptions options, String continuationToken, Duration timeout2) {
        BiFunction func = (marker, pageSize) -> {
            ListBlobsOptions finalOptions = pageSize != null ? (options == null ? new ListBlobsOptions().setMaxResultsPerPage((Integer)pageSize) : new ListBlobsOptions().setMaxResultsPerPage((Integer)pageSize).setPrefix(options.getPrefix()).setDetails(options.getDetails())) : options;
            return this.listBlobsFlatSegment((String)marker, finalOptions, timeout2).map(response -> {
                List value = ((ListBlobsFlatSegmentResponse)response.getValue()).getSegment() == null ? Collections.emptyList() : ((ListBlobsFlatSegmentResponse)response.getValue()).getSegment().getBlobItems().stream().map(ModelHelper::populateBlobItem).collect(Collectors.toList());
                return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), value, ((ListBlobsFlatSegmentResponse)response.getValue()).getNextMarker(), (ContainersListBlobFlatSegmentHeaders)response.getDeserializedHeaders());
            });
        };
        return new PagedFlux<BlobItem>(pageSize -> (Mono)func.apply(continuationToken, (Integer)pageSize), func);
    }

    private Mono<ResponseBase<ContainersListBlobFlatSegmentHeaders, ListBlobsFlatSegmentResponse>> listBlobsFlatSegment(String marker, ListBlobsOptions options, Duration timeout2) {
        options = options == null ? new ListBlobsOptions() : options;
        ArrayList<ListBlobsIncludeItem> include = options.getDetails().toList().isEmpty() ? null : options.getDetails().toList();
        return StorageImplUtils.applyOptionalTimeout(this.azureBlobStorage.getContainers().listBlobFlatSegmentWithResponseAsync(this.containerName, options.getPrefix(), marker, options.getMaxResultsPerPage(), include, null, null, Context.NONE), timeout2);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BlobItem> listBlobsByHierarchy(String directory) {
        return this.listBlobsByHierarchy("/", new ListBlobsOptions().setPrefix(directory));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BlobItem> listBlobsByHierarchy(String delimiter, ListBlobsOptions options) {
        try {
            return this.listBlobsHierarchyWithOptionalTimeout(delimiter, options, null);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError(LOGGER, ex);
        }
    }

    PagedFlux<BlobItem> listBlobsHierarchyWithOptionalTimeout(String delimiter, ListBlobsOptions options, Duration timeout2) {
        BiFunction func = (marker, pageSize) -> {
            ListBlobsOptions finalOptions = pageSize != null ? (options == null ? new ListBlobsOptions().setMaxResultsPerPage((Integer)pageSize) : new ListBlobsOptions().setMaxResultsPerPage((Integer)pageSize).setPrefix(options.getPrefix()).setDetails(options.getDetails())) : options;
            return this.listBlobsHierarchySegment((String)marker, delimiter, finalOptions, timeout2).map(response -> {
                List value;
                BlobHierarchyListSegment segment = ((ListBlobsHierarchySegmentResponse)response.getValue()).getSegment();
                if (segment == null) {
                    value = Collections.emptyList();
                } else {
                    value = new ArrayList(segment.getBlobItems().size() + segment.getBlobPrefixes().size());
                    segment.getBlobItems().forEach(item -> value.add(BlobItemConstructorProxy.create(item)));
                    segment.getBlobPrefixes().forEach(prefix -> value.add(new BlobItem().setName(ModelHelper.toBlobNameString(prefix.getName())).setIsPrefix(true)));
                }
                return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), value, ((ListBlobsHierarchySegmentResponse)response.getValue()).getNextMarker(), (ContainersListBlobHierarchySegmentHeaders)response.getDeserializedHeaders());
            });
        };
        return new PagedFlux<BlobItem>(pageSize -> (Mono)func.apply((String)null, (Integer)pageSize), func);
    }

    private Mono<ResponseBase<ContainersListBlobHierarchySegmentHeaders, ListBlobsHierarchySegmentResponse>> listBlobsHierarchySegment(String marker, String delimiter, ListBlobsOptions options, Duration timeout2) {
        ListBlobsOptions listBlobsOptions = options = options == null ? new ListBlobsOptions() : options;
        if (options.getDetails().getRetrieveSnapshots()) {
            throw LOGGER.logExceptionAsError(new UnsupportedOperationException("Including snapshots in a hierarchical listing is not supported."));
        }
        ArrayList<ListBlobsIncludeItem> include = options.getDetails().toList().isEmpty() ? null : options.getDetails().toList();
        return StorageImplUtils.applyOptionalTimeout(this.azureBlobStorage.getContainers().listBlobHierarchySegmentWithResponseAsync(this.containerName, delimiter, options.getPrefix(), marker, options.getMaxResultsPerPage(), include, null, null, Context.NONE), timeout2);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<TaggedBlobItem> findBlobsByTags(String query) {
        try {
            return this.findBlobsByTags(new FindBlobsOptions(query));
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError(LOGGER, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<TaggedBlobItem> findBlobsByTags(FindBlobsOptions options) {
        try {
            return this.findBlobsByTags(options, null);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError(LOGGER, ex);
        }
    }

    PagedFlux<TaggedBlobItem> findBlobsByTags(FindBlobsOptions options, Duration timeout2) {
        StorageImplUtils.assertNotNull("options", options);
        BiFunction func = (marker, pageSize) -> FluxUtil.withContext(context -> this.findBlobsByTags(new FindBlobsOptions(options.getQuery()).setMaxResultsPerPage((Integer)pageSize), (String)marker, timeout2, (Context)context));
        return new PagedFlux<TaggedBlobItem>(pageSize -> (Mono)func.apply((String)null, (Integer)pageSize), func);
    }

    PagedFlux<TaggedBlobItem> findBlobsByTags(FindBlobsOptions options, Duration timeout2, Context context) {
        StorageImplUtils.assertNotNull("options", options);
        BiFunction func = (marker, pageSize) -> {
            FindBlobsOptions finalOptions = pageSize != null ? new FindBlobsOptions(options.getQuery()).setMaxResultsPerPage((Integer)pageSize) : options;
            return this.findBlobsByTags(finalOptions, (String)marker, timeout2, context);
        };
        return new PagedFlux<TaggedBlobItem>(pageSize -> (Mono)func.apply((String)null, (Integer)pageSize), func);
    }

    private Mono<PagedResponse<TaggedBlobItem>> findBlobsByTags(FindBlobsOptions options, String marker, Duration timeout2, Context context) {
        StorageImplUtils.assertNotNull("options", options);
        return StorageImplUtils.applyOptionalTimeout(this.azureBlobStorage.getContainers().filterBlobsWithResponseAsync(this.containerName, null, null, options.getQuery(), marker, options.getMaxResultsPerPage(), null, context), timeout2).map(response -> {
            List value = ((FilterBlobSegment)response.getValue()).getBlobs().stream().map(ModelHelper::populateTaggedBlobItem).collect(Collectors.toList());
            return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), value, ((FilterBlobSegment)response.getValue()).getNextMarker(), (ContainersFilterBlobsHeaders)response.getDeserializedHeaders());
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StorageAccountInfo> getAccountInfo() {
        return this.getAccountInfoWithResponse().flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<StorageAccountInfo>> getAccountInfoWithResponse() {
        try {
            return FluxUtil.withContext(this::getAccountInfoWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    Mono<Response<StorageAccountInfo>> getAccountInfoWithResponse(Context context) {
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.getContainers().getAccountInfoWithResponseAsync(this.containerName, null, null, context).map(rb -> {
            ContainersGetAccountInfoHeaders hd = (ContainersGetAccountInfoHeaders)rb.getDeserializedHeaders();
            return new SimpleResponse<StorageAccountInfo>((Response<?>)rb, new StorageAccountInfo(hd.getXMsSkuName(), hd.getXMsAccountKind(), hd.isXMsIsHnsEnabled()));
        });
    }

    public String generateUserDelegationSas(BlobServiceSasSignatureValues blobServiceSasSignatureValues, UserDelegationKey userDelegationKey) {
        return this.generateUserDelegationSas(blobServiceSasSignatureValues, userDelegationKey, this.getAccountName(), Context.NONE);
    }

    public String generateUserDelegationSas(BlobServiceSasSignatureValues blobServiceSasSignatureValues, UserDelegationKey userDelegationKey, String accountName, Context context) {
        return this.generateUserDelegationSas(blobServiceSasSignatureValues, userDelegationKey, accountName, null, context);
    }

    public String generateUserDelegationSas(BlobServiceSasSignatureValues blobServiceSasSignatureValues, UserDelegationKey userDelegationKey, String accountName, Consumer<String> stringToSignHandler, Context context) {
        return new BlobSasImplUtil(blobServiceSasSignatureValues, this.getBlobContainerName()).generateUserDelegationSas(userDelegationKey, accountName, stringToSignHandler, context);
    }

    public String generateSas(BlobServiceSasSignatureValues blobServiceSasSignatureValues) {
        return this.generateSas(blobServiceSasSignatureValues, Context.NONE);
    }

    public String generateSas(BlobServiceSasSignatureValues blobServiceSasSignatureValues, Context context) {
        return this.generateSas(blobServiceSasSignatureValues, null, context);
    }

    public String generateSas(BlobServiceSasSignatureValues blobServiceSasSignatureValues, Consumer<String> stringToSignHandler, Context context) {
        return new BlobSasImplUtil(blobServiceSasSignatureValues, this.getBlobContainerName()).generateSas(SasImplUtils.extractSharedKeyCredential(this.getHttpPipeline()), stringToSignHandler, context);
    }
}

