/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.blob;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.core.client.traits.AzureNamedKeyCredentialTrait;
import com.dataiku.dss.shadelibazure.com.azure.core.client.traits.AzureSasCredentialTrait;
import com.dataiku.dss.shadelibazure.com.azure.core.client.traits.ConfigurationTrait;
import com.dataiku.dss.shadelibazure.com.azure.core.client.traits.ConnectionStringTrait;
import com.dataiku.dss.shadelibazure.com.azure.core.client.traits.EndpointTrait;
import com.dataiku.dss.shadelibazure.com.azure.core.client.traits.HttpTrait;
import com.dataiku.dss.shadelibazure.com.azure.core.client.traits.TokenCredentialTrait;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.AzureNamedKeyCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.AzureSasCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpClient;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelinePosition;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.AzureSasCredentialPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpLogOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpPipelinePolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.RetryOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.util.ClientOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Configuration;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.BlobServiceAsyncClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.BlobServiceClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.BlobServiceVersion;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.BlobUrlParts;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.models.EncryptionScope;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.util.BuilderHelper;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobAudience;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobContainerEncryptionScope;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.CpkInfo;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.CustomerProvidedKey;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.StorageSharedKeyCredential;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation.connectionstring.StorageAuthenticationSettings;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation.connectionstring.StorageConnectionString;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation.connectionstring.StorageEndpoint;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.policy.RequestRetryOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.policy.StorageSharedKeyCredentialPolicy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={BlobServiceClient.class, BlobServiceAsyncClient.class})
public final class BlobServiceClientBuilder
implements TokenCredentialTrait<BlobServiceClientBuilder>,
ConnectionStringTrait<BlobServiceClientBuilder>,
AzureNamedKeyCredentialTrait<BlobServiceClientBuilder>,
AzureSasCredentialTrait<BlobServiceClientBuilder>,
HttpTrait<BlobServiceClientBuilder>,
ConfigurationTrait<BlobServiceClientBuilder>,
EndpointTrait<BlobServiceClientBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(BlobServiceClientBuilder.class);
    private String endpoint;
    private String accountName;
    private CpkInfo customerProvidedKey;
    private EncryptionScope encryptionScope;
    private BlobContainerEncryptionScope blobContainerEncryptionScope;
    private StorageSharedKeyCredential storageSharedKeyCredential;
    private TokenCredential tokenCredential;
    private AzureSasCredential azureSasCredential;
    private String sasToken;
    private HttpClient httpClient;
    private final List<HttpPipelinePolicy> perCallPolicies = new ArrayList<HttpPipelinePolicy>();
    private final List<HttpPipelinePolicy> perRetryPolicies = new ArrayList<HttpPipelinePolicy>();
    private HttpLogOptions logOptions;
    private RequestRetryOptions retryOptions;
    private RetryOptions coreRetryOptions;
    private HttpPipeline httpPipeline;
    private ClientOptions clientOptions = new ClientOptions();
    private Configuration configuration;
    private BlobServiceVersion version;
    private BlobAudience audience;
    private boolean anonymousAccess;

    public BlobServiceClientBuilder() {
        this.logOptions = BlobServiceClientBuilder.getDefaultHttpLogOptions();
    }

    public BlobServiceClient buildClient() {
        BuilderHelper.httpsValidation(this.customerProvidedKey, "customer provided key", this.endpoint, LOGGER);
        this.anonymousAccess = false;
        if (Objects.nonNull(this.customerProvidedKey) && Objects.nonNull(this.encryptionScope)) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("Customer provided key and encryption scope cannot both be set"));
        }
        BlobServiceVersion serviceVersion = this.version != null ? this.version : BlobServiceVersion.getLatest();
        HttpPipeline pipeline = this.constructPipeline();
        boolean foundCredential = false;
        for (int i = 0; i < pipeline.getPolicyCount(); ++i) {
            if (pipeline.getPolicy(i) instanceof StorageSharedKeyCredentialPolicy) {
                foundCredential = true;
                break;
            }
            if (pipeline.getPolicy(i) instanceof BearerTokenAuthenticationPolicy) {
                foundCredential = true;
                break;
            }
            if (!(pipeline.getPolicy(i) instanceof AzureSasCredentialPolicy)) continue;
            foundCredential = true;
            break;
        }
        this.anonymousAccess = !foundCredential;
        return new BlobServiceClient(pipeline, this.endpoint, serviceVersion, this.accountName, this.customerProvidedKey, this.encryptionScope, this.blobContainerEncryptionScope, this.anonymousAccess);
    }

    private HttpPipeline constructPipeline() {
        return this.httpPipeline != null ? this.httpPipeline : BuilderHelper.buildPipeline(this.storageSharedKeyCredential, this.tokenCredential, this.azureSasCredential, this.sasToken, this.endpoint, this.retryOptions, this.coreRetryOptions, this.logOptions, this.clientOptions, this.httpClient, this.perCallPolicies, this.perRetryPolicies, this.configuration, this.audience, LOGGER);
    }

    public BlobServiceAsyncClient buildAsyncClient() {
        BuilderHelper.httpsValidation(this.customerProvidedKey, "customer provided key", this.endpoint, LOGGER);
        this.anonymousAccess = false;
        if (Objects.nonNull(this.customerProvidedKey) && Objects.nonNull(this.encryptionScope)) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("Customer provided key and encryption scope cannot both be set"));
        }
        BlobServiceVersion serviceVersion = this.version != null ? this.version : BlobServiceVersion.getLatest();
        HttpPipeline pipeline = this.constructPipeline();
        boolean foundCredential = false;
        for (int i = 0; i < pipeline.getPolicyCount(); ++i) {
            if (pipeline.getPolicy(i) instanceof StorageSharedKeyCredentialPolicy) {
                foundCredential = true;
                break;
            }
            if (pipeline.getPolicy(i) instanceof BearerTokenAuthenticationPolicy) {
                foundCredential = true;
                break;
            }
            if (!(pipeline.getPolicy(i) instanceof AzureSasCredentialPolicy)) continue;
            foundCredential = true;
            break;
        }
        this.anonymousAccess = !foundCredential;
        return new BlobServiceAsyncClient(pipeline, this.endpoint, serviceVersion, this.accountName, this.customerProvidedKey, this.encryptionScope, this.blobContainerEncryptionScope, this.anonymousAccess);
    }

    @Override
    public BlobServiceClientBuilder endpoint(String endpoint) {
        try {
            BlobUrlParts parts = BlobUrlParts.parse(new URL(endpoint));
            this.accountName = parts.getAccountName();
            this.endpoint = BuilderHelper.getEndpoint(parts);
            String sasToken = parts.getCommonSasQueryParameters().encode();
            if (!CoreUtils.isNullOrEmpty(sasToken)) {
                this.sasToken(sasToken);
            }
        }
        catch (MalformedURLException ex) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("The Azure Storage endpoint url is malformed.", ex));
        }
        return this;
    }

    public BlobServiceClientBuilder customerProvidedKey(CustomerProvidedKey customerProvidedKey) {
        this.customerProvidedKey = customerProvidedKey == null ? null : new CpkInfo().setEncryptionKey(customerProvidedKey.getKey()).setEncryptionKeySha256(customerProvidedKey.getKeySha256()).setEncryptionAlgorithm(customerProvidedKey.getEncryptionAlgorithm());
        return this;
    }

    public BlobServiceClientBuilder encryptionScope(String encryptionScope) {
        this.encryptionScope = encryptionScope == null ? null : new EncryptionScope().setEncryptionScope(encryptionScope);
        return this;
    }

    public BlobServiceClientBuilder blobContainerEncryptionScope(BlobContainerEncryptionScope blobContainerEncryptionScope) {
        this.blobContainerEncryptionScope = blobContainerEncryptionScope;
        return this;
    }

    public BlobServiceClientBuilder credential(StorageSharedKeyCredential credential) {
        this.storageSharedKeyCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.tokenCredential = null;
        this.sasToken = null;
        return this;
    }

    @Override
    public BlobServiceClientBuilder credential(AzureNamedKeyCredential credential) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        return this.credential(StorageSharedKeyCredential.fromAzureNamedKeyCredential(credential));
    }

    @Override
    public BlobServiceClientBuilder credential(TokenCredential credential) {
        this.tokenCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.storageSharedKeyCredential = null;
        this.sasToken = null;
        return this;
    }

    public BlobServiceClientBuilder sasToken(String sasToken) {
        this.sasToken = Objects.requireNonNull(sasToken, "'sasToken' cannot be null.");
        this.storageSharedKeyCredential = null;
        this.tokenCredential = null;
        return this;
    }

    @Override
    public BlobServiceClientBuilder credential(AzureSasCredential credential) {
        this.azureSasCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        return this;
    }

    @Override
    public BlobServiceClientBuilder connectionString(String connectionString) {
        StorageAuthenticationSettings authSettings;
        StorageConnectionString storageConnectionString = StorageConnectionString.create(connectionString, LOGGER);
        StorageEndpoint endpoint = storageConnectionString.getBlobEndpoint();
        if (endpoint == null || endpoint.getPrimaryUri() == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("connectionString missing required settings to derive blob service endpoint."));
        }
        this.endpoint(endpoint.getPrimaryUri());
        if (storageConnectionString.getAccountName() != null) {
            this.accountName = storageConnectionString.getAccountName();
        }
        if ((authSettings = storageConnectionString.getStorageAuthSettings()).getType() == StorageAuthenticationSettings.Type.ACCOUNT_NAME_KEY) {
            this.credential(new StorageSharedKeyCredential(authSettings.getAccount().getName(), authSettings.getAccount().getAccessKey()));
        } else if (authSettings.getType() == StorageAuthenticationSettings.Type.SAS_TOKEN) {
            this.sasToken(authSettings.getSasToken());
        }
        return this;
    }

    @Override
    public BlobServiceClientBuilder httpClient(HttpClient httpClient) {
        if (this.httpClient != null && httpClient == null) {
            LOGGER.info("'httpClient' is being set to 'null' when it was previously configured.");
        }
        this.httpClient = httpClient;
        return this;
    }

    @Override
    public BlobServiceClientBuilder addPolicy(HttpPipelinePolicy pipelinePolicy) {
        Objects.requireNonNull(pipelinePolicy, "'pipelinePolicy' cannot be null");
        if (pipelinePolicy.getPipelinePosition() == HttpPipelinePosition.PER_CALL) {
            this.perCallPolicies.add(pipelinePolicy);
        } else {
            this.perRetryPolicies.add(pipelinePolicy);
        }
        return this;
    }

    @Override
    public BlobServiceClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.logOptions = Objects.requireNonNull(logOptions, "'logOptions' cannot be null.");
        return this;
    }

    public static HttpLogOptions getDefaultHttpLogOptions() {
        return BuilderHelper.getDefaultHttpLogOptions();
    }

    @Override
    public BlobServiceClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public BlobServiceClientBuilder retryOptions(RequestRetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    @Override
    public BlobServiceClientBuilder retryOptions(RetryOptions retryOptions) {
        this.coreRetryOptions = retryOptions;
        return this;
    }

    @Override
    public BlobServiceClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = Objects.requireNonNull(clientOptions, "'clientOptions' cannot be null.");
        return this;
    }

    @Override
    public BlobServiceClientBuilder pipeline(HttpPipeline httpPipeline) {
        if (this.httpPipeline != null && httpPipeline == null) {
            LOGGER.info("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.httpPipeline = httpPipeline;
        return this;
    }

    public BlobServiceClientBuilder serviceVersion(BlobServiceVersion version) {
        this.version = version;
        return this;
    }

    public BlobServiceClientBuilder audience(BlobAudience audience) {
        this.audience = audience;
        return this;
    }
}

