/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.DateTimeRfc1123;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.AccessTier;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.ArchiveStatus;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobImmutabilityPolicyMode;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobType;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.CopyStatusType;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.LeaseDurationType;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.LeaseStateType;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.LeaseStatusType;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.RehydratePriority;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlReader;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlSerializable;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlToken;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlWriter;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class BlobItemPropertiesInternal
implements XmlSerializable<BlobItemPropertiesInternal> {
    private DateTimeRfc1123 creationTime;
    private DateTimeRfc1123 lastModified;
    private String eTag;
    private Long contentLength;
    private String contentType;
    private String contentEncoding;
    private String contentLanguage;
    private byte[] contentMd5;
    private String contentDisposition;
    private String cacheControl;
    private Long blobSequenceNumber;
    private BlobType blobType;
    private LeaseStatusType leaseStatus;
    private LeaseStateType leaseState;
    private LeaseDurationType leaseDuration;
    private String copyId;
    private CopyStatusType copyStatus;
    private String copySource;
    private String copyProgress;
    private DateTimeRfc1123 copyCompletionTime;
    private String copyStatusDescription;
    private Boolean serverEncrypted;
    private Boolean incrementalCopy;
    private String destinationSnapshot;
    private DateTimeRfc1123 deletedTime;
    private Integer remainingRetentionDays;
    private AccessTier accessTier;
    private Boolean accessTierInferred;
    private ArchiveStatus archiveStatus;
    private String customerProvidedKeySha256;
    private String encryptionScope;
    private DateTimeRfc1123 accessTierChangeTime;
    private Integer tagCount;
    private DateTimeRfc1123 expiresOn;
    private Boolean isSealed;
    private RehydratePriority rehydratePriority;
    private DateTimeRfc1123 lastAccessedOn;
    private DateTimeRfc1123 immutabilityPolicyExpiresOn;
    private BlobImmutabilityPolicyMode immutabilityPolicyMode;
    private Boolean legalHold;

    public OffsetDateTime getCreationTime() {
        if (this.creationTime == null) {
            return null;
        }
        return this.creationTime.getDateTime();
    }

    public BlobItemPropertiesInternal setCreationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime == null ? null : new DateTimeRfc1123(creationTime);
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public BlobItemPropertiesInternal setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public BlobItemPropertiesInternal setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public BlobItemPropertiesInternal setContentLength(Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public BlobItemPropertiesInternal setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public BlobItemPropertiesInternal setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public BlobItemPropertiesInternal setContentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
        return this;
    }

    public byte[] getContentMd5() {
        return CoreUtils.clone(this.contentMd5);
    }

    public BlobItemPropertiesInternal setContentMd5(byte[] contentMd5) {
        this.contentMd5 = CoreUtils.clone(contentMd5);
        return this;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public BlobItemPropertiesInternal setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public BlobItemPropertiesInternal setCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    public Long getBlobSequenceNumber() {
        return this.blobSequenceNumber;
    }

    public BlobItemPropertiesInternal setBlobSequenceNumber(Long blobSequenceNumber) {
        this.blobSequenceNumber = blobSequenceNumber;
        return this;
    }

    public BlobType getBlobType() {
        return this.blobType;
    }

    public BlobItemPropertiesInternal setBlobType(BlobType blobType) {
        this.blobType = blobType;
        return this;
    }

    public LeaseStatusType getLeaseStatus() {
        return this.leaseStatus;
    }

    public BlobItemPropertiesInternal setLeaseStatus(LeaseStatusType leaseStatus) {
        this.leaseStatus = leaseStatus;
        return this;
    }

    public LeaseStateType getLeaseState() {
        return this.leaseState;
    }

    public BlobItemPropertiesInternal setLeaseState(LeaseStateType leaseState) {
        this.leaseState = leaseState;
        return this;
    }

    public LeaseDurationType getLeaseDuration() {
        return this.leaseDuration;
    }

    public BlobItemPropertiesInternal setLeaseDuration(LeaseDurationType leaseDuration) {
        this.leaseDuration = leaseDuration;
        return this;
    }

    public String getCopyId() {
        return this.copyId;
    }

    public BlobItemPropertiesInternal setCopyId(String copyId) {
        this.copyId = copyId;
        return this;
    }

    public CopyStatusType getCopyStatus() {
        return this.copyStatus;
    }

    public BlobItemPropertiesInternal setCopyStatus(CopyStatusType copyStatus) {
        this.copyStatus = copyStatus;
        return this;
    }

    public String getCopySource() {
        return this.copySource;
    }

    public BlobItemPropertiesInternal setCopySource(String copySource) {
        this.copySource = copySource;
        return this;
    }

    public String getCopyProgress() {
        return this.copyProgress;
    }

    public BlobItemPropertiesInternal setCopyProgress(String copyProgress) {
        this.copyProgress = copyProgress;
        return this;
    }

    public OffsetDateTime getCopyCompletionTime() {
        if (this.copyCompletionTime == null) {
            return null;
        }
        return this.copyCompletionTime.getDateTime();
    }

    public BlobItemPropertiesInternal setCopyCompletionTime(OffsetDateTime copyCompletionTime) {
        this.copyCompletionTime = copyCompletionTime == null ? null : new DateTimeRfc1123(copyCompletionTime);
        return this;
    }

    public String getCopyStatusDescription() {
        return this.copyStatusDescription;
    }

    public BlobItemPropertiesInternal setCopyStatusDescription(String copyStatusDescription) {
        this.copyStatusDescription = copyStatusDescription;
        return this;
    }

    public Boolean isServerEncrypted() {
        return this.serverEncrypted;
    }

    public BlobItemPropertiesInternal setServerEncrypted(Boolean serverEncrypted) {
        this.serverEncrypted = serverEncrypted;
        return this;
    }

    public Boolean isIncrementalCopy() {
        return this.incrementalCopy;
    }

    public BlobItemPropertiesInternal setIncrementalCopy(Boolean incrementalCopy) {
        this.incrementalCopy = incrementalCopy;
        return this;
    }

    public String getDestinationSnapshot() {
        return this.destinationSnapshot;
    }

    public BlobItemPropertiesInternal setDestinationSnapshot(String destinationSnapshot) {
        this.destinationSnapshot = destinationSnapshot;
        return this;
    }

    public OffsetDateTime getDeletedTime() {
        if (this.deletedTime == null) {
            return null;
        }
        return this.deletedTime.getDateTime();
    }

    public BlobItemPropertiesInternal setDeletedTime(OffsetDateTime deletedTime) {
        this.deletedTime = deletedTime == null ? null : new DateTimeRfc1123(deletedTime);
        return this;
    }

    public Integer getRemainingRetentionDays() {
        return this.remainingRetentionDays;
    }

    public BlobItemPropertiesInternal setRemainingRetentionDays(Integer remainingRetentionDays) {
        this.remainingRetentionDays = remainingRetentionDays;
        return this;
    }

    public AccessTier getAccessTier() {
        return this.accessTier;
    }

    public BlobItemPropertiesInternal setAccessTier(AccessTier accessTier) {
        this.accessTier = accessTier;
        return this;
    }

    public Boolean isAccessTierInferred() {
        return this.accessTierInferred;
    }

    public BlobItemPropertiesInternal setAccessTierInferred(Boolean accessTierInferred) {
        this.accessTierInferred = accessTierInferred;
        return this;
    }

    public ArchiveStatus getArchiveStatus() {
        return this.archiveStatus;
    }

    public BlobItemPropertiesInternal setArchiveStatus(ArchiveStatus archiveStatus) {
        this.archiveStatus = archiveStatus;
        return this;
    }

    public String getCustomerProvidedKeySha256() {
        return this.customerProvidedKeySha256;
    }

    public BlobItemPropertiesInternal setCustomerProvidedKeySha256(String customerProvidedKeySha256) {
        this.customerProvidedKeySha256 = customerProvidedKeySha256;
        return this;
    }

    public String getEncryptionScope() {
        return this.encryptionScope;
    }

    public BlobItemPropertiesInternal setEncryptionScope(String encryptionScope) {
        this.encryptionScope = encryptionScope;
        return this;
    }

    public OffsetDateTime getAccessTierChangeTime() {
        if (this.accessTierChangeTime == null) {
            return null;
        }
        return this.accessTierChangeTime.getDateTime();
    }

    public BlobItemPropertiesInternal setAccessTierChangeTime(OffsetDateTime accessTierChangeTime) {
        this.accessTierChangeTime = accessTierChangeTime == null ? null : new DateTimeRfc1123(accessTierChangeTime);
        return this;
    }

    public Integer getTagCount() {
        return this.tagCount;
    }

    public BlobItemPropertiesInternal setTagCount(Integer tagCount) {
        this.tagCount = tagCount;
        return this;
    }

    public OffsetDateTime getExpiresOn() {
        if (this.expiresOn == null) {
            return null;
        }
        return this.expiresOn.getDateTime();
    }

    public BlobItemPropertiesInternal setExpiresOn(OffsetDateTime expiresOn) {
        this.expiresOn = expiresOn == null ? null : new DateTimeRfc1123(expiresOn);
        return this;
    }

    public Boolean isSealed() {
        return this.isSealed;
    }

    public BlobItemPropertiesInternal setIsSealed(Boolean isSealed) {
        this.isSealed = isSealed;
        return this;
    }

    public RehydratePriority getRehydratePriority() {
        return this.rehydratePriority;
    }

    public BlobItemPropertiesInternal setRehydratePriority(RehydratePriority rehydratePriority) {
        this.rehydratePriority = rehydratePriority;
        return this;
    }

    public OffsetDateTime getLastAccessedOn() {
        if (this.lastAccessedOn == null) {
            return null;
        }
        return this.lastAccessedOn.getDateTime();
    }

    public BlobItemPropertiesInternal setLastAccessedOn(OffsetDateTime lastAccessedOn) {
        this.lastAccessedOn = lastAccessedOn == null ? null : new DateTimeRfc1123(lastAccessedOn);
        return this;
    }

    public OffsetDateTime getImmutabilityPolicyExpiresOn() {
        if (this.immutabilityPolicyExpiresOn == null) {
            return null;
        }
        return this.immutabilityPolicyExpiresOn.getDateTime();
    }

    public BlobItemPropertiesInternal setImmutabilityPolicyExpiresOn(OffsetDateTime immutabilityPolicyExpiresOn) {
        this.immutabilityPolicyExpiresOn = immutabilityPolicyExpiresOn == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiresOn);
        return this;
    }

    public BlobImmutabilityPolicyMode getImmutabilityPolicyMode() {
        return this.immutabilityPolicyMode;
    }

    public BlobItemPropertiesInternal setImmutabilityPolicyMode(BlobImmutabilityPolicyMode immutabilityPolicyMode) {
        this.immutabilityPolicyMode = immutabilityPolicyMode;
        return this;
    }

    public Boolean isLegalHold() {
        return this.legalHold;
    }

    public BlobItemPropertiesInternal setLegalHold(Boolean legalHold) {
        this.legalHold = legalHold;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Properties" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Creation-Time", Objects.toString(this.creationTime, null));
        xmlWriter.writeStringElement("Last-Modified", Objects.toString(this.lastModified, null));
        xmlWriter.writeStringElement("Etag", this.eTag);
        xmlWriter.writeNumberElement("Content-Length", this.contentLength);
        xmlWriter.writeStringElement("Content-Type", this.contentType);
        xmlWriter.writeStringElement("Content-Encoding", this.contentEncoding);
        xmlWriter.writeStringElement("Content-Language", this.contentLanguage);
        xmlWriter.writeBinaryElement("Content-MD5", this.contentMd5);
        xmlWriter.writeStringElement("Content-Disposition", this.contentDisposition);
        xmlWriter.writeStringElement("Cache-Control", this.cacheControl);
        xmlWriter.writeNumberElement("x-ms-blob-sequence-number", this.blobSequenceNumber);
        xmlWriter.writeStringElement("BlobType", this.blobType == null ? null : this.blobType.toString());
        xmlWriter.writeStringElement("LeaseStatus", this.leaseStatus == null ? null : this.leaseStatus.toString());
        xmlWriter.writeStringElement("LeaseState", this.leaseState == null ? null : this.leaseState.toString());
        xmlWriter.writeStringElement("LeaseDuration", this.leaseDuration == null ? null : this.leaseDuration.toString());
        xmlWriter.writeStringElement("CopyId", this.copyId);
        xmlWriter.writeStringElement("CopyStatus", this.copyStatus == null ? null : this.copyStatus.toString());
        xmlWriter.writeStringElement("CopySource", this.copySource);
        xmlWriter.writeStringElement("CopyProgress", this.copyProgress);
        xmlWriter.writeStringElement("CopyCompletionTime", Objects.toString(this.copyCompletionTime, null));
        xmlWriter.writeStringElement("CopyStatusDescription", this.copyStatusDescription);
        xmlWriter.writeBooleanElement("ServerEncrypted", this.serverEncrypted);
        xmlWriter.writeBooleanElement("IncrementalCopy", this.incrementalCopy);
        xmlWriter.writeStringElement("DestinationSnapshot", this.destinationSnapshot);
        xmlWriter.writeStringElement("DeletedTime", Objects.toString(this.deletedTime, null));
        xmlWriter.writeNumberElement("RemainingRetentionDays", this.remainingRetentionDays);
        xmlWriter.writeStringElement("AccessTier", this.accessTier == null ? null : this.accessTier.toString());
        xmlWriter.writeBooleanElement("AccessTierInferred", this.accessTierInferred);
        xmlWriter.writeStringElement("ArchiveStatus", this.archiveStatus == null ? null : this.archiveStatus.toString());
        xmlWriter.writeStringElement("CustomerProvidedKeySha256", this.customerProvidedKeySha256);
        xmlWriter.writeStringElement("EncryptionScope", this.encryptionScope);
        xmlWriter.writeStringElement("AccessTierChangeTime", Objects.toString(this.accessTierChangeTime, null));
        xmlWriter.writeNumberElement("TagCount", this.tagCount);
        xmlWriter.writeStringElement("Expiry-Time", Objects.toString(this.expiresOn, null));
        xmlWriter.writeBooleanElement("Sealed", this.isSealed);
        xmlWriter.writeStringElement("RehydratePriority", this.rehydratePriority == null ? null : this.rehydratePriority.toString());
        xmlWriter.writeStringElement("LastAccessTime", Objects.toString(this.lastAccessedOn, null));
        xmlWriter.writeStringElement("ImmutabilityPolicyUntilDate", Objects.toString(this.immutabilityPolicyExpiresOn, null));
        xmlWriter.writeStringElement("ImmutabilityPolicyMode", this.immutabilityPolicyMode == null ? null : this.immutabilityPolicyMode.toString());
        xmlWriter.writeBooleanElement("LegalHold", this.legalHold);
        return xmlWriter.writeEndElement();
    }

    public static BlobItemPropertiesInternal fromXml(XmlReader xmlReader) throws XMLStreamException {
        return BlobItemPropertiesInternal.fromXml(xmlReader, null);
    }

    public static BlobItemPropertiesInternal fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Properties" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            BlobItemPropertiesInternal deserializedBlobItemPropertiesInternal = new BlobItemPropertiesInternal();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Creation-Time".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.creationTime = reader.getNullableElement(DateTimeRfc1123::new);
                    continue;
                }
                if ("Last-Modified".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.lastModified = reader.getNullableElement(DateTimeRfc1123::new);
                    continue;
                }
                if ("Etag".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.eTag = reader.getStringElement();
                    continue;
                }
                if ("Content-Length".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.contentLength = reader.getNullableElement(Long::parseLong);
                    continue;
                }
                if ("Content-Type".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.contentType = reader.getStringElement();
                    continue;
                }
                if ("Content-Encoding".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.contentEncoding = reader.getStringElement();
                    continue;
                }
                if ("Content-Language".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.contentLanguage = reader.getStringElement();
                    continue;
                }
                if ("Content-MD5".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.contentMd5 = reader.getBinaryElement();
                    continue;
                }
                if ("Content-Disposition".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.contentDisposition = reader.getStringElement();
                    continue;
                }
                if ("Cache-Control".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.cacheControl = reader.getStringElement();
                    continue;
                }
                if ("x-ms-blob-sequence-number".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.blobSequenceNumber = reader.getNullableElement(Long::parseLong);
                    continue;
                }
                if ("BlobType".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.blobType = BlobType.fromString(reader.getStringElement());
                    continue;
                }
                if ("LeaseStatus".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.leaseStatus = LeaseStatusType.fromString(reader.getStringElement());
                    continue;
                }
                if ("LeaseState".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.leaseState = LeaseStateType.fromString(reader.getStringElement());
                    continue;
                }
                if ("LeaseDuration".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.leaseDuration = LeaseDurationType.fromString(reader.getStringElement());
                    continue;
                }
                if ("CopyId".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.copyId = reader.getStringElement();
                    continue;
                }
                if ("CopyStatus".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.copyStatus = CopyStatusType.fromString(reader.getStringElement());
                    continue;
                }
                if ("CopySource".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.copySource = reader.getStringElement();
                    continue;
                }
                if ("CopyProgress".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.copyProgress = reader.getStringElement();
                    continue;
                }
                if ("CopyCompletionTime".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.copyCompletionTime = reader.getNullableElement(DateTimeRfc1123::new);
                    continue;
                }
                if ("CopyStatusDescription".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.copyStatusDescription = reader.getStringElement();
                    continue;
                }
                if ("ServerEncrypted".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.serverEncrypted = reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("IncrementalCopy".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.incrementalCopy = reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("DestinationSnapshot".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.destinationSnapshot = reader.getStringElement();
                    continue;
                }
                if ("DeletedTime".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.deletedTime = reader.getNullableElement(DateTimeRfc1123::new);
                    continue;
                }
                if ("RemainingRetentionDays".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.remainingRetentionDays = reader.getNullableElement(Integer::parseInt);
                    continue;
                }
                if ("AccessTier".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.accessTier = AccessTier.fromString(reader.getStringElement());
                    continue;
                }
                if ("AccessTierInferred".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.accessTierInferred = reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("ArchiveStatus".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.archiveStatus = ArchiveStatus.fromString(reader.getStringElement());
                    continue;
                }
                if ("CustomerProvidedKeySha256".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.customerProvidedKeySha256 = reader.getStringElement();
                    continue;
                }
                if ("EncryptionScope".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.encryptionScope = reader.getStringElement();
                    continue;
                }
                if ("AccessTierChangeTime".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.accessTierChangeTime = reader.getNullableElement(DateTimeRfc1123::new);
                    continue;
                }
                if ("TagCount".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.tagCount = reader.getNullableElement(Integer::parseInt);
                    continue;
                }
                if ("Expiry-Time".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.expiresOn = reader.getNullableElement(DateTimeRfc1123::new);
                    continue;
                }
                if ("Sealed".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.isSealed = reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("RehydratePriority".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.rehydratePriority = RehydratePriority.fromString(reader.getStringElement());
                    continue;
                }
                if ("LastAccessTime".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.lastAccessedOn = reader.getNullableElement(DateTimeRfc1123::new);
                    continue;
                }
                if ("ImmutabilityPolicyUntilDate".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.immutabilityPolicyExpiresOn = reader.getNullableElement(DateTimeRfc1123::new);
                    continue;
                }
                if ("ImmutabilityPolicyMode".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.immutabilityPolicyMode = BlobImmutabilityPolicyMode.fromString(reader.getStringElement());
                    continue;
                }
                if ("LegalHold".equals(elementName.getLocalPart())) {
                    deserializedBlobItemPropertiesInternal.legalHold = reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                reader.skipElement();
            }
            return deserializedBlobItemPropertiesInternal;
        });
    }
}

