/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.blob.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.DateTimeRfc1123;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.LeaseDurationType;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.LeaseStateType;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.LeaseStatusType;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.PublicAccessType;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlReader;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlSerializable;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlToken;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlWriter;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class BlobContainerItemProperties
implements XmlSerializable<BlobContainerItemProperties> {
    private DateTimeRfc1123 lastModified;
    private String eTag;
    private LeaseStatusType leaseStatus;
    private LeaseStateType leaseState;
    private LeaseDurationType leaseDuration;
    private PublicAccessType publicAccess;
    private Boolean hasImmutabilityPolicy;
    private Boolean hasLegalHold;
    private String defaultEncryptionScope;
    private Boolean encryptionScopeOverridePrevented;
    private DateTimeRfc1123 deletedTime;
    private Integer remainingRetentionDays;
    private Boolean isImmutableStorageWithVersioningEnabled;

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public BlobContainerItemProperties setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public BlobContainerItemProperties setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public LeaseStatusType getLeaseStatus() {
        return this.leaseStatus;
    }

    public BlobContainerItemProperties setLeaseStatus(LeaseStatusType leaseStatus) {
        this.leaseStatus = leaseStatus;
        return this;
    }

    public LeaseStateType getLeaseState() {
        return this.leaseState;
    }

    public BlobContainerItemProperties setLeaseState(LeaseStateType leaseState) {
        this.leaseState = leaseState;
        return this;
    }

    public LeaseDurationType getLeaseDuration() {
        return this.leaseDuration;
    }

    public BlobContainerItemProperties setLeaseDuration(LeaseDurationType leaseDuration) {
        this.leaseDuration = leaseDuration;
        return this;
    }

    public PublicAccessType getPublicAccess() {
        return this.publicAccess;
    }

    public BlobContainerItemProperties setPublicAccess(PublicAccessType publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    public Boolean isHasImmutabilityPolicy() {
        return this.hasImmutabilityPolicy;
    }

    public BlobContainerItemProperties setHasImmutabilityPolicy(Boolean hasImmutabilityPolicy) {
        this.hasImmutabilityPolicy = hasImmutabilityPolicy;
        return this;
    }

    public Boolean isHasLegalHold() {
        return this.hasLegalHold;
    }

    public BlobContainerItemProperties setHasLegalHold(Boolean hasLegalHold) {
        this.hasLegalHold = hasLegalHold;
        return this;
    }

    public String getDefaultEncryptionScope() {
        return this.defaultEncryptionScope;
    }

    public BlobContainerItemProperties setDefaultEncryptionScope(String defaultEncryptionScope) {
        this.defaultEncryptionScope = defaultEncryptionScope;
        return this;
    }

    public boolean isEncryptionScopeOverridePrevented() {
        Boolean returnValue = this.encryptionScopeOverridePrevented;
        return Boolean.TRUE.equals(returnValue);
    }

    public BlobContainerItemProperties setEncryptionScopeOverridePrevented(boolean encryptionScopeOverridePrevented) {
        this.encryptionScopeOverridePrevented = encryptionScopeOverridePrevented;
        return this;
    }

    public OffsetDateTime getDeletedTime() {
        if (this.deletedTime == null) {
            return null;
        }
        return this.deletedTime.getDateTime();
    }

    public BlobContainerItemProperties setDeletedTime(OffsetDateTime deletedTime) {
        this.deletedTime = deletedTime == null ? null : new DateTimeRfc1123(deletedTime);
        return this;
    }

    public Integer getRemainingRetentionDays() {
        return this.remainingRetentionDays;
    }

    public BlobContainerItemProperties setRemainingRetentionDays(Integer remainingRetentionDays) {
        this.remainingRetentionDays = remainingRetentionDays;
        return this;
    }

    public Boolean isImmutableStorageWithVersioningEnabled() {
        return this.isImmutableStorageWithVersioningEnabled;
    }

    public BlobContainerItemProperties setImmutableStorageWithVersioningEnabled(Boolean isImmutableStorageWithVersioningEnabled) {
        this.isImmutableStorageWithVersioningEnabled = isImmutableStorageWithVersioningEnabled;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "BlobContainerItemProperties" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Last-Modified", Objects.toString(this.lastModified, null));
        xmlWriter.writeStringElement("Etag", this.eTag);
        xmlWriter.writeStringElement("LeaseStatus", this.leaseStatus == null ? null : this.leaseStatus.toString());
        xmlWriter.writeStringElement("LeaseState", this.leaseState == null ? null : this.leaseState.toString());
        xmlWriter.writeStringElement("LeaseDuration", this.leaseDuration == null ? null : this.leaseDuration.toString());
        xmlWriter.writeStringElement("PublicAccess", this.publicAccess == null ? null : this.publicAccess.toString());
        xmlWriter.writeBooleanElement("HasImmutabilityPolicy", this.hasImmutabilityPolicy);
        xmlWriter.writeBooleanElement("HasLegalHold", this.hasLegalHold);
        xmlWriter.writeStringElement("DefaultEncryptionScope", this.defaultEncryptionScope);
        xmlWriter.writeBooleanElement("DenyEncryptionScopeOverride", this.encryptionScopeOverridePrevented);
        xmlWriter.writeStringElement("DeletedTime", Objects.toString(this.deletedTime, null));
        xmlWriter.writeNumberElement("RemainingRetentionDays", this.remainingRetentionDays);
        xmlWriter.writeBooleanElement("ImmutableStorageWithVersioningEnabled", this.isImmutableStorageWithVersioningEnabled);
        return xmlWriter.writeEndElement();
    }

    public static BlobContainerItemProperties fromXml(XmlReader xmlReader) throws XMLStreamException {
        return BlobContainerItemProperties.fromXml(xmlReader, null);
    }

    public static BlobContainerItemProperties fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "BlobContainerItemProperties" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            BlobContainerItemProperties deserializedBlobContainerItemProperties = new BlobContainerItemProperties();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Last-Modified".equals(elementName.getLocalPart())) {
                    deserializedBlobContainerItemProperties.lastModified = reader.getNullableElement(DateTimeRfc1123::new);
                    continue;
                }
                if ("Etag".equals(elementName.getLocalPart())) {
                    deserializedBlobContainerItemProperties.eTag = reader.getStringElement();
                    continue;
                }
                if ("LeaseStatus".equals(elementName.getLocalPart())) {
                    deserializedBlobContainerItemProperties.leaseStatus = LeaseStatusType.fromString(reader.getStringElement());
                    continue;
                }
                if ("LeaseState".equals(elementName.getLocalPart())) {
                    deserializedBlobContainerItemProperties.leaseState = LeaseStateType.fromString(reader.getStringElement());
                    continue;
                }
                if ("LeaseDuration".equals(elementName.getLocalPart())) {
                    deserializedBlobContainerItemProperties.leaseDuration = LeaseDurationType.fromString(reader.getStringElement());
                    continue;
                }
                if ("PublicAccess".equals(elementName.getLocalPart())) {
                    deserializedBlobContainerItemProperties.publicAccess = PublicAccessType.fromString(reader.getStringElement());
                    continue;
                }
                if ("HasImmutabilityPolicy".equals(elementName.getLocalPart())) {
                    deserializedBlobContainerItemProperties.hasImmutabilityPolicy = reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("HasLegalHold".equals(elementName.getLocalPart())) {
                    deserializedBlobContainerItemProperties.hasLegalHold = reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("DefaultEncryptionScope".equals(elementName.getLocalPart())) {
                    deserializedBlobContainerItemProperties.defaultEncryptionScope = reader.getStringElement();
                    continue;
                }
                if ("DenyEncryptionScopeOverride".equals(elementName.getLocalPart())) {
                    deserializedBlobContainerItemProperties.encryptionScopeOverridePrevented = reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("DeletedTime".equals(elementName.getLocalPart())) {
                    deserializedBlobContainerItemProperties.deletedTime = reader.getNullableElement(DateTimeRfc1123::new);
                    continue;
                }
                if ("RemainingRetentionDays".equals(elementName.getLocalPart())) {
                    deserializedBlobContainerItemProperties.remainingRetentionDays = reader.getNullableElement(Integer::parseInt);
                    continue;
                }
                if ("ImmutableStorageWithVersioningEnabled".equals(elementName.getLocalPart())) {
                    deserializedBlobContainerItemProperties.isImmutableStorageWithVersioningEnabled = reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                reader.skipElement();
            }
            return deserializedBlobContainerItemProperties;
        });
    }
}

