/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.blob.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.models.PageListHelper;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.ClearRange;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.PageRange;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlReader;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlSerializable;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlToken;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class PageList
implements XmlSerializable<PageList> {
    private List<PageRange> pageRange = new ArrayList<PageRange>();
    private List<ClearRange> clearRange = new ArrayList<ClearRange>();
    private String nextMarker;

    public List<PageRange> getPageRange() {
        return this.pageRange;
    }

    public PageList setPageRange(List<PageRange> pageRange) {
        this.pageRange = pageRange;
        return this;
    }

    public List<ClearRange> getClearRange() {
        return this.clearRange;
    }

    public PageList setClearRange(List<ClearRange> clearRange) {
        this.clearRange = clearRange;
        return this;
    }

    private String getNextMarker() {
        return this.nextMarker;
    }

    private PageList setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "PageList" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        if (this.pageRange != null) {
            for (PageRange pageRange : this.pageRange) {
                xmlWriter.writeXml(pageRange, "PageRange");
            }
        }
        if (this.clearRange != null) {
            for (ClearRange clearRange : this.clearRange) {
                xmlWriter.writeXml(clearRange, "ClearRange");
            }
        }
        xmlWriter.writeStringElement("NextMarker", this.nextMarker);
        return xmlWriter.writeEndElement();
    }

    public static PageList fromXml(XmlReader xmlReader) throws XMLStreamException {
        return PageList.fromXml(xmlReader, null);
    }

    public static PageList fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "PageList" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            PageList deserializedPageList = new PageList();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("PageRange".equals(elementName.getLocalPart())) {
                    deserializedPageList.pageRange.add(PageRange.fromXml(reader, "PageRange"));
                    continue;
                }
                if ("ClearRange".equals(elementName.getLocalPart())) {
                    deserializedPageList.clearRange.add(ClearRange.fromXml(reader, "ClearRange"));
                    continue;
                }
                if ("NextMarker".equals(elementName.getLocalPart())) {
                    deserializedPageList.nextMarker = reader.getStringElement();
                    continue;
                }
                reader.skipElement();
            }
            return deserializedPageList;
        });
    }

    static {
        PageListHelper.setAccessor(new PageListHelper.PageListAccessor(){

            @Override
            public String getNextMarker(PageList pageList) {
                return pageList.getNextMarker();
            }

            @Override
            public PageList setNextMarker(PageList pageList, String marker) {
                return pageList.setNextMarker(marker);
            }
        });
    }
}

