/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.blob.options;

import com.dataiku.dss.shadelibazure.com.azure.core.util.BinaryData;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.AccessTier;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobHttpHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobImmutabilityPolicy;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobRequestConditions;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.ParallelTransferOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation.StorageImplUtils;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Map;

public class BlobParallelUploadOptions {
    private final Flux<ByteBuffer> dataFlux;
    private final InputStream dataStream;
    private final Long length;
    private ParallelTransferOptions parallelTransferOptions;
    private BlobHttpHeaders headers;
    private Map<String, String> metadata;
    private Map<String, String> tags;
    private AccessTier tier;
    private BlobRequestConditions requestConditions;
    private boolean computeMd5;
    private Duration timeout;
    private BlobImmutabilityPolicy immutabilityPolicy;
    private Boolean legalHold;

    public BlobParallelUploadOptions(Flux<ByteBuffer> dataFlux) {
        StorageImplUtils.assertNotNull("dataFlux", dataFlux);
        this.dataFlux = dataFlux;
        this.dataStream = null;
        this.length = null;
    }

    @Deprecated
    public BlobParallelUploadOptions(InputStream dataStream, long length) {
        this(dataStream, (Long)length);
    }

    public BlobParallelUploadOptions(InputStream dataStream) {
        this(dataStream, null);
    }

    private BlobParallelUploadOptions(InputStream dataStream, Long length) {
        StorageImplUtils.assertNotNull("dataStream", dataStream);
        if (length != null) {
            StorageImplUtils.assertInBounds("length", length, 0L, Long.MAX_VALUE);
        }
        this.dataStream = dataStream;
        this.dataFlux = null;
        this.length = length;
    }

    public BlobParallelUploadOptions(BinaryData data) {
        StorageImplUtils.assertNotNull("data", data);
        this.dataFlux = Flux.just(data.toByteBuffer());
        this.dataStream = null;
        this.length = data.getLength();
    }

    public Flux<ByteBuffer> getDataFlux() {
        return this.dataFlux;
    }

    public InputStream getDataStream() {
        return this.dataStream;
    }

    @Deprecated
    public long getLength() {
        return this.length;
    }

    public Long getOptionalLength() {
        return this.length;
    }

    public ParallelTransferOptions getParallelTransferOptions() {
        return this.parallelTransferOptions;
    }

    public BlobParallelUploadOptions setParallelTransferOptions(ParallelTransferOptions parallelTransferOptions) {
        this.parallelTransferOptions = parallelTransferOptions;
        return this;
    }

    public BlobHttpHeaders getHeaders() {
        return this.headers;
    }

    public BlobParallelUploadOptions setHeaders(BlobHttpHeaders headers) {
        this.headers = headers;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public BlobParallelUploadOptions setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public BlobParallelUploadOptions setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public AccessTier getTier() {
        return this.tier;
    }

    public BlobParallelUploadOptions setTier(AccessTier tier) {
        this.tier = tier;
        return this;
    }

    public BlobRequestConditions getRequestConditions() {
        return this.requestConditions;
    }

    public BlobParallelUploadOptions setRequestConditions(BlobRequestConditions requestConditions) {
        this.requestConditions = requestConditions;
        return this;
    }

    public boolean isComputeMd5() {
        return this.computeMd5;
    }

    public BlobParallelUploadOptions setComputeMd5(boolean computeMd5) {
        this.computeMd5 = computeMd5;
        return this;
    }

    @Deprecated
    public Duration getTimeout() {
        return this.timeout;
    }

    @Deprecated
    public BlobParallelUploadOptions setTimeout(Duration timeout2) {
        this.timeout = timeout2;
        return this;
    }

    public BlobImmutabilityPolicy getImmutabilityPolicy() {
        return this.immutabilityPolicy;
    }

    public BlobParallelUploadOptions setImmutabilityPolicy(BlobImmutabilityPolicy immutabilityPolicy) {
        this.immutabilityPolicy = immutabilityPolicy;
        return this;
    }

    public Boolean isLegalHold() {
        return this.legalHold;
    }

    public BlobParallelUploadOptions setLegalHold(Boolean legalHold) {
        this.legalHold = legalHold;
        return this;
    }
}

