/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.blob.specialized;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceClient;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.util.BinaryData;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.BlobAsyncClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.BlobClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.BlobServiceVersion;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.models.EncryptionScope;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.AccessTier;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobHttpHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobRange;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobRequestConditions;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlockBlobItem;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlockList;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlockListType;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.CpkInfo;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.CustomerProvidedKey;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.ParallelTransferOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.options.BlobUploadFromUrlOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.options.BlockBlobCommitBlockListOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.options.BlockBlobListBlocksOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.options.BlockBlobOutputStreamOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.options.BlockBlobSeekableByteChannelWriteOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.options.BlockBlobSimpleUploadOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.options.BlockBlobStageBlockFromUrlOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.options.BlockBlobStageBlockOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.specialized.BlobClientBase;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.specialized.BlobOutputStream;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.specialized.BlockBlobAsyncClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.specialized.SpecializedBlobClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.specialized.StorageSeekableByteChannelBlockBlobWriteBehavior;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.Utility;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation.StorageImplUtils;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation.StorageSeekableByteChannel;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ServiceClient(builder=SpecializedBlobClientBuilder.class)
public final class BlockBlobClient
extends BlobClientBase {
    private static final ClientLogger LOGGER = new ClientLogger(BlockBlobClient.class);
    private final BlockBlobAsyncClient client;
    @Deprecated
    public static final int MAX_UPLOAD_BLOB_BYTES = 0x10000000;
    public static final long MAX_UPLOAD_BLOB_BYTES_LONG = 5242880000L;
    @Deprecated
    public static final int MAX_STAGE_BLOCK_BYTES = 0x6400000;
    public static final long MAX_STAGE_BLOCK_BYTES_LONG = 0xFA000000L;
    public static final int MAX_BLOCKS = 50000;

    BlockBlobClient(BlockBlobAsyncClient client) {
        this(client, client.getHttpPipeline(), client.getAccountUrl(), client.getServiceVersion(), client.getAccountName(), client.getContainerName(), client.getBlobName(), client.getSnapshotId(), client.getCustomerProvidedKey(), new EncryptionScope().setEncryptionScope(client.getEncryptionScope()), client.getVersionId());
    }

    BlockBlobClient(BlockBlobAsyncClient client, HttpPipeline pipeline, String url, BlobServiceVersion serviceVersion, String accountName, String containerName, String blobName, String snapshot, CpkInfo customerProvidedKey, EncryptionScope encryptionScope, String versionId) {
        super(client, pipeline, url, serviceVersion, accountName, containerName, blobName, snapshot, customerProvidedKey, encryptionScope, versionId);
        this.client = client;
    }

    @Override
    public BlockBlobClient getEncryptionScopeClient(String encryptionScope) {
        EncryptionScope finalEncryptionScope = null;
        if (encryptionScope != null) {
            finalEncryptionScope = new EncryptionScope().setEncryptionScope(encryptionScope);
        }
        return new BlockBlobClient(this.client.getEncryptionScopeAsyncClient(encryptionScope), this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getContainerName(), this.getBlobName(), this.getSnapshotId(), this.getCustomerProvidedKey(), finalEncryptionScope, this.getVersionId());
    }

    @Override
    public BlockBlobClient getCustomerProvidedKeyClient(CustomerProvidedKey customerProvidedKey) {
        CpkInfo finalCustomerProvidedKey = null;
        if (customerProvidedKey != null) {
            finalCustomerProvidedKey = new CpkInfo().setEncryptionKey(customerProvidedKey.getKey()).setEncryptionKeySha256(customerProvidedKey.getKeySha256()).setEncryptionAlgorithm(customerProvidedKey.getEncryptionAlgorithm());
        }
        return new BlockBlobClient(this.client.getCustomerProvidedKeyAsyncClient(customerProvidedKey), this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getContainerName(), this.getBlobName(), this.getSnapshotId(), finalCustomerProvidedKey, this.encryptionScope, this.getVersionId());
    }

    public BlobOutputStream getBlobOutputStream() {
        return this.getBlobOutputStream(false);
    }

    public BlobOutputStream getBlobOutputStream(boolean overwrite) {
        BlobRequestConditions requestConditions = null;
        if (!overwrite) {
            if (this.exists().booleanValue()) {
                throw LOGGER.logExceptionAsError(new IllegalArgumentException("Blob already exists. Specify overwrite to true to force update the blob."));
            }
            requestConditions = new BlobRequestConditions().setIfNoneMatch("*");
        }
        return this.getBlobOutputStream(requestConditions);
    }

    public BlobOutputStream getBlobOutputStream(BlobRequestConditions requestConditions) {
        return this.getBlobOutputStream(null, null, null, null, requestConditions);
    }

    public BlobOutputStream getBlobOutputStream(ParallelTransferOptions parallelTransferOptions, BlobHttpHeaders headers, Map<String, String> metadata, AccessTier tier, BlobRequestConditions requestConditions) {
        return this.getBlobOutputStream(new BlockBlobOutputStreamOptions().setParallelTransferOptions(parallelTransferOptions).setHeaders(headers).setMetadata(metadata).setTier(tier).setRequestConditions(requestConditions));
    }

    public BlobOutputStream getBlobOutputStream(BlockBlobOutputStreamOptions options) {
        return this.getBlobOutputStream(options, null);
    }

    public BlobOutputStream getBlobOutputStream(BlockBlobOutputStreamOptions options, Context context) {
        BlobAsyncClient blobClient = this.prepareBuilder().buildAsyncClient();
        return BlobOutputStream.blockBlobOutputStream(blobClient, options, context);
    }

    public SeekableByteChannel openSeekableByteChannelWrite(BlockBlobSeekableByteChannelWriteOptions options) {
        Objects.requireNonNull(options);
        long startingPosition = 0L;
        if (options.getWriteMode() != BlockBlobSeekableByteChannelWriteOptions.WriteMode.OVERWRITE) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("Unsupported value for `options.getWriteMode()`."));
        }
        StorageSeekableByteChannelBlockBlobWriteBehavior.WriteMode internalMode = StorageSeekableByteChannelBlockBlobWriteBehavior.WriteMode.OVERWRITE;
        return new StorageSeekableByteChannel(options.getBlockSizeInBytes() != null ? options.getBlockSizeInBytes().intValue() : 0x400000, new StorageSeekableByteChannelBlockBlobWriteBehavior(this, options.getHeaders(), options.getMetadata(), options.getTags(), options.getTier(), options.getRequestConditions(), internalMode, null), startingPosition);
    }

    private BlobClientBuilder prepareBuilder() {
        BlobClientBuilder builder = new BlobClientBuilder().pipeline(this.getHttpPipeline()).endpoint(this.getBlobUrl()).snapshot(this.getSnapshotId()).serviceVersion(this.getServiceVersion());
        CpkInfo cpk = this.getCustomerProvidedKey();
        if (cpk != null) {
            builder.customerProvidedKey(new CustomerProvidedKey(cpk.getEncryptionKey()));
        }
        return builder;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlockBlobItem upload(InputStream data, long length) {
        return this.upload(data, length, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlockBlobItem upload(BinaryData data) {
        return this.upload(data, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlockBlobItem upload(InputStream data, long length, boolean overwrite) {
        BlobRequestConditions blobRequestConditions = new BlobRequestConditions();
        if (!overwrite) {
            blobRequestConditions.setIfNoneMatch("*");
        }
        return this.uploadWithResponse(data, length, null, null, null, null, blobRequestConditions, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlockBlobItem upload(BinaryData data, boolean overwrite) {
        BlobRequestConditions blobRequestConditions = new BlobRequestConditions();
        if (!overwrite) {
            blobRequestConditions.setIfNoneMatch("*");
        }
        return this.uploadWithResponse(new BlockBlobSimpleUploadOptions(data).setRequestConditions(blobRequestConditions), null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlockBlobItem> uploadWithResponse(InputStream data, long length, BlobHttpHeaders headers, Map<String, String> metadata, AccessTier tier, byte[] contentMd5, BlobRequestConditions requestConditions, Duration timeout2, Context context) {
        return this.uploadWithResponse(new BlockBlobSimpleUploadOptions(data, length).setHeaders(headers).setMetadata(metadata).setTier(tier).setContentMd5(contentMd5).setRequestConditions(requestConditions), timeout2, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlockBlobItem> uploadWithResponse(BlockBlobSimpleUploadOptions options, Duration timeout2, Context context) {
        StorageImplUtils.assertNotNull("options", options);
        Mono<Response<BlockBlobItem>> upload = this.client.uploadWithResponse(options, context);
        try {
            return StorageImplUtils.blockWithOptionalTimeout(upload, timeout2);
        }
        catch (UncheckedIOException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlockBlobItem uploadFromUrl(String sourceUrl) {
        return this.uploadFromUrl(sourceUrl, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlockBlobItem uploadFromUrl(String sourceUrl, boolean overwrite) {
        BlobRequestConditions blobRequestConditions = new BlobRequestConditions();
        if (!overwrite) {
            blobRequestConditions.setIfNoneMatch("*");
        }
        return this.uploadFromUrlWithResponse(new BlobUploadFromUrlOptions(sourceUrl).setDestinationRequestConditions(blobRequestConditions), null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlockBlobItem> uploadFromUrlWithResponse(BlobUploadFromUrlOptions options, Duration timeout2, Context context) {
        StorageImplUtils.assertNotNull("options", options);
        Mono<Response<BlockBlobItem>> upload = this.client.uploadFromUrlWithResponse(options, context);
        try {
            return StorageImplUtils.blockWithOptionalTimeout(upload, timeout2);
        }
        catch (UncheckedIOException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void stageBlock(String base64BlockId, InputStream data, long length) {
        this.stageBlockWithResponse(base64BlockId, data, length, null, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void stageBlock(String base64BlockId, BinaryData data) {
        this.stageBlockWithResponse(new BlockBlobStageBlockOptions(base64BlockId, data), null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> stageBlockWithResponse(String base64BlockId, InputStream data, long length, byte[] contentMd5, String leaseId, Duration timeout2, Context context) {
        StorageImplUtils.assertNotNull("data", data);
        Flux<ByteBuffer> fbb = Utility.convertStreamToByteBuffer(data, length, 0x400000, true);
        Mono<Response<Void>> response = this.client.stageBlockWithResponse(base64BlockId, fbb, length, contentMd5, leaseId, context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout2);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> stageBlockWithResponse(BlockBlobStageBlockOptions options, Duration timeout2, Context context) {
        Objects.requireNonNull(options, "options must not be null");
        Mono<Response<Void>> response = this.client.stageBlockWithResponse(options.getBase64BlockId(), options.getData(), options.getContentMd5(), options.getLeaseId(), context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout2);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void stageBlockFromUrl(String base64BlockId, String sourceUrl, BlobRange sourceRange) {
        this.stageBlockFromUrlWithResponse(base64BlockId, sourceUrl, sourceRange, null, null, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> stageBlockFromUrlWithResponse(String base64BlockId, String sourceUrl, BlobRange sourceRange, byte[] sourceContentMd5, String leaseId, BlobRequestConditions sourceRequestConditions, Duration timeout2, Context context) {
        return this.stageBlockFromUrlWithResponse(new BlockBlobStageBlockFromUrlOptions(base64BlockId, sourceUrl).setSourceRange(sourceRange).setSourceContentMd5(sourceContentMd5).setLeaseId(leaseId).setSourceRequestConditions(sourceRequestConditions), timeout2, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> stageBlockFromUrlWithResponse(BlockBlobStageBlockFromUrlOptions options, Duration timeout2, Context context) {
        Mono<Response<Void>> response = this.client.stageBlockFromUrlWithResponse(options, context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout2);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlockList listBlocks(BlockListType listType) {
        return this.listBlocksWithResponse(listType, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlockList> listBlocksWithResponse(BlockListType listType, String leaseId, Duration timeout2, Context context) {
        return this.listBlocksWithResponse(new BlockBlobListBlocksOptions(listType).setLeaseId(leaseId), timeout2, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlockList> listBlocksWithResponse(BlockBlobListBlocksOptions options, Duration timeout2, Context context) {
        return StorageImplUtils.blockWithOptionalTimeout(this.client.listBlocksWithResponse(options, context), timeout2);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlockBlobItem commitBlockList(List<String> base64BlockIds) {
        return this.commitBlockList(base64BlockIds, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlockBlobItem commitBlockList(List<String> base64BlockIds, boolean overwrite) {
        BlobRequestConditions requestConditions = null;
        if (!overwrite) {
            requestConditions = new BlobRequestConditions().setIfNoneMatch("*");
        }
        return this.commitBlockListWithResponse(base64BlockIds, null, null, null, requestConditions, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlockBlobItem> commitBlockListWithResponse(List<String> base64BlockIds, BlobHttpHeaders headers, Map<String, String> metadata, AccessTier tier, BlobRequestConditions requestConditions, Duration timeout2, Context context) {
        return this.commitBlockListWithResponse(new BlockBlobCommitBlockListOptions(base64BlockIds).setHeaders(headers).setMetadata(metadata).setTier(tier).setRequestConditions(requestConditions), timeout2, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlockBlobItem> commitBlockListWithResponse(BlockBlobCommitBlockListOptions options, Duration timeout2, Context context) {
        Mono<Response<BlockBlobItem>> response = this.client.commitBlockListWithResponse(options, context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout2);
    }
}

