/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.file.share;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.implementation.accesshelpers.FileSmbPropertiesHelper;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models.NtfsFileAttributes;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.EnumSet;

public class FileSmbProperties {
    private String filePermissionKey;
    private EnumSet<NtfsFileAttributes> ntfsFileAttributes;
    private OffsetDateTime fileCreationTime;
    private OffsetDateTime fileLastWriteTime;
    private OffsetDateTime fileChangeTime;
    private final String fileId;
    private final String parentId;

    public FileSmbProperties() {
        this.fileId = null;
        this.parentId = null;
    }

    public String getFilePermissionKey() {
        return this.filePermissionKey;
    }

    public EnumSet<NtfsFileAttributes> getNtfsFileAttributes() {
        return this.ntfsFileAttributes;
    }

    public OffsetDateTime getFileCreationTime() {
        return this.fileCreationTime;
    }

    public OffsetDateTime getFileLastWriteTime() {
        return this.fileLastWriteTime;
    }

    public OffsetDateTime getFileChangeTime() {
        return this.fileChangeTime;
    }

    public String getFileId() {
        return this.fileId;
    }

    public String getParentId() {
        return this.parentId;
    }

    public FileSmbProperties setFilePermissionKey(String filePermissionKey) {
        this.filePermissionKey = filePermissionKey;
        return this;
    }

    public FileSmbProperties setNtfsFileAttributes(EnumSet<NtfsFileAttributes> ntfsFileAttributes) {
        this.ntfsFileAttributes = ntfsFileAttributes;
        return this;
    }

    public FileSmbProperties setFileCreationTime(OffsetDateTime fileCreationTime) {
        this.fileCreationTime = fileCreationTime;
        return this;
    }

    public FileSmbProperties setFileLastWriteTime(OffsetDateTime fileLastWriteTime) {
        this.fileLastWriteTime = fileLastWriteTime;
        return this;
    }

    public FileSmbProperties setFileChangeTime(OffsetDateTime fileChangeTime) {
        this.fileChangeTime = fileChangeTime;
        return this;
    }

    String setFilePermission(String filePermission, String defaultValue) {
        return filePermission == null && this.filePermissionKey == null ? defaultValue : filePermission;
    }

    String setNtfsFileAttributes(String defaultValue) {
        return this.ntfsFileAttributes == null ? defaultValue : NtfsFileAttributes.toString(this.ntfsFileAttributes);
    }

    String setFileCreationTime(String defaultValue) {
        return this.fileCreationTime == null ? defaultValue : FileSmbProperties.parseFileSMBDate(this.fileCreationTime);
    }

    String setFileLastWriteTime(String defaultValue) {
        return this.fileLastWriteTime == null ? defaultValue : FileSmbProperties.parseFileSMBDate(this.fileLastWriteTime);
    }

    String getFileChangeTimeString() {
        return this.fileChangeTime == null ? null : FileSmbProperties.parseFileSMBDate(this.fileChangeTime);
    }

    String getNtfsFileAttributesString() {
        return this.ntfsFileAttributes == null ? null : NtfsFileAttributes.toString(this.ntfsFileAttributes);
    }

    String getFileCreationTimeString() {
        return this.fileCreationTime == null ? null : FileSmbProperties.parseFileSMBDate(this.fileCreationTime);
    }

    String getFileLastWriteTimeString() {
        return this.fileLastWriteTime == null ? null : FileSmbProperties.parseFileSMBDate(this.fileLastWriteTime);
    }

    static String parseFileSMBDate(OffsetDateTime time) {
        return time == null ? null : time.format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'"));
    }

    FileSmbProperties(HttpHeaders httpHeaders) {
        this.filePermissionKey = httpHeaders.getValue("x-ms-file-permission-key");
        String attributes = httpHeaders.getValue("x-ms-file-attributes");
        this.ntfsFileAttributes = attributes == null ? null : NtfsFileAttributes.toAttributes(attributes);
        String fileCreation = httpHeaders.getValue("x-ms-file-creation-time");
        this.fileCreationTime = fileCreation == null ? null : OffsetDateTime.parse(fileCreation);
        String fileLastWrite = httpHeaders.getValue("x-ms-file-last-write-time");
        this.fileLastWriteTime = fileLastWrite == null ? null : OffsetDateTime.parse(fileLastWrite);
        String fileChange = httpHeaders.getValue("x-ms-file-change-time");
        this.fileChangeTime = fileChange == null ? null : OffsetDateTime.parse(fileChange);
        this.fileId = httpHeaders.getValue("x-ms-file-id");
        this.parentId = httpHeaders.getValue("x-ms-file-parent-id");
    }

    static {
        FileSmbPropertiesHelper.setAccessor(FileSmbProperties::new);
    }
}

