/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models;

import java.util.EnumSet;

public enum NtfsFileAttributes {
    READ_ONLY,
    HIDDEN,
    SYSTEM,
    NORMAL,
    DIRECTORY,
    ARCHIVE,
    TEMPORARY,
    OFFLINE,
    NOT_CONTENT_INDEXED,
    NO_SCRUB_DATA;


    public static String toString(EnumSet<NtfsFileAttributes> ntfsAttributes) {
        if (ntfsAttributes == null) {
            return null;
        }
        if (ntfsAttributes.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        NtfsFileAttributes.toStringHelper(builder, ntfsAttributes, READ_ONLY, "ReadOnly");
        NtfsFileAttributes.toStringHelper(builder, ntfsAttributes, HIDDEN, "Hidden");
        NtfsFileAttributes.toStringHelper(builder, ntfsAttributes, SYSTEM, "System");
        NtfsFileAttributes.toStringHelper(builder, ntfsAttributes, NORMAL, "None");
        NtfsFileAttributes.toStringHelper(builder, ntfsAttributes, DIRECTORY, "Directory");
        NtfsFileAttributes.toStringHelper(builder, ntfsAttributes, ARCHIVE, "Archive");
        NtfsFileAttributes.toStringHelper(builder, ntfsAttributes, TEMPORARY, "Temporary");
        NtfsFileAttributes.toStringHelper(builder, ntfsAttributes, OFFLINE, "Offline");
        NtfsFileAttributes.toStringHelper(builder, ntfsAttributes, NOT_CONTENT_INDEXED, "NotContentIndexed");
        NtfsFileAttributes.toStringHelper(builder, ntfsAttributes, NO_SCRUB_DATA, "NoScrubData");
        return builder.toString();
    }

    private static void toStringHelper(StringBuilder sb, EnumSet<NtfsFileAttributes> ntfsAttributes, NtfsFileAttributes attributes, String toAdd) {
        if (ntfsAttributes.contains((Object)attributes)) {
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append(toAdd);
        }
    }

    public static EnumSet<NtfsFileAttributes> toAttributes(String ntfsAttributes) {
        String[] splitAttributes;
        if (ntfsAttributes == null) {
            return null;
        }
        EnumSet<NtfsFileAttributes> attributes = EnumSet.noneOf(NtfsFileAttributes.class);
        for (String sa : splitAttributes = ntfsAttributes.split("\\|")) {
            if ("ReadOnly".equals(sa = sa.trim())) {
                attributes.add(READ_ONLY);
                continue;
            }
            if ("Hidden".equals(sa)) {
                attributes.add(HIDDEN);
                continue;
            }
            if ("System".equals(sa)) {
                attributes.add(SYSTEM);
                continue;
            }
            if ("None".equals(sa)) {
                attributes.add(NORMAL);
                continue;
            }
            if ("Directory".equals(sa)) {
                attributes.add(DIRECTORY);
                continue;
            }
            if ("Archive".equals(sa)) {
                attributes.add(ARCHIVE);
                continue;
            }
            if ("Temporary".equals(sa)) {
                attributes.add(TEMPORARY);
                continue;
            }
            if ("Offline".equals(sa)) {
                attributes.add(OFFLINE);
                continue;
            }
            if ("NotContentIndexed".equals(sa)) {
                attributes.add(NOT_CONTENT_INDEXED);
                continue;
            }
            if ("NoScrubData".equals(sa)) {
                attributes.add(NO_SCRUB_DATA);
                continue;
            }
            throw new IllegalArgumentException("FileAttribute '" + sa + "' not recognized.");
        }
        return attributes;
    }
}

