/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.FileSmbProperties;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.implementation.accesshelpers.ShareFilePropertiesHelper;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models.CopyStatusType;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models.FilePosixProperties;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models.LeaseDurationType;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models.LeaseStateType;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models.LeaseStatusType;
import java.time.OffsetDateTime;
import java.util.Map;

public final class ShareFileProperties {
    private final String eTag;
    private final OffsetDateTime lastModified;
    private final Map<String, String> metadata;
    private final String fileType;
    private final Long contentLength;
    private final String contentType;
    private final byte[] contentMd5;
    private final String contentEncoding;
    private final String cacheControl;
    private final String contentDisposition;
    private final LeaseStatusType leaseStatus;
    private final LeaseStateType leaseState;
    private final LeaseDurationType leaseDuration;
    private final OffsetDateTime copyCompletionTime;
    private final String copyStatusDescription;
    private final String copyId;
    private final String copyProgress;
    private final String copySource;
    private final CopyStatusType copyStatus;
    private final Boolean isServerEncrypted;
    private final FileSmbProperties smbProperties;
    private final FilePosixProperties posixProperties;

    public ShareFileProperties(String eTag, OffsetDateTime lastModified, Map<String, String> metadata, String fileType, Long contentLength, String contentType, byte[] contentMd5, String contentEncoding, String cacheControl, String contentDisposition, OffsetDateTime copyCompletionTime, String copyStatusDescription, String copyId, String copyProgress, String copySource, CopyStatusType copyStatus, Boolean isServerEncrypted, FileSmbProperties smbProperties) {
        this(eTag, lastModified, metadata, fileType, contentLength, contentType, contentMd5, contentEncoding, cacheControl, contentDisposition, null, null, null, copyCompletionTime, copyStatusDescription, copyId, copyProgress, copySource, copyStatus, isServerEncrypted, smbProperties);
    }

    public ShareFileProperties(String eTag, OffsetDateTime lastModified, Map<String, String> metadata, String fileType, Long contentLength, String contentType, byte[] contentMd5, String contentEncoding, String cacheControl, String contentDisposition, LeaseStatusType leaseStatusType, LeaseStateType leaseStateType, LeaseDurationType leaseDurationType, OffsetDateTime copyCompletionTime, String copyStatusDescription, String copyId, String copyProgress, String copySource, CopyStatusType copyStatus, Boolean isServerEncrypted, FileSmbProperties smbProperties) {
        this.eTag = eTag;
        this.lastModified = lastModified;
        this.metadata = metadata;
        this.fileType = fileType;
        this.contentLength = contentLength;
        this.contentType = contentType;
        this.contentMd5 = CoreUtils.clone(contentMd5);
        this.contentEncoding = contentEncoding;
        this.cacheControl = cacheControl;
        this.contentDisposition = contentDisposition;
        this.leaseStatus = leaseStatusType;
        this.leaseState = leaseStateType;
        this.leaseDuration = leaseDurationType;
        this.copyCompletionTime = copyCompletionTime;
        this.copyStatusDescription = copyStatusDescription;
        this.copyId = copyId;
        this.copyProgress = copyProgress;
        this.copySource = copySource;
        this.copyStatus = copyStatus;
        this.isServerEncrypted = isServerEncrypted;
        this.smbProperties = smbProperties;
        this.posixProperties = null;
    }

    private ShareFileProperties(String eTag, OffsetDateTime lastModified, Map<String, String> metadata, String fileType, Long contentLength, String contentType, byte[] contentMd5, String contentEncoding, String cacheControl, String contentDisposition, LeaseStatusType leaseStatusType, LeaseStateType leaseStateType, LeaseDurationType leaseDurationType, OffsetDateTime copyCompletionTime, String copyStatusDescription, String copyId, String copyProgress, String copySource, CopyStatusType copyStatus, Boolean isServerEncrypted, FileSmbProperties smbProperties, FilePosixProperties posixProperties) {
        this.eTag = eTag;
        this.lastModified = lastModified;
        this.metadata = metadata;
        this.fileType = fileType;
        this.contentLength = contentLength;
        this.contentType = contentType;
        this.contentMd5 = CoreUtils.clone(contentMd5);
        this.contentEncoding = contentEncoding;
        this.cacheControl = cacheControl;
        this.contentDisposition = contentDisposition;
        this.leaseStatus = leaseStatusType;
        this.leaseState = leaseStateType;
        this.leaseDuration = leaseDurationType;
        this.copyCompletionTime = copyCompletionTime;
        this.copyStatusDescription = copyStatusDescription;
        this.copyId = copyId;
        this.copyProgress = copyProgress;
        this.copySource = copySource;
        this.copyStatus = copyStatus;
        this.isServerEncrypted = isServerEncrypted;
        this.smbProperties = smbProperties;
        this.posixProperties = posixProperties;
    }

    public String getETag() {
        return this.eTag;
    }

    public OffsetDateTime getLastModified() {
        return this.lastModified;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public String getFileType() {
        return this.fileType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public byte[] getContentMd5() {
        return CoreUtils.clone(this.contentMd5);
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public LeaseStatusType getLeaseStatus() {
        return this.leaseStatus;
    }

    public LeaseStateType getLeaseState() {
        return this.leaseState;
    }

    public LeaseDurationType getLeaseDuration() {
        return this.leaseDuration;
    }

    public OffsetDateTime getCopyCompletionTime() {
        return this.copyCompletionTime;
    }

    public String getCopyStatusDescription() {
        return this.copyStatusDescription;
    }

    public String getCopyId() {
        return this.copyId;
    }

    public String getCopyProgress() {
        return this.copyProgress;
    }

    public String getCopySource() {
        return this.copySource;
    }

    public CopyStatusType getCopyStatus() {
        return this.copyStatus;
    }

    public Boolean isServerEncrypted() {
        return this.isServerEncrypted;
    }

    public FileSmbProperties getSmbProperties() {
        return this.smbProperties;
    }

    public FilePosixProperties getPosixProperties() {
        return this.posixProperties;
    }

    static {
        ShareFilePropertiesHelper.setAccessor(ShareFileProperties::new);
    }
}

