/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j;

import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.MsalClientException;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.MsalRequest;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.OAuthAuthorizationGrant;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.OnBehalfOfParameters;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4j.RequestContext;
import com.dataiku.dss.shadelibazure.com.nimbusds.jwt.SignedJWT;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.JWTBearerGrant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

class OnBehalfOfRequest
extends MsalRequest {
    OnBehalfOfParameters parameters;

    OnBehalfOfRequest(OnBehalfOfParameters parameters, ConfidentialClientApplication application, RequestContext requestContext) {
        super(application, OnBehalfOfRequest.createAuthenticationGrant(parameters), requestContext);
        this.parameters = parameters;
    }

    private static OAuthAuthorizationGrant createAuthenticationGrant(OnBehalfOfParameters parameters) {
        JWTBearerGrant jWTBearerGrant;
        try {
            jWTBearerGrant = new JWTBearerGrant(SignedJWT.parse(parameters.userAssertion().getAssertion()));
        }
        catch (Exception e) {
            throw new MsalClientException(e);
        }
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("requested_token_use", Collections.singletonList("on_behalf_of"));
        if (parameters.claims() != null) {
            params.put("claims", Collections.singletonList(parameters.claims().formatAsJSONString()));
        }
        return new OAuthAuthorizationGrant((AuthorizationGrant)jWTBearerGrant, String.join((CharSequence)" ", parameters.scopes()), params);
    }

    OnBehalfOfParameters parameters() {
        return this.parameters;
    }
}

