/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.ciba;

import com.dataiku.dss.shadelibazure.com.nimbusds.common.contenttype.ContentType;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.ParseException;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.ciba.AuthRequestID;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.ciba.CIBAPushCallback;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.token.Tokens;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.dataiku.dss.shadelibazure.com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import com.dataiku.dss.shadelibazure.net.jcip.annotations.Immutable;
import com.dataiku.dss.shadelibazure.net.minidev.json.JSONObject;
import java.net.URI;
import java.util.Objects;

@Immutable
public class CIBATokenDelivery
extends CIBAPushCallback {
    private final Tokens tokens;

    public CIBATokenDelivery(URI endpoint, BearerAccessToken accessToken, AuthRequestID authRequestID, Tokens tokens) {
        super(endpoint, accessToken, authRequestID);
        this.tokens = Objects.requireNonNull(tokens);
    }

    public CIBATokenDelivery(URI endpoint, BearerAccessToken accessToken, AuthRequestID authRequestID, OIDCTokens oidcTokens) {
        super(endpoint, accessToken, authRequestID);
        this.tokens = Objects.requireNonNull(oidcTokens);
    }

    @Override
    public boolean indicatesSuccess() {
        return true;
    }

    public Tokens getTokens() {
        return this.tokens;
    }

    public OIDCTokens getOIDCTokens() {
        return this.getTokens() instanceof OIDCTokens ? this.getTokens().toOIDCTokens() : null;
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.POST, this.getEndpointURI());
        httpRequest.setAuthorization(this.getAccessToken().toAuthorizationHeader());
        httpRequest.setEntityContentType(ContentType.APPLICATION_JSON);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("auth_req_id", this.getAuthRequestID().getValue());
        jsonObject.putAll(this.getTokens().toJSONObject());
        httpRequest.setBody(jsonObject.toJSONString());
        return httpRequest;
    }

    public static CIBATokenDelivery parse(HTTPRequest httpRequest) throws ParseException {
        URI uri = httpRequest.getURI();
        httpRequest.ensureMethod(HTTPRequest.Method.POST);
        httpRequest.ensureEntityContentType(ContentType.APPLICATION_JSON);
        BearerAccessToken clientNotificationToken = BearerAccessToken.parse(httpRequest);
        JSONObject jsonObject = httpRequest.getBodyAsJSONObject();
        AuthRequestID authRequestID = AuthRequestID.parse(JSONObjectUtils.getNonBlankString(jsonObject, "auth_req_id"));
        if (jsonObject.get("id_token") != null) {
            return new CIBATokenDelivery(uri, clientNotificationToken, authRequestID, OIDCTokens.parse(jsonObject));
        }
        return new CIBATokenDelivery(uri, clientNotificationToken, authRequestID, Tokens.parse(jsonObject));
    }
}

