/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.client;

import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.ParseException;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.ProtectedResourceRequest;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.SerializeException;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.dataiku.dss.shadelibazure.net.jcip.annotations.Immutable;
import java.net.URI;
import java.util.Objects;

@Immutable
public class ClientDeleteRequest
extends ProtectedResourceRequest {
    public ClientDeleteRequest(URI endpoint, BearerAccessToken accessToken) {
        super(endpoint, Objects.requireNonNull(accessToken));
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.DELETE, this.getEndpointURI());
        httpRequest.setAuthorization(this.getAccessToken().toAuthorizationHeader());
        return httpRequest;
    }

    public static ClientDeleteRequest parse(HTTPRequest httpRequest) throws ParseException {
        httpRequest.ensureMethod(HTTPRequest.Method.DELETE);
        return new ClientDeleteRequest(httpRequest.getURI(), BearerAccessToken.parse(httpRequest.getAuthorization()));
    }
}

