/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.client;

import com.dataiku.dss.shadelibazure.com.nimbusds.common.contenttype.ContentType;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.ParseException;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.SuccessResponse;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.client.ClientInformation;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.client.ClientRegistrationResponse;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.dataiku.dss.shadelibazure.net.jcip.annotations.Immutable;
import java.util.Objects;

@Immutable
public class ClientInformationResponse
extends ClientRegistrationResponse
implements SuccessResponse {
    private final ClientInformation clientInfo;
    private final boolean forNewClient;

    public ClientInformationResponse(ClientInformation clientInfo, boolean forNewClient) {
        this.clientInfo = Objects.requireNonNull(clientInfo);
        this.forNewClient = forNewClient;
    }

    @Override
    public boolean indicatesSuccess() {
        return true;
    }

    public ClientInformation getClientInformation() {
        return this.clientInfo;
    }

    public boolean isForNewClient() {
        return this.forNewClient;
    }

    @Override
    public HTTPResponse toHTTPResponse() {
        HTTPResponse httpResponse = new HTTPResponse(this.forNewClient ? 201 : 200);
        httpResponse.setEntityContentType(ContentType.APPLICATION_JSON);
        httpResponse.setCacheControl("no-store");
        httpResponse.setPragma("no-cache");
        httpResponse.setBody(this.clientInfo.toJSONObject().toString());
        return httpResponse;
    }

    public static ClientInformationResponse parse(HTTPResponse httpResponse) throws ParseException {
        httpResponse.ensureStatusCode(200, 201);
        ClientInformation clientInfo = ClientInformation.parse(httpResponse.getBodyAsJSONObject());
        boolean forNewClient = 201 == httpResponse.getStatusCode();
        return new ClientInformationResponse(clientInfo, forNewClient);
    }
}

