/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.nimbusds.openid.connect.sdk.federation.trust.marks;

import com.dataiku.dss.shadelibazure.com.nimbusds.jwt.JWTClaimsSet;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.ParseException;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.id.Identifier;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.id.Issuer;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.id.Subject;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.util.StringUtils;
import com.dataiku.dss.shadelibazure.com.nimbusds.openid.connect.sdk.claims.CommonClaimsSet;
import java.net.URI;
import java.util.Date;

public class TrustMarkClaimsSet
extends CommonClaimsSet {
    public static final String ID_CLAIM_NAME = "id";
    public static final String LOGO_URI_CLAIM_NAME = "logo_uri";
    public static final String EXP_CLAIM_NAME = "exp";
    public static final String REF_CLAIM_NAME = "ref";

    public TrustMarkClaimsSet(Issuer iss, Subject sub, Identifier id, Date iat) {
        this.setClaim("iss", iss.getValue());
        this.setClaim("sub", sub.getValue());
        this.setClaim(ID_CLAIM_NAME, id.getValue());
        this.setDateClaim("iat", iat);
    }

    public TrustMarkClaimsSet(JWTClaimsSet jwtClaimsSet) throws ParseException {
        super(JSONObjectUtils.toJSONObject(jwtClaimsSet));
        this.validateRequiredClaimsPresence();
    }

    public void validateRequiredClaimsPresence() throws ParseException {
        if (this.getIssuer() == null) {
            throw new ParseException("Missing iss (issuer) claim");
        }
        if (this.getSubject() == null) {
            throw new ParseException("Missing sub (subject) claim");
        }
        if (this.getID() == null) {
            throw new ParseException("Missing id (identifier) claim");
        }
        if (this.getIssueTime() == null) {
            throw new ParseException("Missing iat (issued-at) claim");
        }
    }

    public Identifier getID() {
        String idString = this.getStringClaim(ID_CLAIM_NAME);
        if (StringUtils.isBlank(idString)) {
            return null;
        }
        return new Identifier(idString);
    }

    public URI getLogoURI() {
        return this.getURIClaim(LOGO_URI_CLAIM_NAME);
    }

    public void setMark(URI markURI) {
        this.setURIClaim(LOGO_URI_CLAIM_NAME, markURI);
    }

    public Date getExpirationTime() {
        return this.getDateClaim(EXP_CLAIM_NAME);
    }

    public void setExpirationTime(Date exp) {
        this.setDateClaim(EXP_CLAIM_NAME, exp);
    }

    public URI getReference() {
        return this.getURIClaim(REF_CLAIM_NAME);
    }

    public void setReference(URI refURI) {
        this.setURIClaim(REF_CLAIM_NAME, refURI);
    }
}

