/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.io.netty.handler.codec.dns;

import com.dataiku.dss.shadelibazure.io.netty.buffer.ByteBuf;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelHandlerContext;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.dns.DefaultDnsQuery;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.dns.DnsMessageUtil;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.dns.DnsOpCode;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.dns.DnsQuery;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.dns.DnsRecordDecoder;
import com.dataiku.dss.shadelibazure.io.netty.util.internal.ObjectUtil;

public final class TcpDnsQueryDecoder
extends LengthFieldBasedFrameDecoder {
    private final DnsRecordDecoder decoder;

    public TcpDnsQueryDecoder() {
        this(DnsRecordDecoder.DEFAULT, 65535);
    }

    public TcpDnsQueryDecoder(DnsRecordDecoder decoder, int maxFrameLength) {
        super(maxFrameLength, 0, 2, 0, 2);
        this.decoder = ObjectUtil.checkNotNull(decoder, "decoder");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object decode(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        ByteBuf frame = (ByteBuf)super.decode(ctx, in);
        if (frame == null) {
            return null;
        }
        try {
            DnsQuery dnsQuery = DnsMessageUtil.decodeDnsQuery(this.decoder, frame.slice(), new DnsMessageUtil.DnsQueryFactory(){

                @Override
                public DnsQuery newQuery(int id, DnsOpCode dnsOpCode) {
                    return new DefaultDnsQuery(id, dnsOpCode);
                }
            });
            return dnsQuery;
        }
        finally {
            frame.release();
        }
    }
}

