/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.core.publisher;

import com.dataiku.dss.shadelibazure.org.reactivestreams.Subscription;
import com.dataiku.dss.shadelibazure.reactor.core.CoreSubscriber;
import com.dataiku.dss.shadelibazure.reactor.core.Fuseable;
import com.dataiku.dss.shadelibazure.reactor.core.Scannable;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.FluxFlatMap;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.InnerConsumer;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.InternalMonoOperator;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Operators;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import com.dataiku.dss.shadelibazure.reactor.util.context.Context;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import java.util.stream.Stream;

final class MonoFlatMap<T, R>
extends InternalMonoOperator<T, R>
implements Fuseable {
    final Function<? super T, ? extends Mono<? extends R>> mapper;

    MonoFlatMap(Mono<? extends T> source2, Function<? super T, ? extends Mono<? extends R>> mapper) {
        super(source2);
        this.mapper = Objects.requireNonNull(mapper, "mapper");
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super R> actual) {
        if (FluxFlatMap.trySubscribeScalarMap(this.source, actual, this.mapper, true, false)) {
            return null;
        }
        FlatMapMain<? super T, ? super R> manager = new FlatMapMain<T, R>(actual, this.mapper);
        actual.onSubscribe(manager);
        return manager;
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return super.scanUnsafe(key);
    }

    static final class FlatMapInner<R>
    implements InnerConsumer<R> {
        final FlatMapMain<?, R> parent;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<FlatMapInner, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(FlatMapInner.class, Subscription.class, "s");
        boolean done;

        FlatMapInner(FlatMapMain<?, R> parent) {
            this.parent = parent;
        }

        @Override
        public Context currentContext() {
            return this.parent.currentContext();
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.ACTUAL) {
                return this.parent;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.done;
            }
            if (key == Scannable.Attr.CANCELLED) {
                return this.s == Operators.cancelledSubscription();
            }
            if (key == Scannable.Attr.RUN_STYLE) {
                return Scannable.Attr.RunStyle.SYNC;
            }
            return null;
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (Operators.setOnce(S, this, s2)) {
                s2.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(R t) {
            if (this.done) {
                Operators.onNextDropped(t, this.parent.currentContext());
                return;
            }
            this.done = true;
            this.parent.complete(t);
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t, this.parent.currentContext());
                return;
            }
            this.done = true;
            this.parent.secondError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.parent.secondComplete();
        }

        void cancel() {
            Operators.terminate(S, this);
        }
    }

    static final class FlatMapMain<T, R>
    extends Operators.MonoSubscriber<T, R> {
        final Function<? super T, ? extends Mono<? extends R>> mapper;
        final FlatMapInner<R> second;
        boolean done;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<FlatMapMain, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(FlatMapMain.class, Subscription.class, "s");

        FlatMapMain(CoreSubscriber<? super R> subscriber, Function<? super T, ? extends Mono<? extends R>> mapper) {
            super(subscriber);
            this.mapper = mapper;
            this.second = new FlatMapInner(this);
        }

        @Override
        public Stream<? extends Scannable> inners() {
            return Stream.of(this.second);
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.CANCELLED) {
                return this.s == Operators.cancelledSubscription();
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.done;
            }
            if (key == Scannable.Attr.RUN_STYLE) {
                return Scannable.Attr.RunStyle.SYNC;
            }
            return super.scanUnsafe(key);
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (Operators.setOnce(S, this, s2)) {
                s2.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            Mono<R> m3;
            if (this.done) {
                Operators.onNextDropped(t, this.actual.currentContext());
                return;
            }
            this.done = true;
            try {
                m3 = Objects.requireNonNull(this.mapper.apply(t), "The mapper returned a null Mono");
            }
            catch (Throwable ex) {
                this.actual.onError(Operators.onOperatorError(this.s, ex, t, this.actual.currentContext()));
                return;
            }
            if (m3 instanceof Callable) {
                Object v;
                Callable c = (Callable)((Object)m3);
                try {
                    v = c.call();
                }
                catch (Throwable ex) {
                    this.actual.onError(Operators.onOperatorError(this.s, ex, t, this.actual.currentContext()));
                    return;
                }
                if (v == null) {
                    this.actual.onComplete();
                } else {
                    this.complete(v);
                }
                return;
            }
            try {
                m3.subscribe(this.second);
            }
            catch (Throwable e) {
                this.actual.onError(Operators.onOperatorError(this, e, t, this.actual.currentContext()));
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t, this.actual.currentContext());
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        @Override
        public void cancel() {
            super.cancel();
            Operators.terminate(S, this);
            this.second.cancel();
        }

        void secondError(Throwable ex) {
            this.actual.onError(ex);
        }

        void secondComplete() {
            this.actual.onComplete();
        }
    }
}

