/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.core.publisher;

import com.dataiku.dss.shadelibazure.reactor.core.CoreSubscriber;
import com.dataiku.dss.shadelibazure.reactor.core.Scannable;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.ParallelFlux;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import com.dataiku.dss.shadelibazure.reactor.util.function.Tuple2;
import com.dataiku.dss.shadelibazure.reactor.util.function.Tuples;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

final class ParallelFluxName<T>
extends ParallelFlux<T>
implements Scannable {
    final ParallelFlux<T> source;
    final String name;
    final Set<Tuple2<String, String>> tags;

    static <T> ParallelFlux<T> createOrAppend(ParallelFlux<T> source2, String name) {
        Objects.requireNonNull(name, "name");
        if (source2 instanceof ParallelFluxName) {
            ParallelFluxName s2 = (ParallelFluxName)source2;
            return new ParallelFluxName<T>(s2.source, name, s2.tags);
        }
        return new ParallelFluxName<T>(source2, name, null);
    }

    static <T> ParallelFlux<T> createOrAppend(ParallelFlux<T> source2, String tagName, String tagValue) {
        Objects.requireNonNull(tagName, "tagName");
        Objects.requireNonNull(tagValue, "tagValue");
        Set<Tuple2<String, String>> tags = Collections.singleton(Tuples.of(tagName, tagValue));
        if (source2 instanceof ParallelFluxName) {
            ParallelFluxName s2 = (ParallelFluxName)source2;
            if (s2.tags != null) {
                tags = new HashSet<Tuple2<String, String>>(tags);
                tags.addAll(s2.tags);
            }
            return new ParallelFluxName<T>(s2.source, s2.name, tags);
        }
        return new ParallelFluxName<T>(source2, null, tags);
    }

    ParallelFluxName(ParallelFlux<T> source2, @Nullable String name, @Nullable Set<Tuple2<String, String>> tags) {
        this.source = source2;
        this.name = name;
        this.tags = tags;
    }

    @Override
    public int getPrefetch() {
        return this.source.getPrefetch();
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.NAME) {
            return this.name;
        }
        if (key == Scannable.Attr.TAGS && this.tags != null) {
            return this.tags.stream();
        }
        if (key == Scannable.Attr.PARENT) {
            return this.source;
        }
        if (key == Scannable.Attr.PREFETCH) {
            return this.getPrefetch();
        }
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return null;
    }

    @Override
    public void subscribe(CoreSubscriber<? super T>[] subscribers) {
        this.source.subscribe(subscribers);
    }
}

