/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty;

import com.dataiku.dss.shadelibazure.io.netty.channel.Channel;
import com.dataiku.dss.shadelibazure.io.netty.channel.socket.DatagramChannel;
import com.dataiku.dss.shadelibazure.io.netty.channel.unix.DomainDatagramChannel;
import com.dataiku.dss.shadelibazure.reactor.core.CoreSubscriber;
import com.dataiku.dss.shadelibazure.reactor.core.Disposable;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.netty.FutureMono;
import com.dataiku.dss.shadelibazure.reactor.netty.ReactorNetty;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Objects;

@FunctionalInterface
public interface DisposableChannel
extends Disposable {
    default public SocketAddress address() {
        Channel c = this.channel();
        if (c instanceof DatagramChannel || c instanceof DomainDatagramChannel) {
            SocketAddress a = c.remoteAddress();
            return a != null ? a : c.localAddress();
        }
        return c.remoteAddress();
    }

    public Channel channel();

    @Override
    default public void dispose() {
        this.channel().close();
    }

    default public void disposeNow() {
        this.disposeNow(Duration.ofSeconds(3L));
    }

    default public void disposeNow(Duration timeout2) {
        if (this.isDisposed()) {
            return;
        }
        Objects.requireNonNull(timeout2, "timeout");
        this.dispose();
        try {
            this.onDispose().block(timeout2);
        }
        catch (IllegalStateException e) {
            if (e.getMessage().contains("blocking read")) {
                throw new IllegalStateException("Socket couldn't be stopped within " + timeout2.toMillis() + "ms");
            }
            throw e;
        }
    }

    default public CoreSubscriber<Void> disposeSubscriber() {
        return new ReactorNetty.ChannelDisposer(this);
    }

    @Override
    default public boolean isDisposed() {
        return !this.channel().isActive();
    }

    default public Mono<Void> onDispose() {
        return FutureMono.from(this.channel().closeFuture());
    }

    default public DisposableChannel onDispose(Disposable onDispose) {
        Objects.requireNonNull(onDispose, "onDispose");
        this.onDispose().subscribe(null, e -> onDispose.dispose(), onDispose::dispose);
        return this;
    }
}

