/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.http.client;

import com.dataiku.dss.shadelibazure.io.netty.buffer.ByteBuf;
import com.dataiku.dss.shadelibazure.io.netty.buffer.ByteBufHolder;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelDuplexHandler;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelHandlerContext;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelPromise;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpRequest;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpResponse;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.LastHttpContent;
import com.dataiku.dss.shadelibazure.io.netty.util.concurrent.Future;
import com.dataiku.dss.shadelibazure.io.netty.util.concurrent.GenericFutureListener;
import com.dataiku.dss.shadelibazure.reactor.netty.ReactorNetty;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.ChannelOperations;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.HttpClientMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.HttpClientOperations;
import com.dataiku.dss.shadelibazure.reactor.util.Logger;
import com.dataiku.dss.shadelibazure.reactor.util.Loggers;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import com.dataiku.dss.shadelibazure.reactor.util.context.ContextView;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.function.Function;

abstract class AbstractHttpClientMetricsHandler
extends ChannelDuplexHandler {
    private static final Logger log = Loggers.getLogger(AbstractHttpClientMetricsHandler.class);
    final SocketAddress remoteAddress;
    String path;
    String method;
    String status;
    ContextView contextView;
    long dataReceived;
    long dataSent;
    long dataReceivedTime;
    long dataSentTime;
    final Function<String, String> uriTagValue;
    int lastReadSeq;
    int lastWriteSeq;

    protected AbstractHttpClientMetricsHandler(SocketAddress remoteAddress, @Nullable Function<String, String> uriTagValue) {
        this.remoteAddress = remoteAddress;
        this.uriTagValue = uriTagValue;
    }

    protected AbstractHttpClientMetricsHandler(AbstractHttpClientMetricsHandler copy) {
        this.contextView = copy.contextView;
        this.dataReceived = copy.dataReceived;
        this.dataReceivedTime = copy.dataReceivedTime;
        this.dataSent = copy.dataSent;
        this.dataSentTime = copy.dataSentTime;
        this.method = copy.method;
        this.path = copy.path;
        this.remoteAddress = copy.remoteAddress;
        this.status = copy.status;
        this.uriTagValue = copy.uriTagValue;
        this.lastWriteSeq = copy.lastWriteSeq;
        this.lastReadSeq = copy.lastReadSeq;
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        block4: {
            try {
                if (msg instanceof HttpRequest) {
                    this.extractDetailsFromHttpRequest(ctx, (HttpRequest)msg);
                }
                this.dataSent += this.extractProcessedDataFromBuffer(msg);
                if (msg instanceof LastHttpContent) {
                    int currentLastWriteSeq = this.lastWriteSeq;
                    promise.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                        block3: {
                            try {
                                if (currentLastWriteSeq == this.lastWriteSeq) {
                                    this.lastWriteSeq = this.lastWriteSeq + 1 & Integer.MAX_VALUE;
                                    this.recordWrite(this.remoteAddress);
                                }
                            }
                            catch (RuntimeException e) {
                                if (!log.isWarnEnabled()) break block3;
                                log.warn(ReactorNetty.format(ctx.channel(), "Exception caught while recording metrics."), e);
                            }
                        }
                    }));
                }
            }
            catch (RuntimeException e) {
                if (!log.isWarnEnabled()) break block4;
                log.warn(ReactorNetty.format(ctx.channel(), "Exception caught while recording metrics."), e);
            }
        }
        ctx.write(msg, promise);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        block5: {
            try {
                if (msg instanceof HttpResponse) {
                    this.status = ((HttpResponse)msg).status().codeAsText().toString();
                    this.dataReceivedTime = System.nanoTime();
                }
                this.dataReceived += this.extractProcessedDataFromBuffer(msg);
                if (msg instanceof LastHttpContent) {
                    this.lastReadSeq = this.lastReadSeq + 1 & Integer.MAX_VALUE;
                    if (this.lastReadSeq > this.lastWriteSeq || this.lastReadSeq == 0 && this.lastWriteSeq == Integer.MAX_VALUE) {
                        this.lastWriteSeq = this.lastWriteSeq + 1 & Integer.MAX_VALUE;
                        this.recordWrite(this.remoteAddress);
                    }
                    this.recordRead(this.remoteAddress);
                    this.reset();
                }
            }
            catch (RuntimeException e) {
                if (!log.isWarnEnabled()) break block5;
                log.warn(ReactorNetty.format(ctx.channel(), "Exception caught while recording metrics."), e);
            }
        }
        ctx.fireChannelRead(msg);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        block2: {
            try {
                this.recordException(ctx);
            }
            catch (RuntimeException e) {
                if (!log.isWarnEnabled()) break block2;
                log.warn(ReactorNetty.format(ctx.channel(), "Exception caught while recording metrics."), e);
            }
        }
        ctx.fireExceptionCaught(cause);
    }

    private void extractDetailsFromHttpRequest(ChannelHandlerContext ctx, HttpRequest request) {
        this.method = request.method().name();
        ChannelOperations<?, ?> channelOps = ChannelOperations.get(ctx.channel());
        if (channelOps instanceof HttpClientOperations) {
            HttpClientOperations ops = (HttpClientOperations)channelOps;
            this.path = this.uriTagValue == null ? ops.path : this.uriTagValue.apply(ops.path);
            this.contextView = ops.currentContextView();
        }
        this.dataSentTime = System.nanoTime();
    }

    private long extractProcessedDataFromBuffer(Object msg) {
        if (msg instanceof ByteBufHolder) {
            return ((ByteBufHolder)msg).content().readableBytes();
        }
        if (msg instanceof ByteBuf) {
            return ((ByteBuf)msg).readableBytes();
        }
        return 0L;
    }

    protected abstract HttpClientMetricsRecorder recorder();

    protected void recordException(ChannelHandlerContext ctx) {
        this.recorder().incrementErrorsCount(this.remoteAddress, this.path != null ? this.path : this.resolveUri(ctx));
    }

    protected void recordRead(SocketAddress address) {
        this.recorder().recordDataReceivedTime(address, this.path, this.method, this.status, Duration.ofNanos(System.nanoTime() - this.dataReceivedTime));
        this.recorder().recordResponseTime(address, this.path, this.method, this.status, Duration.ofNanos(System.nanoTime() - this.dataSentTime));
        this.recorder().recordDataReceived(address, this.path, this.dataReceived);
    }

    protected void recordWrite(SocketAddress address) {
        this.recorder().recordDataSentTime(address, this.path, this.method, Duration.ofNanos(System.nanoTime() - this.dataSentTime));
        this.recorder().recordDataSent(address, this.path, this.dataSent);
    }

    private String resolveUri(ChannelHandlerContext ctx) {
        ChannelOperations<?, ?> channelOps = ChannelOperations.get(ctx.channel());
        if (channelOps instanceof HttpClientOperations) {
            String path = ((HttpClientOperations)channelOps).uri();
            return this.uriTagValue == null ? path : this.uriTagValue.apply(path);
        }
        return "unknown";
    }

    private void reset() {
        this.path = null;
        this.method = null;
        this.status = null;
        this.contextView = null;
        this.dataReceived = 0L;
        this.dataSent = 0L;
        this.dataReceivedTime = 0L;
        this.dataSentTime = 0L;
    }
}

