/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.resources;

import com.dataiku.dss.shadelibazure.io.netty.channel.Channel;
import com.dataiku.dss.shadelibazure.io.netty.channel.EventLoopGroup;
import com.dataiku.dss.shadelibazure.io.netty.channel.socket.DatagramChannel;
import com.dataiku.dss.shadelibazure.io.netty.channel.socket.ServerSocketChannel;
import com.dataiku.dss.shadelibazure.io.netty.channel.socket.SocketChannel;
import com.dataiku.dss.shadelibazure.io.netty.incubator.channel.uring.IOUring;
import com.dataiku.dss.shadelibazure.io.netty.incubator.channel.uring.IOUringDatagramChannel;
import com.dataiku.dss.shadelibazure.io.netty.incubator.channel.uring.IOUringEventLoopGroup;
import com.dataiku.dss.shadelibazure.io.netty.incubator.channel.uring.IOUringServerSocketChannel;
import com.dataiku.dss.shadelibazure.io.netty.incubator.channel.uring.IOUringSocketChannel;
import com.dataiku.dss.shadelibazure.reactor.netty.resources.ColocatedEventLoopGroup;
import com.dataiku.dss.shadelibazure.reactor.netty.resources.DefaultLoop;
import com.dataiku.dss.shadelibazure.reactor.util.Logger;
import com.dataiku.dss.shadelibazure.reactor.util.Loggers;
import java.util.concurrent.ThreadFactory;

final class DefaultLoopIOUring
implements DefaultLoop {
    static final Logger log = Loggers.getLogger(DefaultLoopIOUring.class);
    static final boolean isIoUringAvailable;

    DefaultLoopIOUring() {
    }

    @Override
    public <CHANNEL extends Channel> CHANNEL getChannel(Class<CHANNEL> channelClass) {
        if (channelClass.equals(SocketChannel.class)) {
            return (CHANNEL)new IOUringSocketChannel();
        }
        if (channelClass.equals(ServerSocketChannel.class)) {
            return (CHANNEL)new IOUringServerSocketChannel();
        }
        if (channelClass.equals(DatagramChannel.class)) {
            return (CHANNEL)new IOUringDatagramChannel();
        }
        throw new IllegalArgumentException("Unsupported channel type: " + channelClass.getSimpleName());
    }

    @Override
    public <CHANNEL extends Channel> Class<? extends CHANNEL> getChannelClass(Class<CHANNEL> channelClass) {
        if (channelClass.equals(SocketChannel.class)) {
            return IOUringSocketChannel.class;
        }
        if (channelClass.equals(ServerSocketChannel.class)) {
            return IOUringServerSocketChannel.class;
        }
        if (channelClass.equals(DatagramChannel.class)) {
            return IOUringDatagramChannel.class;
        }
        throw new IllegalArgumentException("Unsupported channel type: " + channelClass.getSimpleName());
    }

    @Override
    public String getName() {
        return "io_uring";
    }

    @Override
    public EventLoopGroup newEventLoopGroup(int threads, ThreadFactory factory2) {
        return new IOUringEventLoopGroup(threads, factory2);
    }

    @Override
    public boolean supportGroup(EventLoopGroup group) {
        if (group instanceof ColocatedEventLoopGroup) {
            group = ((ColocatedEventLoopGroup)group).get();
        }
        return group instanceof IOUringEventLoopGroup;
    }

    static {
        boolean ioUringCheck = false;
        try {
            Class.forName("com.dataiku.dss.shadelibazure.io.netty.incubator.channel.uring.IOUring");
            ioUringCheck = IOUring.isAvailable();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        isIoUringAvailable = ioUringCheck;
        if (log.isDebugEnabled()) {
            log.debug("Default io_uring support : " + isIoUringAvailable);
        }
    }
}

