/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.resources;

import com.dataiku.dss.shadelibazure.io.micrometer.core.instrument.Gauge;
import com.dataiku.dss.shadelibazure.io.micrometer.core.instrument.Meter;
import com.dataiku.dss.shadelibazure.io.micrometer.core.instrument.Tags;
import com.dataiku.dss.shadelibazure.reactor.netty.Metrics;
import com.dataiku.dss.shadelibazure.reactor.netty.internal.shaded.reactor.pool.InstrumentedPool;
import java.net.SocketAddress;

final class MicrometerPooledConnectionProviderMeterRegistrar {
    static final String ACTIVE_CONNECTIONS_DESCRIPTION = "The number of the connections that have been successfully acquired and are in active use";
    static final String IDLE_CONNECTIONS_DESCRIPTION = "The number of the idle connections";
    static final String MAX_CONNECTIONS_DESCRIPTIONS = "The maximum number of active connections that are allowed";
    static final String MAX_PENDING_CONNECTIONS_DESCRIPTIONS = "The maximum number of requests that will be queued while waiting for a ready connection";
    static final String PENDING_CONNECTIONS_DESCRIPTION = "The number of the request, that are pending acquire a connection";
    static final String TOTAL_CONNECTIONS_DESCRIPTION = "The number of all connections, active or idle.";
    static final MicrometerPooledConnectionProviderMeterRegistrar INSTANCE = new MicrometerPooledConnectionProviderMeterRegistrar();

    private MicrometerPooledConnectionProviderMeterRegistrar() {
    }

    void registerMetrics(String poolName, String id, SocketAddress remoteAddress, InstrumentedPool.PoolMetrics metrics) {
        String addressAsString = Metrics.formatSocketAddress(remoteAddress);
        Tags tags = Tags.of((String[])new String[]{"id", id, "remote.address", addressAsString, "name", poolName});
        Gauge.builder((String)"com.dataiku.dss.shadelibazure.reactor.netty.connection.provider.total.connections", (Object)metrics, InstrumentedPool.PoolMetrics::allocatedSize).description(TOTAL_CONNECTIONS_DESCRIPTION).tags((Iterable)tags).register(Metrics.REGISTRY);
        Gauge.builder((String)"com.dataiku.dss.shadelibazure.reactor.netty.connection.provider.active.connections", (Object)metrics, InstrumentedPool.PoolMetrics::acquiredSize).description(ACTIVE_CONNECTIONS_DESCRIPTION).tags((Iterable)tags).register(Metrics.REGISTRY);
        Gauge.builder((String)"com.dataiku.dss.shadelibazure.reactor.netty.connection.provider.idle.connections", (Object)metrics, InstrumentedPool.PoolMetrics::idleSize).description(IDLE_CONNECTIONS_DESCRIPTION).tags((Iterable)tags).register(Metrics.REGISTRY);
        Gauge.builder((String)"com.dataiku.dss.shadelibazure.reactor.netty.connection.provider.pending.connections", (Object)metrics, InstrumentedPool.PoolMetrics::pendingAcquireSize).description(PENDING_CONNECTIONS_DESCRIPTION).tags((Iterable)tags).register(Metrics.REGISTRY);
        Gauge.builder((String)"com.dataiku.dss.shadelibazure.reactor.netty.connection.provider.max.connections", (Object)metrics, InstrumentedPool.PoolMetrics::getMaxAllocatedSize).description(MAX_CONNECTIONS_DESCRIPTIONS).tags((Iterable)tags).register(Metrics.REGISTRY);
        Gauge.builder((String)"com.dataiku.dss.shadelibazure.reactor.netty.connection.provider.max.pending.connections", (Object)metrics, InstrumentedPool.PoolMetrics::getMaxPendingAcquireSize).description(MAX_PENDING_CONNECTIONS_DESCRIPTIONS).tags((Iterable)tags).register(Metrics.REGISTRY);
    }

    void deRegisterMetrics(String poolName, String id, SocketAddress remoteAddress) {
        String addressAsString = Metrics.formatSocketAddress(remoteAddress);
        Tags tags = Tags.of((String[])new String[]{"id", id, "remote.address", addressAsString, "name", poolName});
        Metrics.REGISTRY.remove(new Meter.Id("com.dataiku.dss.shadelibazure.reactor.netty.connection.provider.total.connections", tags, null, null, Meter.Type.GAUGE));
        Metrics.REGISTRY.remove(new Meter.Id("com.dataiku.dss.shadelibazure.reactor.netty.connection.provider.active.connections", tags, null, null, Meter.Type.GAUGE));
        Metrics.REGISTRY.remove(new Meter.Id("com.dataiku.dss.shadelibazure.reactor.netty.connection.provider.idle.connections", tags, null, null, Meter.Type.GAUGE));
        Metrics.REGISTRY.remove(new Meter.Id("com.dataiku.dss.shadelibazure.reactor.netty.connection.provider.pending.connections", tags, null, null, Meter.Type.GAUGE));
        Metrics.REGISTRY.remove(new Meter.Id("com.dataiku.dss.shadelibazure.reactor.netty.connection.provider.max.connections", tags, null, null, Meter.Type.GAUGE));
        Metrics.REGISTRY.remove(new Meter.Id("com.dataiku.dss.shadelibazure.reactor.netty.connection.provider.max.pending.connections", tags, null, null, Meter.Type.GAUGE));
    }
}

