/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.tcp;

import com.dataiku.dss.shadelibazure.io.netty.channel.Channel;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelOption;
import com.dataiku.dss.shadelibazure.io.netty.handler.logging.LogLevel;
import com.dataiku.dss.shadelibazure.io.netty.handler.logging.LoggingHandler;
import com.dataiku.dss.shadelibazure.reactor.netty.ChannelPipelineConfigurer;
import com.dataiku.dss.shadelibazure.reactor.netty.ConnectionObserver;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.ChannelMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.ChannelOperations;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.MicrometerChannelMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.resources.LoopResources;
import com.dataiku.dss.shadelibazure.reactor.netty.tcp.SslProvider;
import com.dataiku.dss.shadelibazure.reactor.netty.tcp.TcpResources;
import com.dataiku.dss.shadelibazure.reactor.netty.tcp.TcpServer;
import com.dataiku.dss.shadelibazure.reactor.netty.transport.ServerTransportConfig;
import com.dataiku.dss.shadelibazure.reactor.netty.transport.logging.AdvancedByteBufFormat;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.function.Supplier;

public final class TcpServerConfig
extends ServerTransportConfig<TcpServerConfig> {
    SslProvider sslProvider;
    static final ChannelOperations.OnSetup DEFAULT_OPS = (ch, c, msg) -> new ChannelOperations(ch, c);
    static final LoggingHandler LOGGING_HANDLER = AdvancedByteBufFormat.HEX_DUMP.toLoggingHandler(TcpServer.class.getName(), LogLevel.DEBUG, Charset.defaultCharset());
    static final boolean SSL_DEBUG = Boolean.parseBoolean(System.getProperty("com.dataiku.dss.shadelibazure.reactor.netty.tcp.ssl.server.debug", "false"));

    @Override
    public ChannelOperations.OnSetup channelOperationsProvider() {
        return DEFAULT_OPS;
    }

    public final boolean isSecure() {
        return this.sslProvider != null;
    }

    @Nullable
    public SslProvider sslProvider() {
        return this.sslProvider;
    }

    TcpServerConfig(Map<ChannelOption<?>, ?> options, Map<ChannelOption<?>, ?> childOptions, Supplier<? extends SocketAddress> localAddress) {
        super(options, childOptions, localAddress);
    }

    TcpServerConfig(TcpServerConfig parent) {
        super(parent);
        this.sslProvider = parent.sslProvider;
    }

    @Override
    protected LoggingHandler defaultLoggingHandler() {
        return LOGGING_HANDLER;
    }

    @Override
    protected LoopResources defaultLoopResources() {
        return TcpResources.get();
    }

    @Override
    protected ChannelMetricsRecorder defaultMetricsRecorder() {
        return MicrometerTcpServerMetricsRecorder.INSTANCE;
    }

    @Override
    protected ChannelPipelineConfigurer defaultOnChannelInit() {
        ChannelPipelineConfigurer _default = super.defaultOnChannelInit();
        if (this.sslProvider != null) {
            return _default.then(new TcpServerChannelInitializer(this.sslProvider));
        }
        return _default;
    }

    static final class TcpServerChannelInitializer
    implements ChannelPipelineConfigurer {
        final SslProvider sslProvider;

        TcpServerChannelInitializer(SslProvider sslProvider) {
            this.sslProvider = sslProvider;
        }

        @Override
        public void onChannelInit(ConnectionObserver connectionObserver, Channel channel, @Nullable SocketAddress remoteAddress) {
            this.sslProvider.addSslHandler(channel, remoteAddress, SSL_DEBUG);
        }
    }

    static final class MicrometerTcpServerMetricsRecorder
    extends MicrometerChannelMetricsRecorder {
        static final MicrometerTcpServerMetricsRecorder INSTANCE = new MicrometerTcpServerMetricsRecorder();

        MicrometerTcpServerMetricsRecorder() {
            super("com.dataiku.dss.shadelibazure.reactor.netty.tcp.server", "tcp");
        }
    }
}

