/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.transport;

import com.dataiku.dss.shadelibazure.io.micrometer.core.instrument.Gauge;
import com.dataiku.dss.shadelibazure.io.netty.channel.EventLoop;
import com.dataiku.dss.shadelibazure.io.netty.util.concurrent.SingleThreadEventExecutor;
import com.dataiku.dss.shadelibazure.reactor.netty.Metrics;
import com.dataiku.dss.shadelibazure.reactor.netty.internal.util.MapUtils;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

final class MicrometerEventLoopMeterRegistrar {
    static final String PENDING_TASKS_DESCRIPTION = "Event loop pending scheduled tasks.";
    static final MicrometerEventLoopMeterRegistrar INSTANCE = new MicrometerEventLoopMeterRegistrar();
    private final ConcurrentMap<String, EventLoop> cache = new ConcurrentHashMap<String, EventLoop>();

    private MicrometerEventLoopMeterRegistrar() {
    }

    void registerMetrics(EventLoop eventLoop) {
        if (eventLoop instanceof SingleThreadEventExecutor) {
            SingleThreadEventExecutor singleThreadEventExecutor = (SingleThreadEventExecutor)((Object)eventLoop);
            String executorName = singleThreadEventExecutor.threadProperties().name();
            MapUtils.computeIfAbsent(this.cache, executorName, key -> {
                Gauge.builder((String)"com.dataiku.dss.shadelibazure.reactor.netty.eventloop.pending.tasks", singleThreadEventExecutor::pendingTasks).description(PENDING_TASKS_DESCRIPTION).tag("name", executorName).register(Metrics.REGISTRY);
                return eventLoop;
            });
        }
    }
}

