/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.udp;

import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelFuture;
import com.dataiku.dss.shadelibazure.io.netty.channel.socket.DatagramChannel;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.netty.Connection;
import com.dataiku.dss.shadelibazure.reactor.netty.ConnectionObserver;
import com.dataiku.dss.shadelibazure.reactor.netty.FutureMono;
import com.dataiku.dss.shadelibazure.reactor.netty.ReactorNetty;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.ChannelOperations;
import com.dataiku.dss.shadelibazure.reactor.netty.udp.UdpInbound;
import com.dataiku.dss.shadelibazure.reactor.netty.udp.UdpOutbound;
import com.dataiku.dss.shadelibazure.reactor.util.Logger;
import com.dataiku.dss.shadelibazure.reactor.util.Loggers;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;

final class UdpOperations
extends ChannelOperations<UdpInbound, UdpOutbound>
implements UdpInbound,
UdpOutbound {
    static final Logger log = Loggers.getLogger(UdpOperations.class);

    UdpOperations(Connection c, ConnectionObserver listener) {
        super(c, listener);
    }

    @Override
    public Mono<Void> join(InetAddress multicastAddress, @Nullable NetworkInterface iface) {
        if (!(this.connection().channel() instanceof DatagramChannel)) {
            throw new UnsupportedOperationException();
        }
        DatagramChannel datagramChannel = (DatagramChannel)this.connection().channel();
        if (null == iface && null != datagramChannel.config().getNetworkInterface()) {
            iface = datagramChannel.config().getNetworkInterface();
        }
        ChannelFuture future = null != iface ? datagramChannel.joinGroup(new InetSocketAddress(multicastAddress, datagramChannel.localAddress().getPort()), iface) : datagramChannel.joinGroup(multicastAddress);
        return FutureMono.from(future).doOnSuccess(v -> {
            if (log.isInfoEnabled()) {
                log.info(ReactorNetty.format(future.channel(), "JOIN {}"), multicastAddress);
            }
        });
    }

    @Override
    public Mono<Void> leave(InetAddress multicastAddress, @Nullable NetworkInterface iface) {
        if (!(this.connection().channel() instanceof DatagramChannel)) {
            throw new UnsupportedOperationException();
        }
        DatagramChannel datagramChannel = (DatagramChannel)this.connection().channel();
        if (null == iface && null != datagramChannel.config().getNetworkInterface()) {
            iface = datagramChannel.config().getNetworkInterface();
        }
        ChannelFuture future = null != iface ? datagramChannel.leaveGroup(new InetSocketAddress(multicastAddress, datagramChannel.localAddress().getPort()), iface) : datagramChannel.leaveGroup(multicastAddress);
        return FutureMono.from(future).doOnSuccess(v -> {
            if (log.isInfoEnabled()) {
                log.info(ReactorNetty.format(future.channel(), "JOIN {}"), multicastAddress);
            }
        });
    }
}

