/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage.transfermanager;

import java.nio.file.Path;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BlobInfo;
import net.snowflake.client.jdbc.internal.google.cloud.storage.transfermanager.DownloadResult;
import net.snowflake.client.jdbc.internal.google.cloud.storage.transfermanager.TransferStatus;
import net.snowflake.client.jdbc.internal.org.checkerframework.checker.nullness.qual.NonNull;

final class DownloadSegment {
    private final BlobInfo input;
    private final Path outputDestination;
    private final TransferStatus status;
    private final Exception exception;
    private final Long generation;

    private DownloadSegment(BlobInfo input, Path outputDestination, TransferStatus status, Exception exception, Long generation) {
        this.input = input;
        this.outputDestination = outputDestination;
        this.status = status;
        this.exception = exception;
        this.generation = generation;
    }

    public BlobInfo getInput() {
        return this.input;
    }

    public Path getOutputDestination() {
        return this.outputDestination;
    }

    public TransferStatus getStatus() {
        return this.status;
    }

    public Exception getException() {
        return this.exception;
    }

    public static Builder newBuilder(BlobInfo input, TransferStatus status) {
        return new Builder(input, status);
    }

    public Long getGeneration() {
        return this.generation;
    }

    public DownloadResult toResult() {
        DownloadResult.Builder b = DownloadResult.newBuilder(this.input, this.status);
        if (this.exception != null) {
            b.setException(this.exception);
        }
        if (this.outputDestination != null) {
            b.setOutputDestination(this.outputDestination);
        }
        return b.build();
    }

    public static @NonNull DownloadResult reduce(@NonNull DownloadResult result, @NonNull DownloadSegment segment) {
        if (TransferStatus.COMPARE_NULL_SAFE.compare(result.getStatus(), segment.getStatus()) <= 0) {
            return result;
        }
        return segment.toResult();
    }

    public static final class Builder {
        private BlobInfo input;
        private Path outputDestination;
        private TransferStatus status;
        private Exception exception;
        private Long generation;

        private Builder(BlobInfo input, TransferStatus status) {
            this.input = input;
            this.status = status;
        }

        public Builder setInput(BlobInfo input) {
            this.input = input;
            return this;
        }

        public Builder setOutputDestination(Path outputDestination) {
            this.outputDestination = outputDestination;
            return this;
        }

        public Builder setStatus(TransferStatus status) {
            this.status = status;
            return this;
        }

        public Builder setException(Exception exception) {
            this.exception = exception;
            return this;
        }

        public Builder setGeneration(Long generation) {
            this.generation = generation;
            return this;
        }

        public DownloadSegment build() {
            return new DownloadSegment(this.input, this.outputDestination, this.status, this.exception, this.generation);
        }
    }
}

