/*
 * Decompiled with CFR 0.152.
 */
package de.biomedical_imaging.edu.wlu.cs.levy.CG;

import de.biomedical_imaging.edu.wlu.cs.levy.CG.HPoint;
import java.io.Serializable;

class HRect
implements Serializable {
    protected HPoint min;
    protected HPoint max;

    protected HRect(int ndims) {
        this.min = new HPoint(ndims);
        this.max = new HPoint(ndims);
    }

    protected HRect(HPoint vmin, HPoint vmax) {
        this.min = (HPoint)vmin.clone();
        this.max = (HPoint)vmax.clone();
    }

    protected Object clone() {
        return new HRect(this.min, this.max);
    }

    protected HPoint closest(HPoint t) {
        HPoint p = new HPoint(t.coord.length);
        for (int i = 0; i < t.coord.length; ++i) {
            p.coord[i] = t.coord[i] <= this.min.coord[i] ? this.min.coord[i] : (t.coord[i] >= this.max.coord[i] ? this.max.coord[i] : t.coord[i]);
        }
        return p;
    }

    protected static HRect infiniteHRect(int d) {
        HPoint vmin = new HPoint(d);
        HPoint vmax = new HPoint(d);
        for (int i = 0; i < d; ++i) {
            vmin.coord[i] = Double.NEGATIVE_INFINITY;
            vmax.coord[i] = Double.POSITIVE_INFINITY;
        }
        return new HRect(vmin, vmax);
    }

    protected HRect intersection(HRect r) {
        HPoint newmin = new HPoint(this.min.coord.length);
        HPoint newmax = new HPoint(this.min.coord.length);
        for (int i = 0; i < this.min.coord.length; ++i) {
            newmin.coord[i] = Math.max(this.min.coord[i], r.min.coord[i]);
            newmax.coord[i] = Math.min(this.max.coord[i], r.max.coord[i]);
            if (!(newmin.coord[i] >= newmax.coord[i])) continue;
            return null;
        }
        return new HRect(newmin, newmax);
    }

    protected double area() {
        double a = 1.0;
        for (int i = 0; i < this.min.coord.length; ++i) {
            a *= this.max.coord[i] - this.min.coord[i];
        }
        return a;
    }

    public String toString() {
        return this.min + "\n" + this.max + "\n";
    }
}

