/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.com.nimbusds.jose.crypto.impl;

import java.security.Provider;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.snowflake.ingest.internal.com.nimbusds.jose.JOSEException;
import net.snowflake.ingest.internal.com.nimbusds.jose.KeyLengthException;
import net.snowflake.ingest.internal.com.nimbusds.jose.crypto.impl.AESGCM;
import net.snowflake.ingest.internal.com.nimbusds.jose.crypto.impl.AuthenticatedCipherText;
import net.snowflake.ingest.internal.com.nimbusds.jose.util.ByteUtils;
import net.snowflake.ingest.internal.com.nimbusds.jose.util.Container;
import net.snowflake.ingest.internal.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class AESGCMKW {
    public static AuthenticatedCipherText encryptCEK(SecretKey cek, Container<byte[]> iv, SecretKey kek, Provider provider) throws JOSEException {
        return AESGCM.encrypt(kek, iv, cek.getEncoded(), new byte[0], provider);
    }

    public static SecretKey decryptCEK(SecretKey kek, byte[] iv, AuthenticatedCipherText authEncrCEK, int keyLength, Provider provider) throws JOSEException {
        byte[] keyBytes = AESGCM.decrypt(kek, iv, authEncrCEK.getCipherText(), new byte[0], authEncrCEK.getAuthenticationTag(), provider);
        if (ByteUtils.safeBitLength(keyBytes) != keyLength) {
            throw new KeyLengthException("CEK key length mismatch: " + ByteUtils.safeBitLength(keyBytes) + " != " + keyLength);
        }
        return new SecretKeySpec(keyBytes, "AES");
    }

    private AESGCMKW() {
    }
}

