/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.coreservices;

import com.dataiku.dip.analysis.coreservices.ISplitsStatusService;
import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.analysis.ml.clustering.extract.ClusteringSampleExtractor;
import com.dataiku.dip.analysis.ml.prediction.split.PredictionSplitGenerator;
import com.dataiku.dip.analysis.ml.prediction.split.SplitDesc;
import com.dataiku.dip.analysis.ml.prediction.split.SplitGeneratorFactory;
import com.dataiku.dip.analysis.model.clustering.ClusteringMLTask;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.NotImplementedException;
import java.sql.SQLException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SplitsStatusService
implements ISplitsStatusService {
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private ReadWriteJobsInternalDB jobsDBService;
    @Autowired
    private TransactionService transactionService;

    private void fillDataOneDataset(Dataset dataset, SplitStatus ret) throws SQLException {
        ret.allDatasetsAreManaged = dataset.isManaged();
        if (ret.allDatasetsAreManaged) {
            ReadOnlyJobsInternalDB.DatasetBuild build = this.jobsDBService.getLatestBuildForDataset(dataset.getProjectKey(), dataset.getName());
            if (build != null) {
                ret.datasetModificationDate = build.buildEndTime;
            }
            if (ret.datasetModificationDate > ret.generationDate) {
                ret.anyDatasetModifiedSince = true;
                ret.modifiedDataset = dataset.getFullName();
            }
        }
    }

    @Override
    public SplitStatus getSplitStatus_NT(AnalysisCoreParams coreParams, MLTaskLoc loc, PredictionMLTask task, AuthCtx user) throws Exception {
        DatasetLocUtils.DatasetLoc inputLoc = DatasetLocUtils.resolveSmart(coreParams.projectKey, coreParams.inputDatasetSmartName);
        PredictionSplitGenerator generator = task.isPartitioned() ? SplitGeneratorFactory.buildForPartitionedMLTask(coreParams, loc, task.splitParams, user, null, null) : SplitGeneratorFactory.buildForMLTask(coreParams, loc, task.splitParams, user);
        SplitStatus ret = new SplitStatus();
        ret.splitAvailable = generator.splitsAreUpToDate_NT();
        ret.isKFold = task.splitParams.kfold;
        if (!ret.splitAvailable) {
            return ret;
        }
        SplitDesc splitDesc = generator.getUpToDateSplitDesc();
        ret.generationDate = splitDesc.generationDate;
        ret.trainRows = splitDesc.trainRows;
        ret.testRows = splitDesc.testRows;
        if (splitDesc.params.kfold || null != splitDesc.fullPath) {
            ret.fullRows = splitDesc.fullRows;
        }
        switch (task.splitParams.ttPolicy) {
            case SPLIT_SINGLE_DATASET: {
                DatasetLocUtils.DatasetLoc dloc = task.splitParams.ssdDatasetSmartName == null ? inputLoc : DatasetLocUtils.resolveSmart(coreParams.projectKey, task.splitParams.ssdDatasetSmartName);
                Dataset splitInputDataset = null;
                try (Transaction t = this.transactionService.beginRead();){
                    splitInputDataset = this.datasetAccessService.getMandatory(dloc);
                }
                this.fillDataOneDataset(splitInputDataset, ret);
                break;
            }
            case EXPLICIT_FILTERING_SINGLE_DATASET: {
                DatasetLocUtils.DatasetLoc dloc = task.splitParams.efsdDatasetSmartName == null ? inputLoc : DatasetLocUtils.resolveSmart(coreParams.projectKey, task.splitParams.efsdDatasetSmartName);
                Dataset splitInputDataset = null;
                try (Transaction t = this.transactionService.beginRead();){
                    splitInputDataset = this.datasetAccessService.getMandatory(dloc);
                }
                this.fillDataOneDataset(splitInputDataset, ret);
                break;
            }
            case EXPLICIT_FILTERING_TWO_DATASETS: {
                try (Transaction t = this.transactionService.beginRead();){
                    Dataset train = this.datasetAccessService.getMandatory(DatasetLocUtils.resolveSmart(coreParams.projectKey, task.splitParams.eftdTrain.datasetSmartName));
                    Dataset test = this.datasetAccessService.getMandatory(DatasetLocUtils.resolveSmart(coreParams.projectKey, task.splitParams.eftdTest.datasetSmartName));
                    boolean bl = ret.allDatasetsAreManaged = train.isManaged() && test.isManaged();
                    if (!ret.allDatasetsAreManaged) break;
                    ReadOnlyJobsInternalDB.DatasetBuild trainBuild = this.jobsDBService.getLatestBuildForDataset(train.getProjectKey(), train.getName());
                    if (trainBuild != null) {
                        ret.datasetModificationDate = trainBuild.buildEndTime;
                    }
                    if (ret.datasetModificationDate > ret.generationDate) {
                        ret.anyDatasetModifiedSince = true;
                        ret.modifiedDataset = train.getFullName();
                    }
                    if (ret.anyDatasetModifiedSince) break;
                    ReadOnlyJobsInternalDB.DatasetBuild testBuild = this.jobsDBService.getLatestBuildForDataset(train.getProjectKey(), train.getName());
                    if (testBuild != null) {
                        ret.datasetModificationDate = testBuild.buildEndTime;
                    }
                    if (ret.datasetModificationDate <= ret.generationDate) break;
                    ret.anyDatasetModifiedSince = true;
                    ret.modifiedDataset = test.getFullName();
                    break;
                }
            }
            default: {
                throw new NotImplementedException();
            }
        }
        return ret;
    }

    @Override
    public SplitStatus getCSplitStatus_NT(AnalysisCoreParams coreParams, MLTaskLoc loc, ClusteringMLTask task, AuthCtx user) throws Exception {
        ClusteringSampleExtractor generator = new ClusteringSampleExtractor(loc, coreParams, task.sampling, user);
        SplitStatus ret = new SplitStatus();
        ret.splitAvailable = generator.splitsAreUpToDate_NT();
        if (!ret.splitAvailable) {
            return ret;
        }
        SplitDesc splitDesc = generator.getUpToDateSplitDesc();
        ret.generationDate = splitDesc.generationDate;
        ret.fullRows = splitDesc.fullRows;
        DatasetLocUtils.DatasetLoc inputLoc = DatasetLocUtils.resolveSmart(coreParams.projectKey, coreParams.inputDatasetSmartName);
        try (Transaction t = this.transactionService.beginRead();){
            Dataset splitInputDataset = this.datasetAccessService.getMandatory(inputLoc);
            this.fillStatusSingleDataset(splitInputDataset, ret);
        }
        return ret;
    }

    private void fillStatusSingleDataset(Dataset dataset, SplitStatus ret) throws Exception {
        ret.allDatasetsAreManaged = dataset.isManaged();
        if (ret.allDatasetsAreManaged) {
            ReadOnlyJobsInternalDB.DatasetBuild build = this.jobsDBService.getLatestBuildForDataset(dataset.getProjectKey(), dataset.getName());
            if (build != null) {
                ret.datasetModificationDate = build.buildEndTime;
            }
            if (ret.datasetModificationDate > ret.generationDate) {
                ret.anyDatasetModifiedSince = true;
                ret.modifiedDataset = dataset.getFullName();
            }
        }
    }

    public static class SplitStatus {
        boolean splitAvailable;
        long generationDate;
        long trainRows;
        long testRows;
        boolean isKFold;
        long fullRows;
        boolean allDatasetsAreManaged;
        boolean anyDatasetModifiedSince;
        String modifiedDataset;
        long datasetModificationDate;
    }
}

