/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.analysis.docgen.extractor.ModelExtractor;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.clustering.ClusteringModelDetails;
import com.jayway.jsonpath.DocumentContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class OutliersDetectionTableExtractor
implements ModelExtractor<List<List<String>>> {
    @Override
    public List<List<String>> extract(DocumentContext documentContext, ModelDetailsBase model) throws IOException {
        if (model instanceof ClusteringModelDetails) {
            ClusteringModelDetails clusteringModelDetails = (ClusteringModelDetails)model;
            if (clusteringModelDetails.preprocessing != null && clusteringModelDetails.preprocessing.outliers != null && clusteringModelDetails.preprocessing.outliers.method != null) {
                ArrayList<List<String>> output = new ArrayList<List<String>>();
                for (OutliersDetectionMethod method : OutliersDetectionMethod.values()) {
                    if (!method.name().equals(clusteringModelDetails.preprocessing.outliers.method.name())) continue;
                    output.add(Arrays.asList("Outliers handling method", method.getUserFriendlyName()));
                    if (!OutliersDetectionMethod.CLUSTER.equals((Object)method) && !OutliersDetectionMethod.DROP.equals((Object)method)) continue;
                    output.add(Arrays.asList("Mini-cluster size threshold", Integer.toString(clusteringModelDetails.preprocessing.outliers.min_n)));
                    output.add(Arrays.asList("Mini-clusters cum. % threshold", Integer.toString((int)Math.ceil(clusteringModelDetails.preprocessing.outliers.min_cum_ratio * 100.0f))));
                }
                return output;
            }
        }
        throw new IOException(String.format("Extractor '%s' does not support model details of type '%s'", this.getClass().getSimpleName(), model.getClass().getSimpleName()));
    }

    public static enum OutliersDetectionMethod {
        NONE("Do not detect outliers"),
        DROP("Drop outliers"),
        CLUSTER("Create a cluster with all outliers");

        private String userFriendlyName;

        private OutliersDetectionMethod(String userFriendlyName) {
            this.userFriendlyName = userFriendlyName;
        }

        String getUserFriendlyName() {
            return this.userFriendlyName;
        }
    }
}

