/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.analysis.docgen.extractor.ModelExtractor;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;

public class PredictionTypeExtractor
implements ModelExtractor<String> {
    private final String jsonPath;
    private final JsonPath compiled;

    public PredictionTypeExtractor(String jsonPath) {
        this.jsonPath = jsonPath;
        this.compiled = JsonPath.compile((String)jsonPath, (Predicate[])new Predicate[0]);
    }

    @Override
    public String extract(DocumentContext documentContext, ModelDetailsBase model) throws IOException {
        try {
            String predictionName = (String)documentContext.read(this.compiled);
            return this.getFriendlyPredictionName(predictionName);
        }
        catch (PathNotFoundException e) {
            throw new IOException("Cannot extract the JsonPath \"" + this.jsonPath + "\".");
        }
    }

    private String getFriendlyPredictionName(String predictionName) {
        try {
            PredictionMLTask.PredictionType predictionType = PredictionMLTask.PredictionType.valueOf(predictionName);
            switch (predictionType) {
                case MULTICLASS: {
                    return "Multiclass classification";
                }
                case REGRESSION: {
                    return "Regression";
                }
                case BINARY_CLASSIFICATION: {
                    return "Binary classification";
                }
                case TIMESERIES_FORECAST: {
                    return "Time series forecasting";
                }
            }
            return predictionName;
        }
        catch (IllegalArgumentException e) {
            return predictionName;
        }
    }
}

