/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction.overrides;

import com.dataiku.dip.analysis.ml.prediction.overrides.ReadOnlyColumnFactory;
import com.dataiku.dip.analysis.ml.prediction.overrides.ReadOnlyRowObservation;
import com.dataiku.dip.analysis.model.prediction.overrides.MLOverridesParams;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.scoring.models.overrides.MLOverridesParamsBase;
import com.dataiku.scoring.pipelines.overrides.OverridesOutcomeComputer;
import com.dataiku.scoring.util.RawObservation;
import java.io.Serializable;

public abstract class FormulaOverridesOutcomeComputer<T>
extends OverridesOutcomeComputer<T>
implements Serializable {
    public MLOverridesParams overridesParams;
    public ColumnFactory cf;

    public FormulaOverridesOutcomeComputer() {
    }

    public FormulaOverridesOutcomeComputer(MLOverridesParams overridesParams, ColumnFactory cf) {
        this.overridesParams = overridesParams;
        this.cf = cf;
    }

    public void init() {
        for (MLOverridesParamsBase.MLOverride override : this.overridesParams.overrides) {
            this.registerCandidate(override.name, override.outcome, this.getOverrideFilter((FilterDesc)override.filter, this.cf));
        }
        this.initialized = true;
    }

    abstract OverridesOutcomeComputer.OverrideFilter<T> getOverrideFilter(FilterDesc var1, ColumnFactory var2);

    public static class RowFormulaOutcomeComputer
    extends FormulaOverridesOutcomeComputer<Row> {
        public RowFormulaOutcomeComputer(MLOverridesParams overridesParams, ColumnFactory cf) {
            super(overridesParams, cf);
        }

        @Override
        OverridesOutcomeComputer.OverrideFilter<Row> getOverrideFilter(FilterDesc filterDesc, ColumnFactory cf) {
            return new RowFormulaOverrideFilter(filterDesc, cf);
        }

        private static class RowFormulaOverrideFilter
        extends FormulaOverrideFilter<Row> {
            RowFormulaOverrideFilter(FilterDesc filterDesc, ColumnFactory cf) {
                super(filterDesc, cf);
            }

            public Boolean matches(Row row) {
                return this.expression.isTrueish(row);
            }
        }
    }

    public static class RawObservationFormulaOutcomeComputer
    extends FormulaOverridesOutcomeComputer<RawObservation> {
        public RawObservationFormulaOutcomeComputer(MLOverridesParams overridesParams, String[] columns) {
            super(overridesParams, (ColumnFactory)new ReadOnlyColumnFactory(columns));
        }

        @Override
        OverridesOutcomeComputer.OverrideFilter<RawObservation> getOverrideFilter(FilterDesc filterDesc, ColumnFactory cf) {
            return new RawObservationFormulaOverrideFilter(filterDesc, cf);
        }

        private static class RawObservationFormulaOverrideFilter
        extends FormulaOverrideFilter<RawObservation> {
            RawObservationFormulaOverrideFilter(FilterDesc filterDesc, ColumnFactory cf) {
                super(filterDesc, cf);
            }

            public Boolean matches(RawObservation row) {
                ReadOnlyRowObservation readOnlyRow = new ReadOnlyRowObservation(row);
                return this.expression.isTrueish(readOnlyRow);
            }
        }
    }

    private static abstract class FormulaOverrideFilter<T>
    implements OverridesOutcomeComputer.OverrideFilter<T> {
        final Expression expression;

        FormulaOverrideFilter(FilterDesc filterDesc, ColumnFactory cf) {
            try {
                this.expression = new Expression(FilterDescUtils.getGrelExpression(filterDesc));
                this.expression.setColumnFactory(cf);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to instantiate override filter with formula", e);
            }
        }
    }
}

