/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.shared;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.partitioning.StratifiedModelUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DiagConfigRedactionUtils;
import com.dataiku.dip.utils.DKUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class TrainDiagnosisGenerator {
    public static final ImmutableSet<String> EXCLUDED_PATH_SUFFIXES = ImmutableSet.of((Object)"dss_pipeline_model.gz", (Object)".csv", (Object)".csv.gz", (Object)".pkl", (Object)".pkl.gz", (Object)".h5", (Object[])new String[]{".keras", "forecasts.json", "forecasts.json.gz", "secret.yaml", ".pem", "remote-run-env-def.json", "model.dss"});
    private final AuthCtx authCtx;
    private final Predicate<String> pathPredicate;

    public TrainDiagnosisGenerator(AuthCtx authCtx) {
        this.authCtx = authCtx;
        this.pathPredicate = filename -> EXCLUDED_PATH_SUFFIXES.stream().noneMatch(filename::endsWith);
    }

    public void generateDiagnosis(FullModelId fmi, boolean includeTrainingData, OutputStream outputStream) throws IOException, InterruptedException {
        Preconditions.checkArgument((fmi.getType() == FullModelId.Type.ANALYSIS ? 1 : 0) != 0, (Object)"Model diagnoses are only supported for ANALYSIS models.");
        HashSet<File> preprocessingFolders = new HashSet<File>();
        HashSet<File> modelFolders = new HashSet<File>();
        HashSet<File> splitFiles = new HashSet<File>();
        preprocessingFolders.add(fmi.getPreprocessingFolder());
        modelFolders.add(fmi.getModelFolder());
        splitFiles.addAll(TrainDiagnosisGenerator.extractRequestedSplitFiles(fmi, includeTrainingData));
        if (fmi.isPartitionedBaseModel()) {
            Set<FullModelId> partitionFmis = StratifiedModelUtils.fetchPartitionFmis(fmi);
            for (FullModelId partitionFmi : partitionFmis) {
                File preprocessingFolder = partitionFmi.getPreprocessingFolder();
                if (!preprocessingFolder.exists()) continue;
                preprocessingFolders.add(preprocessingFolder);
                File modelFolder = partitionFmi.getModelFolder();
                if (modelFolder.exists()) {
                    modelFolders.add(modelFolder);
                }
                splitFiles.addAll(TrainDiagnosisGenerator.extractRequestedSplitFiles(partitionFmi, includeTrainingData));
            }
        }
        Path basePath = fmi.getTaskLoc().getDataFolder().toPath();
        try (ZipUnzipDir.ZipBuilderWithBasePath zipBuilder = ZipUnzipDir.zipBuilder(new BufferedOutputStream(outputStream), basePath);){
            ZipUnzipDir.DefaultFileInputStreamProvider fisp = new ZipUnzipDir.DefaultFileInputStreamProvider();
            Pattern configFilesExclude = DiagConfigRedactionUtils.configFilesExclude;
            zipBuilder.addDirectoryFromBasePath(fmi.getSessionFolder(), false, this.pathPredicate, configFilesExclude, fisp);
            zipBuilder.addDirectoriesFromBasePath(preprocessingFolders, false, this.pathPredicate, configFilesExclude, fisp);
            zipBuilder.addDirectoriesFromBasePath(modelFolders, false, this.pathPredicate, configFilesExclude, fisp);
            zipBuilder.addFilesFromBasePath(splitFiles);
            zipBuilder.addFile("session_listing.txt", TrainDiagnosisGenerator.recursiveDirListing(fmi.getSessionFolder()));
            zipBuilder.addFile("splits_listing.txt", TrainDiagnosisGenerator.recursiveDirListing(fmi.getSplitFolder()));
        }
    }

    private static Set<File> extractRequestedSplitFiles(FullModelId fmi, boolean includeTrainingData) throws IOException {
        File splitDescFile = fmi.getSplitDescFile();
        if (splitDescFile == null || !splitDescFile.exists()) {
            return Collections.emptySet();
        }
        HashSet<File> splitFiles = new HashSet<File>();
        splitFiles.add(splitDescFile);
        if (includeTrainingData) {
            Set splitDataFiles = fmi.getSplitDesc().getNonEmptySplitPaths().stream().map(fmi::getSplitFile).collect(Collectors.toSet());
            splitFiles.addAll(splitDataFiles);
        }
        return splitFiles;
    }

    private static InputStream recursiveDirListing(File rootDir) throws IOException, InterruptedException {
        ProcessBuilder processBuilder = DKUtils.isOsWindows() ? new ProcessBuilder("cmd.exe", "/c", "dir", "/s", "/q") : new ProcessBuilder("find", ".", "-ls");
        processBuilder.directory(rootDir);
        byte[] output = DKUtils.execAndGetOutput((ProcessBuilder)processBuilder);
        return new ByteArrayInputStream(output);
    }
}

