/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.vectorstore;

import com.dataiku.dip.analysis.ml.vectorstore.VectorStoreConnectionRestClient;
import com.dataiku.dip.connections.AzureAISearchConnection;
import com.dataiku.dip.connections.ConnectionWithAzureAuthCredentials;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.http.message.BasicHeader;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.HttpHeader;
import java.io.IOException;

public class AzureAISearchRestClient
extends VectorStoreConnectionRestClient {
    private final String aisearchResourceUrl;

    public AzureAISearchRestClient(AzureAISearchConnection connection, AuthCtx authCtx) throws IOException, DKUSecurityException {
        super("AzureAISearch", AzureAISearchRestClient.buildAuthorizationHeader(connection, authCtx));
        this.aisearchResourceUrl = AzureAISearchRestClient.isURL(connection.params.resourceName) ? connection.params.resourceName : "https://" + connection.params.resourceName + ".search.windows.net";
    }

    @Override
    protected String getClientEndpointUrl() {
        return this.aisearchResourceUrl + "/indexes?$select=*&api-version=2024-07-01";
    }

    @Override
    protected String parseErrorResponse(String responseEntityData) {
        AzureAISearchResponseError parsedError = (AzureAISearchResponseError)JSON.parse((String)responseEntityData, AzureAISearchResponseError.class);
        return parsedError.error.message;
    }

    private static BasicHeader buildAuthorizationHeader(AzureAISearchConnection connection, AuthCtx authCtx) throws IOException, DKUSecurityException {
        ConnectionWithAzureAuthCredentials.SerializableAzureAuthCredentials creds = connection.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, null), ConnectionWithAzureAuthCredentials.SerializableAzureAuthCredentials.class);
        switch (creds.authType) {
            case OAUTH2_APP: {
                return new BasicHeader(HttpHeader.AUTHORIZATION.asString(), "Bearer " + creds.oauth2AccessToken);
            }
            case KEY: {
                return new BasicHeader("Api-Key", creds.key);
            }
        }
        throw new IllegalArgumentException("Unhandled auth mode " + String.valueOf((Object)creds.authType));
    }

    public static class AzureAISearchResponseError {
        AzureAISearchResponseErrorDetails error;
    }

    public static class AzureAISearchResponseErrorDetails {
        String message;
    }
}

