/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.autorestart;

import com.dataiku.dip.exceptions.ExceptionWithLogTail;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.SmartLogTail;
import java.io.IOException;

public abstract class AutoRestartingProcessRunner {
    public final String attemptId = DKUDateUtils.isoFormatFileFriendlyLocalNow();

    public abstract void run() throws Exception;

    public abstract Integer getPid();

    public abstract SmartLogTail getLogTail() throws IOException;

    public abstract void stop();

    public static class BackendDiedException
    extends Exception
    implements ExceptionWithLogTail {
        private static final long serialVersionUID = 1L;
        private final SmartLogTail logTail;

        public BackendDiedException(String message, Throwable cause, SmartLogTail logTail) {
            super(message, cause);
            this.logTail = logTail;
        }

        public SmartLogTail getLogTail() {
            return this.logTail;
        }
    }

    public static class BackendStartFailedException
    extends Exception
    implements ExceptionWithLogTail {
        private static final long serialVersionUID = 1L;
        private final SmartLogTail logTail;

        public BackendStartFailedException(String message, Throwable cause, SmartLogTail logTail) {
            super(message, cause);
            this.logTail = logTail;
        }

        public SmartLogTail getLogTail() {
            return this.logTail;
        }
    }
}

