/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cli;

import com.dataiku.dip.cli.CLICommand;
import com.dataiku.dip.cli.CLISetup;
import com.dataiku.dip.cli.DKU;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dao.impl.FilesBasedUsersDAO;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.model.CredentialsService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.SchemaReader;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class SQLCommand
extends CLICommand {
    @Override
    public String usageString() {
        return "dku sql connection [-e EXPRESSION]";
    }

    @Override
    public String description() {
        return "Execute a SQL command to a database";
    }

    @Override
    public Options opts() {
        Options opts = new Options();
        DKU.addGlobalOptions(opts);
        opts.addOption("e", true, "Query to execute");
        opts.addOption("o", true, "Output to file");
        return opts;
    }

    @Override
    public int execute(String[] args) throws Exception {
        CommandLine cmdline = this.parseAndMiniSetup(args, "sql");
        if (cmdline.getArgs().length < 2) {
            return this.usage(0, "Missing connection");
        }
        CLISetup.doSpringUtilsAndCoreServicesSetup();
        SpringUtils.getInstance().registerAndAutowire(FilesBasedUsersDAO.class);
        SpringUtils.getInstance().registerAndAutowire(CredentialsService.class);
        String connectionName = cmdline.getArgs()[1];
        String sql = cmdline.getOptionValue("e");
        if (sql == null) {
            return this.usage(-1, "Missing sql expression");
        }
        CSVFormatConfig csv = new CSVFormatConfig();
        csv.style = CSVFormatConfig.CSVStyle.UNIX;
        csv.charset = "utf8";
        csv.setSeparatorStr("\t");
        csv.setQuoteStr("\"");
        csv.setEscapeStr("\\");
        csv.parseHeaderRow = true;
        OutputFormatter formatter = FormatFactory.buildFormatter(DSSAuthCtx.newNone(), null, "csv", csv);
        WarningsContext wc = new WarningsContext();
        formatter.setWarningsContext(wc);
        SQLConnectionProvider.SQLConnectionData connectionData = SQLConnectionProvider.getConnectionData_NT((AuthCtx)DSSAuthCtx.newNone(), null, connectionName);
        SQLDialect dialect = connectionData.getDialect();
        BufferedOutputStream bos = new BufferedOutputStream(System.out);
        try (SQLConnectionProvider.SQLConnectionWrapper conn = SQLConnectionProvider.newConnection(connectionData, (AuthCtx)DSSAuthCtx.newNone(), null);
             Statement stmt = SQLUtils.getProperlyStreamableStatement(connectionData, conn);){
            System.err.println("Execute " + sql);
            stmt.execute(sql);
            ResultSet resultSet = stmt.getResultSet();
            if (resultSet != null) {
                ResultSetMetaData resultSetMetadata = resultSet.getMetaData();
                Schema dssSchema = SchemaReader.metadataToSchema(connectionData.getDialect(), resultSetMetadata, AbstractSQLDatasetHandler.ReadTemporalMode.AS_IS, AbstractSQLDatasetHandler.ReadTemporalMode.AS_IS);
                formatter.setOutputSchema(dssSchema);
                StreamColumnFactory cf = new StreamColumnFactory();
                StreamRowFactory rf = new StreamRowFactory();
                ArrayList<Column> columns = new ArrayList<Column>();
                ArrayList<Type> types = new ArrayList<Type>();
                for (SchemaColumn sc : dssSchema.getColumns()) {
                    columns.add(cf.column(sc.getName()));
                    types.add(sc.getType());
                }
                formatter.header((ColumnFactory)cf, (OutputStream)bos);
                while (resultSet.next()) {
                    Row row = rf.row();
                    for (int i = 1; i <= columns.size(); ++i) {
                        String val = dialect.getValueAsDSSString(resultSet, resultSetMetadata.getColumnType(i), i, (SchemaColumn)dssSchema.getColumns().get(i - 1), true, false, DateTimeZone.UTC);
                        row.put((Column)columns.get(i - 1), val);
                    }
                    formatter.format(row, (ColumnFactory)cf, (OutputStream)bos);
                }
                formatter.footer((ColumnFactory)cf, (OutputStream)bos);
                bos.flush();
            }
        }
        return 0;
    }
}

