/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cli.internalcmd;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.cli.CLICommandWithInvalidateCommonFilesCache;
import com.dataiku.dip.cli.DKU;
import com.dataiku.dip.connections.FilesBasedConnectionsDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.git.ProjectCommitModeService;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.DKUTransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.variables.BackendVariablesService;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class SetMonitoringConfigCommand
extends CLICommandWithInvalidateCommonFilesCache {
    @Override
    public String usageString() {
        return "dku __set-monitoring-config";
    }

    @Override
    public String description() {
        return "Populates the graphite settings with values extracted from install.ini";
    }

    @Override
    public Options opts() {
        Options opts = new Options();
        DKU.addGlobalOptions(opts);
        return opts;
    }

    @Override
    public int execute(String[] args) throws Exception {
        Logger.getLogger((String)"org.springframework").setLevel(Level.WARN);
        ApplicationConfigurator.autoconfigure();
        try (AnnotationConfigApplicationContext appContext = new AnnotationConfigApplicationContext();){
            appContext.register(new Class[]{SpringUtils.class});
            appContext.register(new Class[]{DKUTransactionService.class});
            appContext.register(new Class[]{GeneralSettingsDAO.class});
            appContext.register(new Class[]{BackendVariablesService.class});
            appContext.register(new Class[]{ProjectCommitModeService.class});
            appContext.register(new Class[]{ScenarioRunContext.class});
            appContext.register(new Class[]{FilesBasedConnectionsDAO.class});
            appContext.refresh();
            try (DKUTransactionService ts = new DKUTransactionService();
                 RWTransaction rwt = ts.beginWriteAsDSS();){
                GeneralSettingsDAO.GeneralSettings settings = ((GeneralSettingsDAO)SpringUtils.getBean(GeneralSettingsDAO.class)).getUnsafe();
                if (StringUtils.isBlank((String)settings.graphiteServerUrl)) {
                    String graphiteServer = ApplicationConfigurator.getIniValue((String)"collectd", (String)"graphite_server");
                    String prefix = ApplicationConfigurator.getIniValue((String)"collectd", (String)"prefix");
                    int interval = 300;
                    String intervalAsString = ApplicationConfigurator.getIniValue((String)"collectd", (String)"interval");
                    if (intervalAsString != null) {
                        interval = Integer.parseInt(intervalAsString);
                        interval = interval < 60 ? 60 : interval;
                    }
                    settings.graphiteServerUrl = graphiteServer;
                    settings.graphiteMetricPrefix = prefix + ".backend.";
                    settings.graphiteReportingDelay = interval / 60;
                    ((GeneralSettingsDAO)SpringUtils.getBean(GeneralSettingsDAO.class)).save(settings);
                    rwt.commit("CLI: Enabled Monitoring integration (from command-line)");
                }
            }
        }
        return 0;
    }

    @Override
    protected boolean warnIfCacheInvalidationFails() {
        return false;
    }
}

