/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.ConnectionCredentialUtils;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithGlobalOAuth2Credentials;
import com.dataiku.dip.connections.ConnectionWithPerUserOAuth2Credentials;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.security.model.OAuth2Client;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.utils.Params;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.ParseException;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.log4j.Logger;

public interface ConnectionWithDatabricksCredentials
extends ConnectionWithBasicCredential,
ConnectionWithPerUserOAuth2Credentials,
ConnectionWithGlobalOAuth2Credentials {
    public static final String BASE_AZURE_OAUTH2_AUTH_ENDPOINT = "https://login.microsoftonline.com/${tenantId}/oauth2/v2.0/authorize";
    public static final String BASE_AZURE_OAUTH2_TOKEN_ENDPOINT = "https://login.microsoftonline.com/${tenantId}/oauth2/v2.0/token";
    public static final Logger logger = Logger.getLogger((String)"dku.databricks");

    @Nonnull
    public IDatabricksParams getNonResolvedParams();

    public ProxySettings getProxySettingsFromConnection();

    public Params getDkuPropertiesAsParams();

    public String getDefaultAuthScope();

    public boolean useOfflineConsentForOauth2();

    default public SerializableDatabricksCredentials getResolvedDatabricksCredentials(ConnectionWithBasicCredential.CredentialResolutionContext ctx) throws DKUSecurityException, IOException, SQLException {
        IDatabricksParams params = this.getNonResolvedParams();
        SerializableDatabricksCredentials creds = new SerializableDatabricksCredentials();
        creds.authType = params.getAuthType();
        switch (creds.authType) {
            case OAUTH2_APP: {
                OAuth2Client.AccessTokenResult accessTokenResponse = this.getAccessTokenResponse(ctx.authCtx, this.getProxySettingsFromConnection());
                if (((DSSConnection)((Object)this)).credentialsMode == DSSConnection.CredentialsMode.PER_USER) {
                    creds.oauth2RefreshToken = accessTokenResponse.getRefreshToken();
                }
                creds.oauth2AccessToken = accessTokenResponse.getAccessToken();
                creds.oauth2AccessTokenExpiresOn = accessTokenResponse.getExpiresOn() == null ? -1L : accessTokenResponse.getExpiresOn().getTime();
                break;
            }
            case PERSONAL_ACCESS_TOKEN: {
                ICredentialsService.BasicCredential basicCreds = ConnectionCredentialUtils.getDecryptedBasicCredential_autoTXN((DSSConnection)((Object)this), ctx.authCtx);
                creds.personalToken = basicCreds.password;
            }
        }
        return creds;
    }

    @Override
    default public boolean actuallyHasPerUserOAuth2Credential() {
        IDatabricksParams params = this.getNonResolvedParams();
        return ((DSSConnection)((Object)this)).credentialsMode == DSSConnection.CredentialsMode.PER_USER && params.getAuthType() == AuthType.OAUTH2_APP;
    }

    @Override
    default public boolean hasRefreshTokenRotation() {
        IDatabricksParams params = this.getNonResolvedParams();
        return params.getRefreshTokenRotation();
    }

    @Override
    default public boolean actuallyHasGlobalOAuth2Credential() {
        IDatabricksParams params = this.getNonResolvedParams();
        return ((DSSConnection)((Object)this)).credentialsMode == DSSConnection.CredentialsMode.GLOBAL && params.getAuthType() == AuthType.OAUTH2_APP;
    }

    @Override
    default public boolean actuallyHasBasicCredential() {
        IDatabricksParams params = this.getNonResolvedParams();
        return params.getAuthType() == AuthType.PERSONAL_ACCESS_TOKEN;
    }

    @Override
    default public OAuth2Client buildOAuth2Client(ProxySettings proxySettings, AuthCtx authCtx) throws DKUSecurityException {
        IDatabricksParams params = this.getNonResolvedParams();
        String authorizationEndpoint = StringUtils.defaultIfBlank((String)params.getOAuth2AuthorizationEndpoint(), (String)BASE_AZURE_OAUTH2_AUTH_ENDPOINT);
        String tokenEndpoint = StringUtils.defaultIfBlank((String)params.getOAuth2TokenEndpoint(), (String)BASE_AZURE_OAUTH2_TOKEN_ENDPOINT);
        StrSubstitutor subst = new StrSubstitutor((Map)ImmutableMap.of((Object)"tenantId", (Object)StringUtils.defaultIfBlank((String)params.getOAuth2AzureTenantId(), (String)"")));
        authorizationEndpoint = subst.replace(authorizationEndpoint);
        tokenEndpoint = subst.replace(tokenEndpoint);
        logger.info((Object)("Using OAuth2 authorize endpoint: " + authorizationEndpoint));
        logger.info((Object)("Using OAuth2 token endpoint: " + tokenEndpoint));
        boolean useCache = this.getDkuPropertiesAsParams().getBoolParam("dku.connection.oauth.enableCache", true);
        OAuth2Client.Builder builder = new OAuth2Client.Builder().authorizationEndpoint(authorizationEndpoint).tokenEndpoint(tokenEndpoint).clientId(params.getOAuth2ClientId()).usePkce(true).scope(StringUtils.defaultIfBlank((String)params.getOAuth2Scope(), (String)this.getDefaultAuthScope())).proxy(proxySettings).useAccessTokenCache(useCache);
        if (StringUtils.isNotEmpty((String)params.getOAuth2ClientSecret())) {
            builder.clientSecret(params.getOAuth2ClientSecret());
        }
        if (this.useOfflineConsentForOauth2()) {
            builder.accessType(OAuth2Client.AccessType.OFFLINE).prompt(OAuth2Client.PromptType.CONSENT);
        }
        return builder.build();
    }

    @Override
    default public ICredentialsService.OAuth2Credential getResolvedOAuth2Credential(AuthCtx authCtx) {
        return new ICredentialsService.OAuth2Credential(this.getAccessTokenResponse(authCtx, this.getProxySettingsFromConnection()).getAccessToken());
    }

    default public OAuth2Client.AccessTokenResult getAccessTokenResponse(AuthCtx authCtx, ProxySettings proxySettings) {
        boolean useCache = this.getDkuPropertiesAsParams().getBoolParam("dku.connection.oauth.enableCache", true);
        logger.info((Object)"Exchanging user's refresh token for an access token");
        try {
            OAuth2Client oAuth2Client = this.buildOAuth2Client(proxySettings, authCtx);
            if (((DSSConnection)((Object)this)).credentialsMode == DSSConnection.CredentialsMode.PER_USER) {
                return this.getAccessTokenFromRefreshTokenAndUpdateIfNeeded(authCtx, oAuth2Client, false);
            }
            return oAuth2Client.acquireAccessTokenResultWithClientCredentialsGrant(useCache);
        }
        catch (DKUSecurityException e) {
            throw new CodedRuntimeException(e.getCode(), "Failed to get OAuth2 access token", (Throwable)e);
        }
        catch (ParseException | IOException | URISyntaxException e) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Failed to get OAuth2 access token", e);
        }
    }

    public static interface IDatabricksParams {
        public AuthType getAuthType();

        public String getOAuth2ClientId();

        public String getOAuth2ClientSecret();

        public String getOAuth2AuthorizationEndpoint();

        public String getOAuth2TokenEndpoint();

        public String getOAuth2AzureTenantId();

        public String getOAuth2Scope();

        public boolean getRefreshTokenRotation();
    }

    public static class SerializableDatabricksCredentials
    implements ICredentialsService.BasicCredentialConvertible,
    OAuth2Client.AccessTokenCredentialConvertible {
        public AuthType authType;
        public String personalToken;
        public String oauth2RefreshToken;
        public String oauth2AccessToken;
        public long oauth2AccessTokenExpiresOn;

        @Override
        public ICredentialsService.BasicCredential toBasicCredential() {
            return new ICredentialsService.BasicCredential("", this.personalToken);
        }

        public ICredentialsService.OAuth2CredentialWithExpiry toOAuth2Credential() {
            return new ICredentialsService.OAuth2CredentialWithExpiry(this.oauth2AccessToken, this.oauth2AccessTokenExpiresOn);
        }

        @Override
        public OAuth2Client.SerializableAccessTokenResult toSerializableAccessTokenResult() {
            return new OAuth2Client.SerializableAccessTokenResult(this.oauth2AccessToken, this.oauth2AccessTokenExpiresOn);
        }
    }

    public static enum AuthType {
        PERSONAL_ACCESS_TOKEN,
        OAUTH2_APP;

    }
}

