/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.AbstractCloudStorageConnection;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.AccessTokenInjectingConnection;
import com.dataiku.dip.connections.AutoFastPathConnection;
import com.dataiku.dip.connections.AzureConnection;
import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithDatabricksCredentials;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.DatabricksVolumeConnection;
import com.dataiku.dip.connections.EC2Connection;
import com.dataiku.dip.connections.FSProviderizableConnection;
import com.dataiku.dip.connections.HDFSConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.ConfValidators;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.server.services.ConnectionsTestService;
import com.dataiku.dip.sql.DatabricksSQLDialect;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DatabricksConnection
extends AbstractSQLConnection
implements ConnectionWithDatabricksCredentials,
ConnectionWithEncryptedFields,
AutoFastPathConnection,
AccessTokenInjectingConnection,
FSProviderizableConnection {
    public static final String AZURE_SCOPE = "2ff814a6-3304-4ab8-85cb-cd0e6f879c1d/.default offline_access";
    private static final DatabricksSQLDialect dialect = new DatabricksSQLDialect();
    public Params params = new Params();
    public static final String connectionType = "Databricks";
    private static final Logger logger = Logger.getLogger((String)"dku.databricks");

    @Override
    public boolean useAutoFastConnection() {
        return this.params.useAutoFastPath;
    }

    @Override
    public String getAutoFastPathConnection() {
        return this.params.autoFastPathConnection;
    }

    @Override
    public String getAutoFastPathConnectionPath() {
        return this.params.autoFastPathConnectionPath;
    }

    @Override
    public boolean isSupportedCloudStorage(AbstractCloudStorageConnection connection) {
        return connection instanceof EC2Connection || connection instanceof AzureConnection || connection instanceof DatabricksVolumeConnection;
    }

    @Override
    public Params getParams() {
        return this.params;
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public DatabricksSQLDialect getDialect() {
        return dialect;
    }

    @Override
    public String getDriver() {
        return StringUtils.isEmpty((String)this.params.driver) ? "com.databricks.client.jdbc.Driver" : this.params.driver;
    }

    @Override
    public List<String> getKnownDriverJars() {
        return super.getKnownDriverJarsFromJarsDirectory();
    }

    @Override
    public String getJdbcUrl() {
        if (this.params.useURL) {
            if (StringUtils.isBlank((String)this.params.url)) {
                throw ErrorContext.iae((String)"Databricks connection JDBC URL is not set");
            }
            return this.params.url;
        }
        ConfValidators.checkNotBlankRuntime(this.params.host, ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Host");
        String url = "jdbc:databricks://" + this.params.host + ":" + this.params.port;
        return url;
    }

    @Override
    String getJarsDirectory() {
        if (StringUtils.isNotBlank((String)this.params.driver)) {
            return this.params.jarsDirectory;
        }
        switch (this.params.driverMode) {
            case MANAGED: {
                return DKUApp.getInstallFile((String[])new String[]{"lib", "ivy", "jdbc-databricks"}).getAbsolutePath();
            }
            case CUSTOM: {
                return this.params.jarsDirectory;
            }
        }
        throw new Error("unreachable");
    }

    @Override
    public String getDisplayableJdbcUrl() {
        return this.getJdbcUrl();
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        assert (clazz.isAssignableFrom(ConnectionWithDatabricksCredentials.SerializableDatabricksCredentials.class));
        ConnectionWithDatabricksCredentials.SerializableDatabricksCredentials creds = this.getResolvedDatabricksCredentials(ctx);
        return clazz.cast(creds);
    }

    @Override
    public void encryptFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings unused) {
        this.params.password = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.password);
        this.params.clientSecret = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.clientSecret);
    }

    @Override
    public void decryptFields(PasswordEncryptionService cryptoService) {
        this.params.password = cryptoService.decryptIfEncrypted(this.params.password);
        this.params.clientSecret = cryptoService.decryptIfEncrypted(this.params.clientSecret);
    }

    @Override
    public ICredentialsService.BasicCredential getGlobalCredential() {
        return new ICredentialsService.BasicCredential(this.params.user, this.params.password);
    }

    @Override
    public SQLConnectionProvider.SQLConnectionData getConnectionData_NT(AuthCtx authCtx, String projectKey) throws DKUSecurityException, SQLException {
        ConnectionWithDatabricksCredentials.SerializableDatabricksCredentials creds = this.getFullyResolvedCredentials_sqlLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, projectKey), ConnectionWithDatabricksCredentials.SerializableDatabricksCredentials.class);
        SQLConnectionProvider.GenericSQLConnectionData cd = this.makeInjectingSQLConnectionData(ConnectionUtils.SQLConnectionType.valueOf(this.type.toUpperCase()), this.getDialect(), this, this.getDriver(), this.getJdbcUrl(), this.getJarsDirectory());
        this.fillConnectionData(cd);
        ProxySettings proxySettings = this.getProxySettings();
        Map proxyProps = ProxyUtils.getSimbaLikeProxyProperties((ProxySettings)proxySettings);
        for (Map.Entry e : proxyProps.entrySet()) {
            cd.withProperty(new AbstractSQLConnection.CustomDatabaseProperty((String)e.getKey(), (String)e.getValue(), ((String)e.getKey()).toLowerCase().contains("pwd")));
        }
        if (creds.authType == ConnectionWithDatabricksCredentials.AuthType.PERSONAL_ACCESS_TOKEN) {
            cd.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("PWD", creds.personalToken, true));
        } else if (creds.authType == ConnectionWithDatabricksCredentials.AuthType.OAUTH2_APP) {
            cd.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("AuthMech", "11", false));
            cd.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("Auth_Flow", "0", false));
            cd.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("Auth_AccessToken", creds.oauth2AccessToken, true));
        }
        return cd;
    }

    @Override
    void fillConnectionData(SQLConnectionProvider.SQLConnectionData cd) {
        super.fillConnectionData(cd);
        if (!this.params.useURL) {
            cd.withProperty("transportMode", "http");
            cd.withProperty("httpPath", this.params.httpPath);
            cd.withProperty("ssl", "1");
            cd.withProperty("AuthMech", "3");
            cd.withProperty("UID", "token");
            cd.withProperty("PreparedMetaLimitZero", "1");
        }
        cd.withProperty("UserAgentEntry", "dataiku");
    }

    @Override
    public ConnectionWithDatabricksCredentials.IDatabricksParams getNonResolvedParams() {
        return this.params;
    }

    @Override
    public ProxySettings getProxySettingsFromConnection() {
        return this.getProxySettings();
    }

    @Override
    public String getDefaultAuthScope() {
        return AZURE_SCOPE;
    }

    @Override
    public boolean useOfflineConsentForOauth2() {
        return false;
    }

    public JsonObject getResolvedParams(AuthCtx authCtx, @Nullable String projectKey) throws IOException {
        Params resolvedParams = (Params)JSON.deepCopy((Object)this.params);
        VariablesService variablesService = (VariablesService)SpringUtils.getBean(VariablesService.class);
        VariablesContext vc = projectKey == null ? variablesService.getForConnection(this, authCtx) : variablesService.getForConnectionAndProject(this, authCtx, projectKey);
        resolvedParams.host = vc.expand(resolvedParams.host);
        resolvedParams.db = vc.expand(resolvedParams.db);
        resolvedParams.defaultCatalog = vc.expand(resolvedParams.defaultCatalog);
        resolvedParams.defaultSchema = vc.expand(resolvedParams.defaultSchema);
        resolvedParams.httpPath = vc.expand(resolvedParams.httpPath);
        JsonObject result = JSON.toJsonObject((Object)resolvedParams);
        if (StringUtils.isNotBlank((String)resolvedParams.postConnectStatements)) {
            String postConnectStatements = vc.expand(resolvedParams.postConnectStatements);
            String[] postConnectStatementExpandedAndSplit = dialect.getSplitter().split(postConnectStatements);
            result.add("postConnectStatementsExpandedAndSplit", (JsonElement)JSON.toJsonArray((Object)postConnectStatementExpandedAndSplit));
        }
        return result;
    }

    @Override
    public boolean mustResolveOnBackend() {
        return this.hasRefreshTokenRotation() || super.mustResolveOnBackend();
    }

    @Override
    public AccessTokenInjectingConnection.AccessTokenInjector buildAccessTokenInjector(final Connection connection, Properties properties) {
        return new AccessTokenInjectingConnection.AccessTokenInjector(){

            @Override
            public void inject(String accessToken) throws SQLException, InterruptedException, IOException, DKUSecurityException {
                connection.setClientInfo("Auth_AccessToken", accessToken);
            }
        };
    }

    @Override
    public boolean needsAccessTokenInjection() {
        return this.params.authType == ConnectionWithDatabricksCredentials.AuthType.OAUTH2_APP;
    }

    @Override
    public List<String> getProviderTypes() {
        ArrayList<String> providerTypes = new ArrayList<String>();
        if (this.allowManagedFolders) {
            providerTypes.add("DatabricksVolume");
        }
        return providerTypes;
    }

    @Override
    public boolean allowManagedFolders() {
        return true;
    }

    public DatabricksVolumeConnection asDatabricksVolumeConnection() {
        JsonObject connAsJson = JSON.toJsonObject((Object)this);
        connAsJson.addProperty("type", "DatabricksVolume");
        connAsJson.getAsJsonObject("params").remove("namingRule");
        DatabricksVolumeConnection dbVolConn = (DatabricksVolumeConnection)JSON.parse((JsonElement)connAsJson, DatabricksVolumeConnection.class);
        dbVolConn.params.chvolume = this.params.chvolume;
        dbVolConn.params.chroot = this.params.chroot;
        dbVolConn.params.defaultManagedVolume = this.params.defaultManagedVolume;
        dbVolConn.params.defaultManagedPath = this.params.defaultManagedPath;
        dbVolConn.params.catalog = StringUtils.defaultIfBlank((String)this.params.defaultCatalog, (String)"main");
        dbVolConn.params.schema = StringUtils.defaultIfBlank((String)this.params.defaultSchema, (String)"default");
        dbVolConn.params.metastoreSynchronizationMode = HDFSConnection.HiveSynchronizationMode.NO_SYNC;
        return dbVolConn;
    }

    @Override
    public ConnectionsTestService.ConnectionTestResult testConnection(AuthCtx authCtx, ConnectionsTestService connectionsTestService) throws Exception {
        return connectionsTestService.testSQL_NOTRANSACTION(null, this, authCtx);
    }

    public static class Params
    extends AbstractSQLConnection.AbstractSQLParamsWithStdFields
    implements ConnectionWithDatabricksCredentials.IDatabricksParams {
        public ConnectionWithDatabricksCredentials.AuthType authType = ConnectionWithDatabricksCredentials.AuthType.PERSONAL_ACCESS_TOKEN;
        private static final Pattern WAREHOUSE_MATCHER = Pattern.compile("httppath=[^;]*\\/warehouses\\/");
        public DatabricksDriverMode driverMode = DatabricksDriverMode.MANAGED;
        public String driver;
        public int port = 443;
        public boolean ssl = true;
        public String defaultCatalog;
        public String defaultSchema;
        public String httpPath;
        public String clientId;
        public String clientSecret;
        public String authorizationEndpoint;
        public String tokenEndpoint;
        public String scope;
        public boolean refreshTokenRotation;
        public List<SimpleKeyValue> storageCredentials = Lists.newArrayList();
        public boolean useAutoFastPath;
        public String autoFastPathConnection;
        public String autoFastPathConnectionPath;
        public String defaultManagedVolume;
        public String defaultManagedPath;
        public String chvolume;
        public String chroot;

        public String getStorageCredentials(String bucketOrStorageAccount) {
            for (SimpleKeyValue storedCredential : this.storageCredentials) {
                String regex;
                if (StringUtils.isBlank((String)storedCredential.key) || !Pattern.matches(regex = storedCredential.key.replace("*", ".*"), bucketOrStorageAccount)) continue;
                return StringUtils.defaultIfEmpty((String)storedCredential.value, (String)"");
            }
            return null;
        }

        public boolean suspectSQLWarehouse() {
            if (this.useURL) {
                return WAREHOUSE_MATCHER.matcher(StringUtils.defaultIfEmpty((String)this.url, (String)"").toLowerCase()).find();
            }
            return this.httpPath.contains("/warehouses/");
        }

        @Override
        public ConnectionWithDatabricksCredentials.AuthType getAuthType() {
            return this.authType;
        }

        @Override
        public String getOAuth2ClientId() {
            return this.clientId;
        }

        @Override
        public String getOAuth2ClientSecret() {
            return this.clientSecret;
        }

        @Override
        public String getOAuth2AuthorizationEndpoint() {
            return this.authorizationEndpoint;
        }

        @Override
        public String getOAuth2TokenEndpoint() {
            return this.tokenEndpoint;
        }

        @Override
        public String getOAuth2AzureTenantId() {
            return null;
        }

        @Override
        public String getOAuth2Scope() {
            return this.scope;
        }

        @Override
        public boolean getRefreshTokenRotation() {
            return this.refreshTokenRotation;
        }
    }

    public static enum DatabricksDriverMode {
        MANAGED,
        CUSTOM;

    }
}

