/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections.bigquery.builtin;

import com.dataiku.dip.connections.bigquery.BigQueryExecutionInfo;
import com.dataiku.dip.connections.bigquery.builtin.BigQueryAvroResultSet;
import com.dataiku.dip.connections.bigquery.builtin.BigQueryAvroRowIterator;
import com.dataiku.dip.connections.bigquery.builtin.BigQueryExecutionInfoProvider;
import com.dataiku.dip.connections.bigquery.builtin.BigQueryFieldValueResultSet;
import com.dataiku.dip.connections.bigquery.builtin.BigQueryJdbcConnection;
import com.dataiku.dip.connections.bigquery.builtin.BigQueryResultSet;
import com.dataiku.dip.connections.bigquery.builtin.QueryParameter;
import com.dataiku.dip.sql.bigquery.AvroRowReader;
import com.dataiku.dip.sql.bigquery.AvroRowReaderWorker;
import com.dataiku.dip.sql.bigquery.BigQueryAbortedOperationException;
import com.dataiku.dip.sql.bigquery.BigQueryNativeClient;
import com.dataiku.dip.sql.bigquery.PartitionFilter;
import com.dataiku.dip.sql.bigquery.QueryResult;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.BigQuery;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.BigQueryException;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.Job;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.QueryJobConfiguration;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.Schema;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.StandardSQLTypeName;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.Table;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.TableDefinition;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.TableId;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.TableResult;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.storage.v1.AvroRows;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.storage.v1.AvroSchema;
import com.dataiku.dss.shadelib.com.google.common.annotations.VisibleForTesting;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.commons.lang3.StringUtils;

public class BigQueryStatement
implements PreparedStatement {
    private final BigQueryJdbcConnection connection;
    private final String sql;
    private final List<QueryParameter> parameters = new ArrayList<QueryParameter>();
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    private BigQueryResultSet resultSet;
    private boolean closed;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.sql.bigquery");

    public BigQueryStatement(BigQueryJdbcConnection connection) {
        this.connection = connection;
        this.sql = null;
    }

    public BigQueryStatement(BigQueryJdbcConnection connection, String sql) {
        this.connection = connection;
        this.sql = sql;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.execute(sql);
        return this.resultSet;
    }

    public ResultSet executeQuery(String sql, boolean dryRun) throws SQLException {
        this.execute(sql, dryRun);
        return this.resultSet;
    }

    @Override
    public int executeUpdate(String sql) {
        return 0;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.execute(sql, false);
    }

    public boolean execute(String sql, boolean dryRun) throws SQLException {
        SelectStarStatement selectStarStatement;
        Preconditions.checkNotNull((Object)sql, (Object)"sql must not be null");
        this.resultSet = sql.startsWith("PREVIEW TABLE") ? this.executePreviewTable(sql) : (this.connection.isReadTableForSimpleSelectEnabled() ? ((selectStarStatement = SelectStarStatement.parse(sql, this.connection.getProjectId())) != null ? this.executeSelectStarQuery(sql, selectStarStatement, dryRun) : this.executeBigQueryQuery(sql, dryRun)) : this.executeBigQueryQuery(sql, dryRun));
        return this.resultSet != null;
    }

    private BigQueryResultSet executeSelectStarQuery(String sql, SelectStarStatement statement, boolean dryRun) throws SQLException {
        Preconditions.checkNotNull((Object)statement, (Object)"statement cannot be null");
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)statement.datasetId) ? 1 : 0) != 0, (Object)"BigQuery dataset Id cannot be empty or null");
        TableId tableId = TableId.of((String)statement.projectId, (String)statement.datasetId, (String)statement.tableName);
        BigQueryNativeClient client = this.connection.getBigQueryClient();
        Table table = client.getTable(tableId);
        if (table == null || !this.supportListData(table)) {
            logger.infoV("Detected 'SELECT * FROM' query but cannot directly read the table (reason: %s). Executing query instead", new Object[]{table == null ? "table cannot be found" : String.format("table is of type %s", table.getDefinition().getType())});
            return this.executeBigQueryQuery(sql, dryRun);
        }
        logger.info((Object)"Detected 'SELECT * FROM' query. Trying to read the table directly rather than executing query");
        if (this.shouldUseStorageReadAPI(table, statement.maxRecords)) {
            logger.infoV("Using the BigQuery Storage Read API to retrieve table rows for %s:%s.%s.", new Object[]{statement.projectId, statement.datasetId, statement.tableName});
            try {
                return this.readStorageTableData(tableId, BigQueryExecutionInfo.restExecution(), statement.maxRecords);
            }
            catch (RuntimeException e) {
                logger.warn((Object)"Failed to use the BigQuery Storage Read API to read table rows. Falling back to executing the query", (Throwable)e);
                return this.executeBigQueryQuery(sql, dryRun);
            }
        }
        logger.infoV("Using the BigQuery REST API to retrieve table rows for %s:%s.%s.", new Object[]{statement.projectId, statement.datasetId, statement.tableName});
        return this.readTableDataWithRestAPI(client, table, statement.maxRecords);
    }

    private BigQueryResultSet readPartitionedTableDataWithRestAPI(BigQueryNativeClient client, String projectId, String datasetId, String tableName, PartitionFilter partitionFilter, long maxRecords) throws BigQueryException {
        String decoratedTableName = String.format("%s$%s", tableName, partitionFilter.getDecorator());
        logger.infoV("Using partition decorator: %s", new Object[]{decoratedTableName});
        TableId decoratedTableId = TableId.of((String)projectId, (String)datasetId, (String)decoratedTableName);
        Table decoratedTable = client.getTable(decoratedTableId);
        if (decoratedTable == null || !this.supportListData(decoratedTable)) {
            String reason = decoratedTable == null ? "table cannot be found" : String.format("table is of type %s", decoratedTable.getDefinition().getType());
            throw new BigQueryException(0, "Unable to use BigQuery REST API with partition-decorated table " + decoratedTableName + ", since " + reason);
        }
        return this.readTableDataWithRestAPI(client, decoratedTable, maxRecords);
    }

    private BigQueryResultSet executePreviewTableWithPartitionFilter(BigQueryNativeClient client, @Nonnull Table table, TableId tableId, PartitionFilter partitionFilter, long maxRecords, boolean forbidPreviewFallbackToSelect) throws SQLException {
        try {
            if (this.shouldUseStorageReadAPI(table, maxRecords)) {
                logger.infoV("Using the BigQuery Storage Read API to retrieve table rows for %s:%s.%s on partition %s=%s.", new Object[]{tableId.getProject(), tableId.getDataset(), tableId.getTable(), partitionFilter.name(), partitionFilter.value()});
                try {
                    return this.readStoragePartitionedTableData(tableId, partitionFilter, BigQueryExecutionInfo.restExecution(), maxRecords);
                }
                catch (RuntimeException e) {
                    logger.warnV((Throwable)e, "Failed to use the BigQuery Storage Read API to preview table. Fall back to the REST API on partition %s=%s.", new Object[]{partitionFilter.name(), partitionFilter.value()});
                    return this.readPartitionedTableDataWithRestAPI(client, tableId.getProject(), tableId.getDataset(), tableId.getTable(), partitionFilter, maxRecords);
                }
            }
            logger.infoV("Using the REST API to retrieve table rows for %s:%s.%s on partition %s=%s.", new Object[]{tableId.getProject(), tableId.getDataset(), tableId.getTable(), partitionFilter.name(), partitionFilter.value()});
            return this.readPartitionedTableDataWithRestAPI(client, tableId.getProject(), tableId.getDataset(), tableId.getTable(), partitionFilter, maxRecords);
        }
        catch (BigQueryException bqException) {
            if (forbidPreviewFallbackToSelect) {
                throw new SQLException("Unable to use BigQuery table PREVIEW: " + bqException.getMessage() + ". Using SELECT instead is forbidden by dataset config");
            }
            logger.warnV((Throwable)bqException, "Error occurred while using BigQuery preview. Fall back to SELECT * WHERE query on partition instead.", new Object[0]);
            return this.executeSafePreviewTableWithPartitionFilter(tableId.getProject(), tableId.getDataset(), tableId.getTable(), partitionFilter, maxRecords);
        }
    }

    private BigQueryResultSet executePreviewTable(String sql) throws SQLException {
        String[] items = sql.split("\n");
        if (items.length != 6 && items.length != 10) {
            throw new SQLException("Invalid PREVIEW TABLE query: " + sql);
        }
        BigQueryNativeClient client = this.connection.getBigQueryClient();
        String projectId = (String)StringUtils.defaultIfBlank((CharSequence)items[1], (CharSequence)client.getProjectId());
        String datasetId = items[2];
        String tableName = items[3];
        long maxRecords = Long.parseLong(items[4]);
        boolean forbidPreviewFallbackToSelect = Boolean.parseBoolean(items[5]);
        PartitionFilter partitionFilter = null;
        if (items.length == 10) {
            try {
                partitionFilter = new PartitionFilter(items[6], items[7], items[8], items[9]);
            }
            catch (IllegalArgumentException e) {
                throw new SQLException("Invalid partition info details in PREVIEW TABLE query: " + sql, e);
            }
        }
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)datasetId) ? 1 : 0) != 0, (Object)"BigQuery dataset Id cannot be empty or null.");
        TableId tableId = TableId.of((String)projectId, (String)datasetId, (String)tableName);
        Table table = client.getTable(tableId);
        if (table == null || !this.supportListData(table)) {
            String reason;
            String string = reason = table == null ? "table cannot be found" : String.format("table is of type %s", table.getDefinition().getType());
            if (forbidPreviewFallbackToSelect) {
                throw new SQLException("Unable to use BigQuery table PREVIEW, since " + reason + ". Using SELECT instead is forbidden by dataset config");
            }
            if (partitionFilter != null) {
                logger.warnV("Unable to use PREVIEW feature as %s. Executing a SELECT * WHERE partition %s LIMIT query instead.", new Object[]{reason, partitionFilter.whereClause()});
                return this.executeSafePreviewTableWithPartitionFilter(tableId.getProject(), tableId.getDataset(), tableId.getTable(), partitionFilter, maxRecords);
            }
            logger.warnV("Unable to use PREVIEW feature as %s. Executing a SELECT * LIMIT query instead.", new Object[]{reason});
            return this.executeSafePreviewTable(projectId, datasetId, tableName, maxRecords);
        }
        if (partitionFilter != null) {
            return this.executePreviewTableWithPartitionFilter(client, table, tableId, partitionFilter, maxRecords, forbidPreviewFallbackToSelect);
        }
        try {
            if (this.shouldUseStorageReadAPI(table, maxRecords)) {
                logger.infoV("Using the BigQuery Storage Read API to retrieve table rows for %s:%s.%s.", new Object[]{projectId, datasetId, tableName});
                try {
                    return this.readStorageTableData(tableId, BigQueryExecutionInfo.restExecution(), maxRecords);
                }
                catch (RuntimeException e) {
                    logger.warn((Object)"Failed to use the BigQuery Storage Read API to preview table. Fall back to the REST API", (Throwable)e);
                    return this.readTableDataWithRestAPI(client, table, maxRecords);
                }
            }
            return this.readTableDataWithRestAPI(client, table, maxRecords);
        }
        catch (BigQueryException bqException) {
            if (forbidPreviewFallbackToSelect) {
                throw new SQLException("Unable to use BigQuery table PREVIEW: " + bqException.getMessage() + ". Using SELECT instead is forbidden by dataset config");
            }
            logger.warn((Object)"Error occurred while using listData to preview table. Fall back to SELECT * LIMIT query.", (Throwable)bqException);
            return this.executeSafePreviewTable(projectId, datasetId, tableName, maxRecords);
        }
    }

    private BigQueryResultSet executeSafePreviewTable(String projectId, String datasetId, String tableName, long maxRecords) throws SQLException {
        Object sqlQuery = String.format("SELECT * FROM `%s`.`%s`.`%s`", projectId, datasetId, tableName);
        if (maxRecords >= 0L) {
            sqlQuery = (String)sqlQuery + String.format(" LIMIT %s", maxRecords);
        }
        return this.executeBigQueryQuery((String)sqlQuery, false);
    }

    private BigQueryResultSet executeSafePreviewTableWithPartitionFilter(String projectId, String datasetId, String tableName, PartitionFilter partitionFilter, long maxRecords) throws SQLException {
        Object sqlQuery = String.format("SELECT * FROM `%s`.`%s`.`%s` WHERE %s", projectId, datasetId, tableName, partitionFilter.getWhereClause());
        if (maxRecords >= 0L) {
            sqlQuery = (String)sqlQuery + String.format(" LIMIT %s", maxRecords);
        }
        return this.executeBigQueryQuery((String)sqlQuery, false);
    }

    private boolean supportListData(Table table) {
        TableDefinition.Type type = table.getDefinition().getType();
        return type == TableDefinition.Type.TABLE || type == TableDefinition.Type.SNAPSHOT;
    }

    private BigQueryFieldValueResultSet readTableDataWithRestAPI(BigQueryNativeClient client, Table table, long maxRecords) {
        TableId tableId = table.getTableId();
        TableResult tableData = maxRecords >= 0L ? client.getTableData(tableId, BigQuery.TableDataListOption.pageSize((long)maxRecords)) : client.getTableData(tableId, new BigQuery.TableDataListOption[0]);
        Schema schema = tableData.getSchema();
        if (schema == null) {
            schema = table.getDefinition().getSchema();
        }
        return new BigQueryFieldValueResultSet(this, maxRecords, schema, tableData, BigQueryExecutionInfo.restExecution());
    }

    private BigQueryResultSet executeBigQueryQuery(String sql, boolean dryRun) throws SQLException {
        try {
            BigQueryNativeClient client = this.connection.getBigQueryClient();
            QueryResult queryResult = client.executeQuery(null, sql, this.parameters, dryRun, this.connection.getMaxResults(), this.cancelled);
            if (this.cancelled.get()) {
                throw new BigQueryAbortedOperationException("Statement was cancelled");
            }
            if (dryRun) {
                BigQueryExecutionInfo executionInfo = queryResult.getExecutionInfo();
                if (executionInfo.queryStatistics != null) {
                    return new BigQueryFieldValueResultSet(this, -1L, executionInfo.queryStatistics.getSchema(), executionInfo);
                }
                return null;
            }
            if (this.shouldUseStorageReadAPI(queryResult)) {
                logger.info((Object)"Using the BigQuery Storage Read API to retrieve the result set.");
                try {
                    Job job = queryResult.getJob();
                    TableId tableId = ((QueryJobConfiguration)job.getConfiguration()).getDestinationTable();
                    return this.readStorageTableData(tableId, queryResult);
                }
                catch (RuntimeException e) {
                    logger.warn((Object)"Failed to use the BigQuery Storage Read API to retrieve the result set. Fall back to the REST API", (Throwable)e);
                    return new BigQueryFieldValueResultSet(this, queryResult.tableResult, (BigQueryExecutionInfoProvider)queryResult);
                }
            }
            if (queryResult.tableResult.getSchema() != null) {
                return new BigQueryFieldValueResultSet(this, queryResult.tableResult, (BigQueryExecutionInfoProvider)queryResult);
            }
            return null;
        }
        catch (RuntimeException e) {
            throw new SQLException(e);
        }
    }

    private boolean shouldUseStorageReadAPI(Table table, long maxRecords) {
        if (table == null) {
            logger.info((Object)"Not using StorageReadAPI because destination table is unknown.");
            return false;
        }
        if (this.connection.isHighThroughputAPIForced()) {
            logger.info((Object)"Forcing StorageReadAPI because isHighThroughputAPIForced is true.");
            return true;
        }
        if (!this.connection.isHighThroughputAPIEnabled()) {
            logger.info((Object)"Not using StorageReadAPI because isHighThroughputAPIEnabled is false.");
            return false;
        }
        BigInteger tableNumRows = table.getNumRows();
        if (maxRecords > 0L) {
            tableNumRows = tableNumRows.min(BigInteger.valueOf(maxRecords));
        }
        return this.shouldUseStorageReadAPI(tableNumRows);
    }

    private boolean shouldUseStorageReadAPI(QueryResult queryResult) {
        if (this.connection.isHighThroughputAPIForced()) {
            logger.info((Object)"Forcing StorageReadAPI because isHighThroughputAPIForced is true.");
            TableId tableId = ((QueryJobConfiguration)queryResult.getJob().getConfiguration()).getDestinationTable();
            if (tableId == null) {
                logger.info((Object)"Not using StorageReadAPI because destination table is unknown.");
                return false;
            }
            return true;
        }
        if (queryResult.allRowsFetched) {
            logger.debug((Object)"Not using StorageReadAPI because all rows have been retrieved already.");
            return false;
        }
        if (!this.connection.isHighThroughputAPIEnabled()) {
            logger.info((Object)"Not using StorageReadAPI because isHighThroughputAPIEnabled is false.");
            return false;
        }
        TableId tableId = ((QueryJobConfiguration)queryResult.getJob().getConfiguration()).getDestinationTable();
        if (tableId == null) {
            logger.info((Object)"Not using StorageReadAPI because destination table is unknown.");
            return false;
        }
        BigInteger tableNumRows = BigInteger.valueOf(queryResult.tableResult.getTotalRows());
        return this.shouldUseStorageReadAPI(tableNumRows);
    }

    private boolean shouldUseStorageReadAPI(BigInteger tableNumRows) {
        BigInteger minTableSize = BigInteger.valueOf(this.connection.getHighThroughputMinTableSize());
        BigInteger activationRatio = BigInteger.valueOf(this.connection.getHighThroughputActivationRatio());
        BigInteger maxResultsPerPage = BigInteger.valueOf(this.connection.getMaxResults());
        if (tableNumRows.compareTo(minTableSize) < 0) {
            logger.info((Object)String.format("Not using StorageReadAPI because tableNumRows (%s) < minTableSize (%s).", tableNumRows, minTableSize));
            return false;
        }
        if (tableNumRows.compareTo(activationRatio.multiply(maxResultsPerPage)) < 0) {
            logger.info((Object)String.format("Not using StorageReadAPI because tableNumRows (%s) < activationRatio (%s) * maxResultsPerPage (%s).", tableNumRows, activationRatio, maxResultsPerPage));
            return false;
        }
        logger.info((Object)String.format("Using StorageReadAPI as all conditions are met:\n\ttableNumRows (%s) >= minTableSize (%s)\n\ttableNumRows (%s) >= activationRatio * maxResultsPerPage (%s * %s)", tableNumRows, minTableSize, tableNumRows, activationRatio, maxResultsPerPage));
        return true;
    }

    private BigQueryResultSet readStorageTableData(TableId tableId, BigQueryExecutionInfoProvider executionInfo) {
        return this.readStorageTableData(tableId, executionInfo, -1L);
    }

    private BigQueryResultSet readStorageTableData(TableId tableId, BigQueryExecutionInfoProvider executionInfo, long maxRecords) {
        RowReader rowReader = new RowReader(this, maxRecords);
        boolean hasRows = this.connection.getBigQueryClient().readTableRows(rowReader, tableId);
        BigQueryAvroRowIterator rows = hasRows ? rowReader.getRows() : BigQueryAvroRowIterator.empty();
        return new BigQueryAvroResultSet(this, rowReader.getParsedSchema(), rows, executionInfo);
    }

    private BigQueryResultSet readStoragePartitionedTableData(TableId tableId, PartitionFilter partitionFilter, BigQueryExecutionInfoProvider executionInfo, long maxRecords) {
        RowReader rowReader = new RowReader(this, maxRecords);
        boolean hasRows = this.connection.getBigQueryClient().readPartitionedTableRows(rowReader, tableId, partitionFilter);
        BigQueryAvroRowIterator rows = hasRows ? rowReader.getRows() : BigQueryAvroRowIterator.empty();
        return new BigQueryAvroResultSet(this, rowReader.getParsedSchema(), rows, executionInfo);
    }

    @Override
    public ResultSet getResultSet() {
        return this.resultSet;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.cancelled.set(true);
            if (this.resultSet != null) {
                this.resultSet.close();
            }
            this.closed = true;
        }
    }

    @Override
    public int getMaxFieldSize() {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) {
    }

    @Override
    public int getMaxRows() {
        return 0;
    }

    @Override
    public void setMaxRows(int max) {
    }

    @Override
    public void setEscapeProcessing(boolean enable) {
    }

    @Override
    public int getQueryTimeout() {
        return 0;
    }

    @Override
    public void setQueryTimeout(int seconds) {
    }

    @Override
    public void cancel() {
        logger.info((Object)"Cancelling statement");
        this.cancelled.set(true);
    }

    public boolean isCancelled() {
        return this.cancelled.get();
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getUpdateCount() {
        return 0;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getFetchDirection() {
        return 1000;
    }

    @Override
    public void setFetchDirection(int direction) {
    }

    @Override
    public int getFetchSize() {
        return 0;
    }

    @Override
    public void setFetchSize(int rows) {
    }

    @Override
    public int getResultSetConcurrency() {
        return 1007;
    }

    @Override
    public int getResultSetType() {
        return 1003;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) {
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getResultSetHoldability() {
        return 2;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isPoolable() {
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) {
    }

    @Override
    public void closeOnCompletion() {
    }

    @Override
    public boolean isCloseOnCompletion() {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return false;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return this.executeQuery(this.sql);
    }

    @Override
    public int executeUpdate() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute() throws SQLException {
        return this.execute(this.sql);
    }

    @Override
    public void addBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.resultSet == null) {
            this.execute(this.sql, true);
        }
        if (this.resultSet == null) {
            throw new SQLException("Unable to retrieve metadata for the supplied query.");
        }
        return this.resultSet.getMetaData();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setString(int parameterIndex, String str) {
        while (this.parameters.size() < parameterIndex) {
            this.parameters.add(null);
        }
        this.parameters.set(parameterIndex - 1, new QueryParameter(str, StandardSQLTypeName.STRING));
    }

    @Override
    public void setDouble(int parameterIndex, double x) {
        while (this.parameters.size() < parameterIndex) {
            this.parameters.add(null);
        }
        this.parameters.set(parameterIndex - 1, new QueryParameter(String.valueOf(x), StandardSQLTypeName.FLOAT64));
    }

    @Override
    public void setLong(int parameterIndex, long x) {
        while (this.parameters.size() < parameterIndex) {
            this.parameters.add(null);
        }
        this.parameters.set(parameterIndex - 1, new QueryParameter(String.valueOf(x), StandardSQLTypeName.INT64));
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) {
        while (this.parameters.size() < parameterIndex) {
            this.parameters.add(null);
        }
        this.parameters.set(parameterIndex - 1, new QueryParameter(String.valueOf(x), StandardSQLTypeName.BOOL));
    }

    @Override
    public void clearParameters() {
        this.parameters.clear();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @VisibleForTesting
    static class SelectStarStatement {
        private static final Pattern SELECT_STAR = Pattern.compile(String.format("^\\s*SELECT\\s+\\*\\s+FROM\\s+(%s|%s)(\\s+LIMIT\\s+(?<maxRecords>[0-9]+))?\\s*$", "`(((?<projectId1>[^.`]+)\\.)?(?<datasetId1>[^.`]+)\\.)?(?<tableName1>[^.`]+)`", "((`(?<projectId2>[^.`]+)`\\.)?`(?<datasetId2>[^.`]+)`\\.)?`(?<tableName2>[^.`]+)`"), 2);
        public final String projectId;
        public final String datasetId;
        public final String tableName;
        public final long maxRecords;

        SelectStarStatement(String projectId, String datasetId, String tableName, long maxRecords) {
            this.projectId = projectId;
            this.datasetId = datasetId;
            this.tableName = tableName;
            this.maxRecords = maxRecords;
        }

        public static SelectStarStatement parse(String sql, String defaultProjectId) {
            try {
                Matcher matcher = SELECT_STAR.matcher(sql);
                if (matcher.matches()) {
                    String projectId = matcher.group("projectId1");
                    if (projectId == null) {
                        projectId = matcher.group("projectId2");
                    }
                    if (projectId == null) {
                        projectId = defaultProjectId;
                    }
                    if (StringUtils.isBlank((CharSequence)projectId)) {
                        logger.warnV("Missing projectId in SELECT query and no default project ID: %s", new Object[]{sql});
                        return null;
                    }
                    String datasetId = matcher.group("datasetId1");
                    if (datasetId == null) {
                        datasetId = matcher.group("datasetId2");
                    }
                    if (StringUtils.isBlank((CharSequence)datasetId)) {
                        logger.warnV("Missing datasetId in SELECT query: %s", new Object[]{sql});
                        return null;
                    }
                    String tableName = matcher.group("tableName1");
                    if (tableName == null) {
                        tableName = matcher.group("tableName2");
                    }
                    if (StringUtils.isBlank((CharSequence)tableName)) {
                        logger.warnV("Missing table name in SELECT query: %s", new Object[]{sql});
                        return null;
                    }
                    String strMaxRecords = matcher.group("maxRecords");
                    long maxRecords = strMaxRecords == null ? -1L : Long.parseLong(strMaxRecords);
                    return new SelectStarStatement(projectId, datasetId, tableName, maxRecords);
                }
            }
            catch (RuntimeException e) {
                logger.warnV((Throwable)e, "Failed to parse SELECT * FROM query: %s", new Object[]{sql});
            }
            return null;
        }
    }

    private static class RowReader
    implements AvroRowReader {
        private static final Object EOF_MARKER = new Object();
        private final GenericDatumReader<GenericRecord> datumReader = new GenericDatumReader();
        private final ArrayBlockingQueue<Object> rowBuffer = new ArrayBlockingQueue(256);
        private final AtomicInteger numWorkers = new AtomicInteger();
        private final BigQueryStatement statement;
        private final long maxRecords;
        private long currentRecordIndex;
        private AvroSchema schema;
        private volatile boolean shouldStop;

        public RowReader(BigQueryStatement statement, long maxRecords) {
            this.statement = statement;
            this.maxRecords = maxRecords;
        }

        @Override
        public void setSchema(AvroSchema schema) {
            this.schema = schema;
            this.datumReader.setSchema(new Schema.Parser().parse(schema.getSchema()));
        }

        @Override
        public AvroSchema getSchema() {
            return this.schema;
        }

        @Override
        public Iterable<AvroRowReaderWorker> createWorkers(int numWorkers) {
            this.numWorkers.set(numWorkers);
            return Stream.generate(() -> new Worker()).limit(numWorkers).collect(Collectors.toList());
        }

        public org.apache.avro.Schema getParsedSchema() {
            return this.datumReader.getSchema();
        }

        public BigQueryAvroRowIterator getRows() {
            return new BigQueryAvroRowIterator(){
                private GenericRecord takenRow;
                private boolean atEnd;
                private RuntimeException exception;

                @Override
                public void close() {
                    shouldStop = true;
                    rowBuffer.clear();
                }

                private void takeRow() {
                    Object item;
                    if (this.exception != null) {
                        throw this.exception;
                    }
                    if (this.takenRow != null || this.atEnd) {
                        return;
                    }
                    if (maxRecords > 0L && currentRecordIndex >= maxRecords) {
                        logger.info((Object)String.format("currentRecordIndex (%s) >= maxRecords (%s). Requesting workers to stop", currentRecordIndex, maxRecords));
                        this.atEnd = true;
                        shouldStop = true;
                        return;
                    }
                    if (statement.isCancelled()) {
                        logger.error((Object)"Statement cancelled. Requesting workers to stop");
                        this.atEnd = true;
                        shouldStop = true;
                        return;
                    }
                    try {
                        item = rowBuffer.take();
                    }
                    catch (InterruptedException e) {
                        logger.error((Object)"Interrupted", (Throwable)e);
                        this.atEnd = true;
                        Thread.currentThread().interrupt();
                        return;
                    }
                    ++currentRecordIndex;
                    if (item instanceof GenericRecord) {
                        this.takenRow = (GenericRecord)item;
                    } else if (item == EOF_MARKER) {
                        this.atEnd = true;
                    } else {
                        if (item instanceof Exception) {
                            this.exception = new RuntimeException((Exception)item);
                            throw this.exception;
                        }
                        throw new RuntimeException(String.format("Unexpected item in row buffer: %s", item));
                    }
                }

                @Override
                public boolean hasNext() {
                    this.takeRow();
                    return !this.atEnd;
                }

                @Override
                public GenericRecord next() {
                    this.takeRow();
                    if (this.atEnd) {
                        throw new NoSuchElementException();
                    }
                    GenericRecord result = this.takenRow;
                    this.takenRow = null;
                    return result;
                }
            };
        }

        private class Worker
        implements AvroRowReaderWorker {
            private BinaryDecoder decoder = null;

            private Worker() {
            }

            @Override
            public boolean processRows(AvroRows rows) throws InterruptedException {
                try {
                    this.decoder = DecoderFactory.get().binaryDecoder(rows.getSerializedBinaryRows().toByteArray(), this.decoder);
                    while (!this.decoder.isEnd() && !RowReader.this.shouldStop) {
                        RowReader.this.rowBuffer.put(RowReader.this.datumReader.read(null, (Decoder)this.decoder));
                    }
                }
                catch (IOException e) {
                    RowReader.this.rowBuffer.put(e);
                    throw new RuntimeException(e);
                }
                if (RowReader.this.shouldStop) {
                    logger.info((Object)"Worker stopped due to stop request.");
                    return false;
                }
                return true;
            }

            @Override
            public void complete() throws InterruptedException {
                this.complete(EOF_MARKER);
            }

            @Override
            public void fail(Exception e) throws InterruptedException {
                this.complete(e);
            }

            private void complete(Object o) throws InterruptedException {
                int newNumWorkers = RowReader.this.numWorkers.decrementAndGet();
                if (newNumWorkers == 0 && !RowReader.this.shouldStop) {
                    RowReader.this.rowBuffer.put(o);
                }
            }
        }
    }
}

