/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.cde;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.dataflow.cde.CDEProcessUtils;
import com.dataiku.dip.dataflow.exec.ActivityAbortedException;
import com.dataiku.dip.dataflow.jobrunner.ActivityRunnableThreadsHolder;
import com.dataiku.dip.dataflow.jobrunner.ActivityRunner;
import com.dataiku.dip.dataflow.jobrunner.FlowRunnableUtils;
import com.dataiku.dip.dataflow.kernel.slave.KernelSession;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionScope;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class CDEActivityThreadsRunner
extends ActivityRunnableThreadsHolder {
    private final Supplier<TicketBasedIntercomAPIClient> apiClientFactory;
    private static final Logger logger = Logger.getLogger((String)"dku.cde.activity");

    public CDEActivityThreadsRunner() {
        this(() -> CDEProcessUtils.newIntercomAPIClient());
    }

    @VisibleForTesting
    CDEActivityThreadsRunner(Supplier<TicketBasedIntercomAPIClient> apiClientFactory) {
        this.apiClientFactory = apiClientFactory;
    }

    public void run() throws Exception {
        List<ActivityRunner.FlowRunnableThread> runnableThreads = this.getRunnableThreads();
        for (ActivityRunner.FlowRunnableThread frt : runnableThreads) {
            frt.start();
        }
        try (ContainerizedDSSEngineAborterThread aborterThread = new ContainerizedDSSEngineAborterThread(TransactionContext.retrieveWrite());){
            List<Throwable> exceptionsFound;
            aborterThread.start();
            do {
                Thread.sleep(1000L);
                long aliveThreads = runnableThreads.stream().filter(Thread::isAlive).count();
                if (aliveThreads != 0L) continue;
                logger.info((Object)"All runnable threads done");
                break;
            } while ((exceptionsFound = this.getExceptions(runnableThreads)).isEmpty());
        }
        List<Throwable> exceptionsFound = this.getExceptions(runnableThreads);
        if (!exceptionsFound.isEmpty()) {
            Throwable nonAbortException = null;
            for (Throwable e : exceptionsFound) {
                if (!(e instanceof ActivityAbortedException)) {
                    if (nonAbortException == null) {
                        nonAbortException = e;
                    }
                    logger.error((Object)"Exception found during run", e);
                    continue;
                }
                logger.warn((Object)"Abort found during run", e);
            }
            if (nonAbortException != null) {
                throw new Exception("Runner failed", nonAbortException);
            }
        }
    }

    private List<Throwable> getExceptions(List<ActivityRunner.FlowRunnableThread> runnableThreads) {
        return runnableThreads.stream().map(ActivityRunner.FlowRunnableThread::getStoredException).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private class ContainerizedDSSEngineAborterThread
    extends Thread
    implements AutoCloseable {
        private State state = State.RUNNING;
        private final TransactionRef t;

        public ContainerizedDSSEngineAborterThread(RWTransactionRef t) {
            this.t = t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TransactionScope scope = TransactionContext.with((TransactionRef)this.t);
            try {
                while (true) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        logger.warn((Object)"CDE Aborter Thread was interrupted", (Throwable)e);
                        if (scope != null) {
                            scope.close();
                        }
                        return;
                    }
                    TicketBasedIntercomAPIClient apiClient = CDEActivityThreadsRunner.this.apiClientFactory.get();
                    try {
                        KernelSession.AbortedResult result = null;
                        try {
                            result = (KernelSession.AbortedResult)apiClient.get("/tintercom/containers/poll-aborted", KernelSession.AbortedResult.class);
                        }
                        catch (IOException e) {
                            logger.warn((Object)"Failed to poll job aborted status", (Throwable)e);
                        }
                        if (result != null && result.getIsAborted()) break;
                        continue;
                    }
                    finally {
                        if (apiClient == null) continue;
                        apiClient.close();
                        continue;
                    }
                    break;
                }
                ContainerizedDSSEngineAborterThread containerizedDSSEngineAborterThread = this;
                synchronized (containerizedDSSEngineAborterThread) {
                    block23: {
                        if (this.state == State.RUNNING) break block23;
                        return;
                    }
                    this.state = State.ABORTING;
                }
                logger.info((Object)"Aborting runnables");
                FlowRunnableUtils.abort(CDEActivityThreadsRunner.this.getRunnableThreads(), null, DKUApp.getParams().getIntParam("dku.cde.abort.poolSize", Integer.valueOf(5)));
                return;
            }
            finally {
                if (scope != null) {
                    try {
                        scope.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }

        @Override
        public synchronized void close() throws Exception {
            if (this.state == State.ABORTING) {
                logger.info((Object)"Waiting for aborter to finish");
                super.join();
            } else {
                logger.info((Object)"Cancelling potential abort");
                this.state = State.CANCELLED;
            }
        }
    }

    private static enum State {
        RUNNING,
        ABORTING,
        CANCELLED;

    }
}

