/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sql;

import com.dataiku.dip.activity.ConnectionTasksService;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datasets.dynamic.VariablesExpansionLoopItemsIterable;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.queries.QueryBunch;
import com.dataiku.dip.recipes.code.sql.AbstractSQLQueryLikeRecipeRunner;
import com.dataiku.dip.recipes.code.sql.SQLQueryRecipeUtils;
import com.dataiku.dip.recipes.code.sql.SQLQueryToInsertTransformer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.sql.BigQuerySQLDialect;
import com.dataiku.dip.sql.BigQueryUtils;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.utils.AutoCloseableLock;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.NamedLock;
import com.dataiku.dip.variables.DynamicLevelsStack;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.base.Joiner;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractSQLQueryRecipeRunner
extends AbstractSQLQueryLikeRecipeRunner {
    @Autowired
    protected JobAuthCtxService authCtxService;
    protected RecipeRunnableSubgraph subgraph;
    protected FlowRecipe recipe;
    protected Dataset outputDataset;
    protected static DKULogger logger = DKULogger.getLogger((String)"dku.flow.sql");

    public AbstractSQLQueryRecipeRunner(JobActivity activity) {
        super(((RecipeRunnableSubgraph)activity.getSubgraph()).getRecipe().getProjectKey());
        SpringUtils.getInstance().autowire((Object)this);
        this.activity = activity;
        this.subgraph = (RecipeRunnableSubgraph)activity.getSubgraph();
        this.recipe = this.subgraph.getRecipe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runFullSQL(String connection, String outputCatalog, String outputSchema, String outputTable, Partition targetPartition, QueryBunch unexpandedQueryBunch, VariablesExpansionLoopItemsIterable veLoopIterable) throws Exception {
        try (AutoCloseableLock lock = StringUtils.isNotBlank((String)unexpandedQueryBunch.namedLock) ? NamedLock.acquire((String)unexpandedQueryBunch.namedLock) : null;){
            this.runFullSQLLockedIfNeeded(connection, outputCatalog, outputSchema, outputTable, targetPartition, unexpandedQueryBunch, veLoopIterable);
        }
    }

    private void runFullSQLLockedIfNeeded(String connection, String outputCatalog, String outputSchema, String outputTable, Partition targetPartition, QueryBunch unexpandedQueryBunch, VariablesExpansionLoopItemsIterable veLoopIterable) throws Exception {
        AuthCtx authCtx = this.authCtxService.getAuthCtx();
        SQLConnectionProvider.SQLConnectionData connData = SQLConnectionProvider.getConnectionData_NT(authCtx, this.recipe.getProjectKey(), connection);
        SQLDialect dialect = connData.getDialect();
        ConnectionTasksService.SQLQueryRun runningSQL = this.activity.runningThings.addSQL(connection);
        try (SQLConnectionProvider.SQLConnectionWrapper conn = SQLConnectionProvider.newConnection(connection, this.authCtxService.getAuthCtx(), this.recipeProjectKey);){
            InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
            this.initializeTargetTable(this.authCtxService.getAuthCtx(), connData, dialect, conn, targetPartition, this.outputDataset, this.recipe, messages);
            if (!messages.isEmpty()) {
                this.activity.warnContext.addWarning(WarningsContext.WarningType.SQL_CREATE_QUERY_WARNING, messages.report("\n"), logger);
            }
            this.executePreWriteStatements(connData, conn, this.outputDataset);
            if (dialect instanceof BigQuerySQLDialect) {
                AbstractSQLDatasetHandler.AbstractSQLConfig outputConfig = this.outputDataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(this.outputDataset.getProjectKey());
                BigQueryUtils.checkPartitioningConsistency(authCtx, connData.getConnection(), outputConfig, this.outputDataset.getPartitioningSchema());
            }
            for (JsonObject jo : veLoopIterable) {
                AutoCloseable withLevel = DynamicLevelsStack.withLevel(jo);
                try {
                    Statement stmt;
                    QueryBunch queryBunch = unexpandedQueryBunch.clone();
                    String untransformedButExpandedQuery = SQLQueryRecipeUtils.substituteAllAndStripComments(this.authCtxService.getAuthCtx(), this.outputDataset.getProjectKey(), this.subgraph, queryBunch.query, dialect, this.sqlQueryIsCommentFree);
                    String insertQuery = this.prepareMainQuery(outputCatalog, outputSchema, outputTable, connData, untransformedButExpandedQuery);
                    insertQuery = SQLQueryRecipeUtils.substituteAllAndStripComments(this.authCtxService.getAuthCtx(), this.outputDataset.getProjectKey(), this.subgraph, insertQuery, dialect, this.sqlQueryIsCommentFree);
                    queryBunch.optionalPreQueries = queryBunch.optionalPreQueries.stream().map(q -> SQLQueryRecipeUtils.substituteAllAndStripCommentsUnchecked(authCtx, this.recipe.getProjectKey(), this.subgraph, q, connData.getDialect(), false)).collect(Collectors.toList());
                    queryBunch.preQueries = queryBunch.preQueries.stream().map(q -> SQLQueryRecipeUtils.substituteAllAndStripCommentsUnchecked(authCtx, this.recipe.getProjectKey(), this.subgraph, q, connData.getDialect(), false)).collect(Collectors.toList());
                    queryBunch.postQueries = queryBunch.postQueries.stream().map(q -> SQLQueryRecipeUtils.substituteAllAndStripCommentsUnchecked(authCtx, this.recipe.getProjectKey(), this.subgraph, q, connData.getDialect(), false)).collect(Collectors.toList());
                    for (String query : queryBunch.optionalPreQueries) {
                        try {
                            stmt = conn.createStatement();
                            try {
                                this.executeCancellableStatement(conn, stmt, query);
                            }
                            finally {
                                if (stmt == null) continue;
                                stmt.close();
                            }
                        }
                        catch (Exception e) {
                            logger.warn((Object)"Pre-query failed, but was considered optional", (Throwable)e);
                        }
                    }
                    for (String query : queryBunch.preQueries) {
                        stmt = conn.createStatement();
                        try {
                            this.executeCancellableStatement(conn, stmt, query);
                        }
                        finally {
                            if (stmt == null) continue;
                            stmt.close();
                        }
                    }
                    this.safePrintExecutionPlan(untransformedButExpandedQuery, connData, dialect, conn, true);
                    try (Statement stmt2 = conn.createStatement();){
                        this.executeCancellableStatement(conn, stmt2, insertQuery);
                    }
                    for (String query : queryBunch.postQueries) {
                        stmt = conn.createStatement();
                        try {
                            this.executeCancellableStatement(conn, stmt, query);
                        }
                        finally {
                            if (stmt == null) continue;
                            stmt.close();
                        }
                    }
                }
                finally {
                    if (withLevel == null) continue;
                    withLevel.close();
                }
            }
            this.executePostWriteStatements(connData, conn, this.outputDataset);
            if (dialect.supportsCommitAndRollback()) {
                conn.commit();
            }
        }
        catch (SQLException e) {
            logger.error((Object)"Query failed");
            throw e;
        }
        finally {
            runningSQL.doneOn = System.currentTimeMillis();
        }
    }

    protected String prepareMainQuery(String outputCatalog, String outputSchema, String outputTable, SQLConnectionProvider.SQLConnectionData connData, String query) {
        return SQLQueryToInsertTransformer.transform(connData, query, outputCatalog, outputSchema, outputTable, this.outputDataset, this.sqlQueryMayContainUnionOrSelect);
    }

    protected void runRegular(String connection, QueryBunch unexpandedQueryBunch, VariablesExpansionLoopItemsIterable veLoopIterable) throws Exception {
        SQLConnectionProvider.SQLConnectionData connData = SQLConnectionProvider.getConnectionData_NT(this.authCtxService.getAuthCtx(), this.recipe.getProjectKey(), connection);
        this.runRegularToDataset(this.authCtxService.getAuthCtx(), this.outputDataset, this.subgraph.getTargetPartition(this.subgraph.getTargets().get(0)), connData, unexpandedQueryBunch, veLoopIterable);
    }

    public static String getMainSingleConnection(AuthCtx authCtxService, RecipeRunnableSubgraph subgraph, DatasetsDAO datasetsDAO) throws IOException {
        SQLQueryRecipeUtils.SQLConnections sourceConnections = SQLQueryRecipeUtils.getSourceConnections(authCtxService, subgraph, datasetsDAO, "main");
        if (sourceConnections.connections.size() > 1) {
            throw ErrorContext.iaef((String)"Mismatch in input connections : can't have a SQL recipe use several connections: %s", (Object)Joiner.on((String)", ").join(sourceConnections.connections), (Object[])new Object[0]);
        }
        List<Dataset> targetsDatasets = SQLQueryRecipeUtils.getTargetDatasets(subgraph);
        SQLQueryRecipeUtils.SQLConnections targetConnections = SQLQueryRecipeUtils.getConnectionsFromSqlTableDatasets(targetsDatasets);
        return SQLQueryRecipeUtils.getDefaultConnection(sourceConnections, targetConnections);
    }
}

