/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graphtools;

import com.dataiku.dip.coremodel.AppHomepageTile;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.JobDef;
import com.dataiku.dip.coremodel.Partitionable;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobState;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowPartitionable;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.dataflow.graphtools.PropagateSchemaTool;
import com.dataiku.dip.dataflow.jobrunner.status.EnhancedSerializedJobStatus;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.recipes.RecipeSaveService;
import com.dataiku.dip.server.recipes.RecipeSchemaService;
import com.dataiku.dip.server.services.FlowExecutionService2;
import com.dataiku.dip.server.services.FlowToolsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class AutoSchemaPropagation {
    private final PropagateSchemaTool tool;
    private final String projectKey;
    private final AuthCtx authCtx;
    private final Map<String, String> partitionByDim;
    private final Map<String, String> partitionByComputable;
    private final JsonObject initialData;
    private final Set<String> markAsOkRecipes;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private DatasetSaveService datasetSaveService;
    @Autowired
    private RecipeSaveService recipeSaveService;
    @Autowired
    private FlowExecutionService2 flowExecutionService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private VariablesService variablesService;
    private static Logger logger = Logger.getLogger((String)"dip.schema.propagate");

    public AutoSchemaPropagation(AuthCtx authCtx, String projectKey, List<AnyLoc> sources, JsonObject recipeUpdateOptions, Set<String> excludedRecipes, List<AppHomepageTile.PartitionDef> partitionByDim, List<AppHomepageTile.PartitionDef> partitionByComputable, Set<String> markAsOkRecipes) throws IOException {
        this(authCtx, projectKey, sources, recipeUpdateOptions, excludedRecipes, AutoSchemaPropagation.listToMap(partitionByDim), AutoSchemaPropagation.listToMap(partitionByComputable), markAsOkRecipes);
    }

    public AutoSchemaPropagation(AuthCtx authCtx, String projectKey, List<AnyLoc> sources, JsonObject recipeUpdateOptions, Set<String> excludedRecipes, Map<String, String> partitionValueByDim, Map<String, String> partitionByComputableRef, Set<String> markAsOkRecipes) throws IOException {
        this.authCtx = authCtx;
        this.projectKey = projectKey;
        this.partitionByDim = partitionValueByDim;
        this.partitionByComputable = partitionByComputableRef;
        this.markAsOkRecipes = markAsOkRecipes;
        SpringUtils.getInstance().autowire((Object)this);
        JsonObject byType = null;
        if (!recipeUpdateOptions.has("byType")) {
            byType = new JsonObject();
            recipeUpdateOptions.add("byType", (JsonElement)byType);
        } else {
            byType = recipeUpdateOptions.get("byType").getAsJsonObject();
        }
        for (RecipeMeta meta : RecipeRegistry.getAllMeta()) {
            if (byType.has(meta.getType())) continue;
            byType.add(meta.getType(), (JsonElement)new JsonObject());
        }
        this.initialData = new JsonObject();
        JsonArray sourcesArray = new JsonArray();
        for (AnyLoc loc : sources) {
            JsonObject sourceObj = new JsonObject();
            sourceObj.addProperty("projectKey", loc.getProjectKey());
            sourceObj.addProperty("id", loc.getId());
            sourcesArray.add((JsonElement)sourceObj);
        }
        this.initialData.add("sources", (JsonElement)sourcesArray);
        this.initialData.add("recipeUpdateOptions", (JsonElement)recipeUpdateOptions);
        this.initialData.add("excludedRecipes", JSON.toJsonElement(excludedRecipes));
        this.tool = new PropagateSchemaTool(authCtx, projectKey, this.initialData);
    }

    private static Map<String, String> listToMap(List<AppHomepageTile.PartitionDef> list) {
        HashMap map = Maps.newHashMap();
        for (AppHomepageTile.PartitionDef def : list) {
            map.put(def.from, def.to);
        }
        return map;
    }

    public FutureResponse<InfoMessage.InfoMessages> propagateAsync(boolean rebuild) throws Exception {
        AutomaticPropagateThread ft = new AutomaticPropagateThread(this.authCtx, rebuild);
        return this.futureService.runFuture(ft, 100L, new TypeToken<FutureResponse<InfoMessage.InfoMessages>>(){});
    }

    public InfoMessage.InfoMessages propagate(boolean rebuildStuff) throws Exception {
        return this.propagate(rebuildStuff, true, false);
    }

    public InfoMessage.InfoMessages propagate(boolean rebuildStuff, boolean openToolInFlow, boolean autoMarkAsOK) throws Exception {
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        PropagateSchemaTool.UpdateOptions updateOptions = new PropagateSchemaTool.UpdateOptions();
        updateOptions.alwaysRebuildInputOfRecipesUsuallyComputingOutputSchemaBasedOnData = rebuildStuff;
        updateOptions.alwaysRebuildOutputOfRecipesUsuallyComputingOutputSchemaAtRuntime = rebuildStuff;
        updateOptions.performExpensive = true;
        updateOptions.recheckAll = false;
        JsonObject lastSummary = null;
        try (FutureProgress.AutocloseableFutureProgressState futureState = FutureProgress.pushAutoCloseableState((String)"Propagating schema", (double)this.tool.getFlowState((JsonObject)new JsonObject()).stateByNode.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            HashSet todo = Sets.newHashSet();
            do {
                String jobId;
                this.tool.update(JSON.toJsonObject((Object)updateOptions));
                PropagateSchemaTool.PropagateSchemaToolState state = this.tool.getFlowState(new JsonObject());
                if (lastSummary != null && JSON.jsonEquals((Object)lastSummary, (Object)state.summary)) {
                    logger.warn((Object)"Unable to progress in the propagation");
                    break;
                }
                lastSummary = state.summary;
                int done = 0;
                todo.clear();
                HashMap rebuilds = Maps.newHashMap();
                HashMap updates = Maps.newHashMap();
                block27: for (Map.Entry<String, PropagateSchemaTool.NodeState> entry : state.stateByNode.entrySet()) {
                    PropagateSchemaTool.NodeState nodeState = entry.getValue();
                    switch (nodeState.state) {
                        case DATASET_NEEDS_REBUILD: {
                            rebuilds.put(entry.getKey(), nodeState);
                            todo.add(entry.getKey());
                            continue block27;
                        }
                        case UNCHECKED: {
                            todo.add(entry.getKey());
                            continue block27;
                        }
                        case NOK: {
                            updates.put(entry.getKey(), nodeState);
                            todo.add(entry.getKey());
                            continue block27;
                        }
                        case UNCHECKABLE: {
                            String recipeName = DatasetLocUtils.DatasetLoc.resolveFull(nodeState.fullId).getId();
                            if (nodeState.recipeShouldProbablyBeRebuilt) {
                                rebuilds.put(entry.getKey(), nodeState);
                                continue block27;
                            }
                            if (nodeState.runnable && (this.markAsOkRecipes.contains(recipeName) || autoMarkAsOK)) {
                                logger.info((Object)("uncheckable " + nodeState.fullId + " but mark as ok"));
                                this.tool.forceMarkRecipeOK(recipeName, false);
                                continue block27;
                            }
                            this.throwRecipeCheckFailedError(nodeState, recipeName);
                            continue block27;
                        }
                        case FAILED_CHECK: {
                            String recipeName = DatasetLocUtils.DatasetLoc.resolveFull(nodeState.fullId).getId();
                            if (nodeState.runnable && this.markAsOkRecipes.contains(recipeName)) {
                                logger.info((Object)("failed to check " + nodeState.fullId + " but mark as ok"));
                                this.tool.forceMarkRecipeOK(recipeName, false);
                                continue block27;
                            }
                            this.throwRecipeCheckFailedError(nodeState, recipeName);
                            continue block27;
                        }
                    }
                    ++done;
                }
                futureState.set((double)done);
                if (!updates.isEmpty()) {
                    logger.info((Object)("Auto-propagation  has updates to perform: " + JSON.json((Object)updates)));
                    try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(this.authCtx);){
                        for (Map.Entry update : updates.entrySet()) {
                            PropagateSchemaTool.NodeState nodeState = (PropagateSchemaTool.NodeState)update.getValue();
                            RecipeSchemaService.RecipeSchemaAutoupdateResult actions = nodeState.updateSolution;
                            logger.info((Object)("Recipe autoupdate result: " + JSON.json((Object)actions)));
                            if (actions.updatedRecipe != null) {
                                this.recipeSaveService.save(this.projectKey, actions.updatedRecipe, actions.updatedPayload);
                            }
                            for (RecipeSchemaService.ComputableSchemaAutoupdateResult computableSchemaAutoupdateResult : actions.computables) {
                                if (computableSchemaAutoupdateResult.type != FlowComputable.FCType.DATASET) continue;
                                Dataset dataset = this.datasetAccessService.getMandatory(this.projectKey, computableSchemaAutoupdateResult.datasetName);
                                dataset.setSchema(computableSchemaAutoupdateResult.newSchema);
                                this.datasetSaveService.saveWithoutEvents(this.projectKey, computableSchemaAutoupdateResult.datasetName, dataset.serialize(), this.authCtx);
                            }
                        }
                        t.commit("Accept schema propagation changes");
                    }
                }
                if (rebuilds.isEmpty()) continue;
                JobDef def = new JobDef();
                VariablesContext variablesContext = this.variablesService.getContext(this.projectKey);
                try (Transaction t = this.transactionService.beginRead();){
                    def.projectKey = this.projectKey;
                    for (Map.Entry entry : rebuilds.entrySet()) {
                        PropagateSchemaTool.NodeState nodeState = (PropagateSchemaTool.NodeState)entry.getValue();
                        if (nodeState.runnable) {
                            GraphNode node = this.tool.getNode(nodeState.fullId);
                            for (GraphNode graphNode : node.getSuccessors()) {
                                AnyLoc loc = DatasetLocUtils.DatasetLoc.resolveFull(graphNode.getFullId());
                                JobDef.JobOutput output = new JobDef.JobOutput(loc.getProjectKey(), loc.getId(), this.getPartition(loc));
                                def.outputs.add(output);
                            }
                            continue;
                        }
                        AnyLoc loc = DatasetLocUtils.DatasetLoc.resolveFull(nodeState.fullId);
                        JobDef.JobOutput output = new JobDef.JobOutput(loc.getProjectKey(), loc.getId(), this.getPartition(loc));
                        def.outputs.add(output);
                    }
                    def.expandInPlaceOutputsTargetPartition(variablesContext);
                    def.type = JobDef.JobType.RECURSIVE_BUILD;
                    def.refreshHiveMetastore = true;
                    def.initiationTimestamp = System.currentTimeMillis();
                    def.triggeredFrom = JobDef.JobTriggerType.SCHEDULER;
                    def.initiator = this.authCtx.getIdentifier();
                    jobId = this.flowExecutionService.startJob(def, this.authCtx);
                }
                EnhancedSerializedJobStatus status = this.flowExecutionService.waitUntilFinished_NT(this.projectKey, jobId);
                JobState jobState = status.baseStatus.state;
                if (jobState != JobState.DONE) {
                    throw new CodedException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_GENERIC_ERROR, "Rebuilding failed: " + status.errorMessage);
                }
                for (Map.Entry entry : rebuilds.entrySet()) {
                    PropagateSchemaTool.NodeState nodeState = (PropagateSchemaTool.NodeState)entry.getValue();
                    AnyLoc loc = DatasetLocUtils.DatasetLoc.resolveFull(nodeState.fullId);
                    if (nodeState.state == PropagateSchemaTool.State.DATASET_NEEDS_REBUILD) {
                        this.tool.markDatasetAsBeingRebuilt(loc.getId());
                        continue;
                    }
                    if (nodeState.state == PropagateSchemaTool.State.UNCHECKABLE) {
                        this.tool.forceMarkRecipeOK(loc.getId(), true);
                        continue;
                    }
                    throw new Error("unreachable");
                }
            } while (!todo.isEmpty());
        }
        catch (Exception e) {
            if (openToolInFlow) {
                try {
                    ((FlowToolsService)SpringUtils.getBean(FlowToolsService.class)).makeToolActive(this.authCtx, this.projectKey, "PROPAGATE_SCHEMA", this.initialData, this.tool);
                }
                catch (Exception e2) {
                    logger.warn((Object)"Failed to set auto-propagation tool as the active one", (Throwable)e2);
                }
            }
            throw e;
        }
        ret.summarize();
        return ret;
    }

    private void throwRecipeCheckFailedError(PropagateSchemaTool.NodeState nodeState, String name) throws CodedException {
        String message = "Failed check, cannot propagate schema in recipe '" + name + "'";
        if (StringUtils.isNotBlank((String)nodeState.uncheckableReason)) {
            message = message + ": " + nodeState.uncheckableReason;
        } else if (nodeState.checkFailure != null) {
            message = message + ": " + nodeState.checkFailure.message;
        }
        throw new CodedException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_CANNOT_CHECK_SCHEMA_CONSISTENCY, message);
    }

    private String getPartition(AnyLoc loc) throws IOException {
        if (this.partitionByComputable.containsKey(loc.getId())) {
            return this.partitionByComputable.get(loc.getId());
        }
        GraphNode node = this.tool.getNode(loc.getFullName());
        if (node instanceof FlowPartitionable) {
            Partitionable partitioned = ((FlowPartitionable)((Object)node)).getPartitioned(this.datasetsDAO);
            PartitioningScheme scheme = partitioned.getPartitioningSchema();
            if (scheme != null && scheme.isPartitioned()) {
                ArrayList chunks = Lists.newArrayList();
                for (String name : scheme.getDimensionNames()) {
                    chunks.add(StringUtils.defaultIfEmpty((String)this.partitionByDim.get(name), (String)""));
                }
                return Joiner.on((String)"|").join((Iterable)chunks);
            }
            return "NP";
        }
        return "NP";
    }

    private class AutomaticPropagateThread
    extends SimpleFutureThread<InfoMessage.InfoMessages> {
        private final boolean rebuild;

        public AutomaticPropagateThread(AuthCtx owner, boolean rebuild) {
            super(owner);
            this.rebuild = rebuild;
        }

        @Override
        protected InfoMessage.InfoMessages compute() throws Exception {
            return AutoSchemaPropagation.this.propagate(this.rebuild);
        }

        public FuturePayload getPayload() {
            FuturePayload fp = new FuturePayload();
            fp.action = "propagate-schema";
            fp.displayName = "Propagate schema changes from " + AutoSchemaPropagation.this.tool.getStartingLocs().stream().map(AnyLoc::getFullName).collect(Collectors.joining(", "));
            return fp;
        }
    }
}

