/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.jobrunner;

import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dataflow.ImplicitDependencyRunnableSubgraph;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.RunnableSubgraph;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.Initializable;
import com.dataiku.dip.dataflow.exec.PeriodicObserver;
import com.dataiku.dip.dataflow.exec.RecipeRunnerWithPayload;
import com.dataiku.dip.dataflow.exec.WithAdditionalRunnables;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.pipeline.AbstractPipelineRunnableSubgraph;
import com.dataiku.dip.dataflow.pipeline.SparkPipelineRunnableSubgraph;
import com.dataiku.dip.dataflow.pipeline.SparkPipelineRunner;
import com.dataiku.dip.dataflow.pipeline.SqlPipelineRunnableSubgraph;
import com.dataiku.dip.dataflow.pipeline.SqlPipelineRunner;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.server.SpringUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.NotImplementedException;
import org.apache.log4j.Logger;

public class ExecutionRunnablesBuilder {
    private JobActivity activity;
    private static Logger logger = Logger.getLogger((String)"dku.flow.activity");

    public ExecutionRunnablesBuilder(JobActivity activity) {
        SpringUtils.getInstance().autowire((Object)this);
        this.activity = activity;
    }

    public boolean usesDefaultLifecycleHook() {
        RunnableSubgraph subgraph = this.activity.getSubgraph();
        if (subgraph instanceof ImplicitDependencyRunnableSubgraph) {
            return true;
        }
        if (subgraph instanceof RecipeRunnableSubgraph) {
            return RecipeRegistry.getMeta(this.activity).usesDefaultLifecycleHook();
        }
        if (subgraph instanceof AbstractPipelineRunnableSubgraph) {
            return true;
        }
        throw new NotImplementedException();
    }

    public JobActivityRunSpec getRunnables() throws Exception {
        JobActivityRunSpec runner = new JobActivityRunSpec();
        Object o = null;
        RunnableSubgraph subgraph = this.activity.getSubgraph();
        if (subgraph instanceof ImplicitDependencyRunnableSubgraph) {
            o = new Runnable(){

                @Override
                public void run() {
                }
            };
        } else if (subgraph instanceof RecipeRunnableSubgraph) {
            o = RecipeRegistry.buildRunner(this.activity);
        } else if (subgraph instanceof SparkPipelineRunnableSubgraph) {
            o = new SparkPipelineRunner(this.activity);
        } else if (subgraph instanceof SqlPipelineRunnableSubgraph) {
            o = new SqlPipelineRunner(this.activity);
        }
        SpringUtils.getInstance().autowire(o);
        if (o instanceof RecipeRunnerWithPayload) {
            RecipesDAO dao = (RecipesDAO)SpringUtils.getBean(RecipesDAO.class);
            RecipeRunnableSubgraph rsubgraph = (RecipeRunnableSubgraph)this.activity.getSubgraph();
            FlowRecipe recipe = rsubgraph.getRecipe();
            ((RecipeRunnerWithPayload)o).setPayload(dao.getPayloadOrNull(recipe.getProjectKey(), recipe.getName()));
        }
        if (o instanceof Initializable) {
            ((Initializable)o).init();
        }
        if (o instanceof WithAdditionalRunnables) {
            runner.runnables.addAll(((WithAdditionalRunnables)o).getRunnables());
        }
        if (o instanceof FlowRunnable) {
            runner.runnables.add((FlowRunnable)o);
        }
        if (o instanceof PeriodicObserver) {
            runner.observer = (PeriodicObserver)o;
        }
        return runner;
    }

    public static class JobActivityRunSpec {
        List<FlowRunnable> runnables = new ArrayList<FlowRunnable>();
        PeriodicObserver observer;
    }
}

