/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataquality.rules;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataquality.RuleValidationError;
import com.dataiku.dip.dataquality.rules.AbstractMultiColumnRule;
import com.dataiku.dip.dataquality.rules.MetricsBasedDataQualityRule;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.metrics.probes.AdvancedStatsDatasetProbeType;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;

public abstract class AbstractMultiColumnTopValuesRule
extends AbstractMultiColumnRule
implements MetricsBasedDataQualityRule {
    public List<String> columns = new ArrayList<String>();
    public List<String> valueSet = Lists.newArrayList();

    @Override
    public List<String> getColumns() {
        return this.columns;
    }

    @Override
    protected List<Metric> getMetricsForOneColumn(String column) {
        return List.of(Metric.deserializeMetric(this.getStringMetricForOneColumn(column)));
    }

    public abstract int getNumberTopValues();

    @Override
    protected AbstractCheckContext.CheckResult runForOneColumn(String column, AuthCtx authCtx, AbstractCheckContext context, MetricsComputationService.MetricsCheckRunReport runReport) throws Exception {
        ReadOnlyJobsInternalDB.MetricDataPoint metricValue = context.getCurrentValue(this.getStringMetricForOneColumn(column));
        if (metricValue == null) {
            return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.EMPTY, "Cannot check: no value");
        }
        if (metricValue.value == null) {
            return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.EMPTY, "Cannot check: empty value");
        }
        List metricValues = (List)JSON.parse((String)metricValue.value, (TypeToken)new TypeToken<List<String>>(){});
        metricValues.remove(null);
        metricValues = metricValues.subList(0, Math.min(this.getNumberTopValues(), metricValues.size()));
        LinkedHashSet metricValuesSet = new LinkedHashSet(metricValues);
        LinkedHashSet<String> checkValuesSet = new LinkedHashSet<String>(this.valueSet);
        boolean includes = checkValuesSet.containsAll(metricValuesSet);
        String metricValuesToDisplay = String.format("{%s}", String.join((CharSequence)", ", metricValuesSet));
        String checkValuesToDisplay = String.format("{%s}", String.join((CharSequence)", ", checkValuesSet));
        return new AbstractCheckContext.CheckResult(includes ? AbstractCheckContext.CheckOutcome.OK : AbstractCheckContext.CheckOutcome.ERROR, includes ? metricValuesToDisplay : String.format("%s not in %s", metricValuesToDisplay, checkValuesToDisplay));
    }

    @Override
    @Nullable
    public RuleValidationError verifyPreConditions(Dataset dataset, List<MetricsComputationService.ValuedMetric> computedMetrics) {
        return this.checkComputedMetricsPresent(computedMetrics);
    }

    @Override
    @Nullable
    public RuleValidationError verifyConfigOtherThanColumnsExistence(Dataset dataset) {
        if (this.getNumberTopValues() <= 0) {
            return new RuleValidationError("The number of top values must be at least 1");
        }
        if (this.getNumberTopValues() >= 100) {
            return new RuleValidationError("The number of top values must be at most 99");
        }
        return null;
    }

    private String getStringMetricForOneColumn(String column) {
        return Metric.buildMetricIdFromParts("adv_col_stats", AdvancedStatsDatasetProbeType.AdvancedStatsDatasetMetrics.TOPN.name(), column, Integer.toString(this.getNumberTopValues() + 1));
    }
}

