/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.db;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.MiscCodes;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.db.DSSDBConnectionDebugMonitor;
import com.dataiku.dip.db.DSSDBConnectionsManagementService;
import com.dataiku.dip.db.PersistedPreparedStatement;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.google.common.base.Preconditions;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class DSSDBConnection
implements AutoCloseable {
    public static final boolean READ_ONLY = true;
    private final Map<String, PersistedPreparedStatement> preparedStatements = new HashMap<String, PersistedPreparedStatement>();
    private final DSSDBConnectionsManagementService.ConnectionPool connectionsPool;
    private SQLConnectionProvider.SQLConnectionWrapper conn;
    final String debugId;
    private boolean isReadOnly;
    DSSDBConnectionDebugMonitor.Tracker tracker;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.db.internal");

    public DSSDBConnection(SQLConnectionProvider.SQLConnectionWrapper conn, DSSDBConnectionsManagementService.ConnectionPool connectionsPool, String debugId) {
        this.conn = conn;
        this.connectionsPool = (DSSDBConnectionsManagementService.ConnectionPool)((Object)Preconditions.checkNotNull((Object)((Object)connectionsPool)));
        this.debugId = debugId;
        logger.debugV("Created DSSDBConnection %s", new Object[]{debugId});
    }

    public PreparedStatement getOrCreatePreparedStatement(String sql) throws CodedSQLException {
        PreparedStatement statement = this.preparedStatements.get(sql);
        if (statement == null) {
            try {
                statement = this.trySetFetchSize(this.conn.prepareStatement(sql));
                this.preparedStatements.put(sql, new PersistedPreparedStatement(statement));
            }
            catch (SQLException e) {
                throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, "Failed to create persisted prepared statement", (Throwable)e);
            }
        }
        try {
            statement.clearParameters();
            return statement;
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, "Failed to clear prepared statement parameters", (Throwable)e);
        }
    }

    public PreparedStatement prepareNonPersistedStatement(String sql) throws CodedSQLException {
        try {
            return this.trySetFetchSize(this.conn.prepareStatement(sql));
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, "Failed to create non persisted prepared statement", (Throwable)e);
        }
    }

    private <T extends Statement> T trySetFetchSize(T statement) {
        try {
            statement.setFetchSize(DKUApp.getParams().getIntParam("dku.runtimeDatabases.statements.fetchSize", Integer.valueOf(2000)));
        }
        catch (SQLException e) {
            logger.warn((Object)"Could not set fetch size on statement", (Throwable)e);
        }
        return statement;
    }

    public void commit() throws CodedSQLException {
        logger.traceV("Committing DSSDBConnection: %s", new Object[]{this.debugId});
        try {
            this.conn.commit();
        }
        catch (SQLException e) {
            try {
                this.conn.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, "Failed to commit transaction", (Throwable)e);
        }
    }

    public void rollback() {
        logger.traceV("Rollbacking DSSDBConnection: %s", new Object[]{this.debugId});
        try {
            this.conn.rollback();
        }
        catch (SQLException e) {
            logger.warnV("Failed to rollback connection %s: $s", new Object[]{this.debugId, ExceptionUtils.getMessageWithCauses((Throwable)e)});
        }
    }

    public Statement createStatement() throws CodedSQLException {
        try {
            return this.trySetFetchSize(this.conn.createStatement());
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, "Failed to create statement", (Throwable)e);
        }
    }

    public void startTracking(DSSDBConnectionDebugMonitor connectionDebugMonitor) {
        this.stopTracking();
        this.tracker = connectionDebugMonitor.register(this.debugId);
    }

    private void stopTracking() {
        if (this.tracker != null) {
            this.tracker.close();
            this.tracker = null;
        }
    }

    @Override
    public void close() throws CodedSQLException {
        this.stopTracking();
        try {
            logger.traceV("Returning DSSDBConnection to pool: %s", new Object[]{this.debugId});
            this.connectionsPool.returnObject(this);
        }
        catch (Exception e) {
            SQLUtils.unsafeRollbackAndClose(this.conn);
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, "Failed to release connection", (Throwable)e);
        }
    }

    void ultimateClose() {
        this.stopTracking();
        try {
            logger.traceV("Closing connection %s", new Object[]{this.debugId});
            this.conn.close();
        }
        catch (SQLException e) {
            logger.errorV((Throwable)e, "Could not close the connection %s", new Object[]{this.debugId});
        }
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    DSSDBConnection setReadOnly(boolean readOnly) {
        this.isReadOnly = readOnly;
        return this;
    }

    public SQLConnectionProvider.SQLConnectionWrapper getConn() {
        return this.conn;
    }
}

