/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docextraction;

import com.dataiku.dip.docextraction.IDocumentScreenshotsDrawer;
import com.dataiku.dip.docextraction.common.InputRefs;
import com.dataiku.dip.utils.ExceptionUtils;
import java.io.File;
import java.util.Optional;

public class Screenshotter {
    public static final String TMP_DOC_EXTRACTION = "docextraction";
    public static final String SCREENSHOTS_EXTRACTION = "screenshots-extraction";
    public static final String TO_PDF_CONVERSION = "to-pdf-conversion";
    static final Integer DEFAULT_PAGINATION_OFFSET = 0;
    static final Integer DEFAULT_PAGINATION_SIZE = 10;
    static final Integer SCREENSHOTS_SCALE_FACTOR = 2;

    public static class ScreenshotterSettings {
        public String outputManagedFolderId;
        public Integer paginationSize;
        public Integer paginationOffset;

        public ScreenshotterSettings() {
        }

        public ScreenshotterSettings(String outputManagedFolderId, int paginationSize) {
            this.outputManagedFolderId = outputManagedFolderId;
            this.paginationSize = paginationSize;
        }

        public String toString() {
            return "paginationSize=" + this.paginationSize + ", paginationOffset=" + this.paginationOffset + ", outputManagedFolderId=" + this.outputManagedFolderId;
        }

        public static enum ScreenshotterEngine {
            LIBRE_OFFICE,
            BACKEND;

        }

        public static class StorageImpactingSettings {
            public ScreenshotterEngine engine;
            public int scaleFactor;
            public int memoryLimitPerDocumentInMB;

            public StorageImpactingSettings(ScreenshotterEngine engine) {
                this.engine = engine;
                this.scaleFactor = SCREENSHOTS_SCALE_FACTOR;
                this.memoryLimitPerDocumentInMB = IDocumentScreenshotsDrawer.MEMORY_LIMIT_PER_DOCUMENT;
            }

            public String toString() {
                return "engine=" + String.valueOf((Object)this.engine) + ", scaleFactor=" + this.scaleFactor + ", memoryLimitPerDocumentInMB=" + this.memoryLimitPerDocumentInMB;
            }
        }
    }

    public static class ScreenshotterInputs {
        public InputRefs.DocumentRef document;
    }

    public static class EnrichedScreenshotterResponseOrError {
        public ScreenshotterResponseOrError responseOrError;
        public Optional<File> convertedFile = Optional.empty();
    }

    public static class ScreenshotterResponseOrError {
        public boolean ok;
        public InputRefs.DocumentRef documentRef;
        public InputRefs.ImagesRef imagesRefs;
        public String type;
        public String errorMessage;
        public Throwable throwable;
        public Boolean hasMoreResults;
        public Integer lastResultIndex;
        public Integer totalResults;

        public static ScreenshotterResponseOrError fromSuccess(InputRefs.ImagesRef imagesRef, boolean hasMoreResults, Integer lastResultIndex, Integer totalResults) {
            ScreenshotterResponseOrError resp = new ScreenshotterResponseOrError();
            resp.ok = true;
            resp.imagesRefs = imagesRef;
            resp.hasMoreResults = hasMoreResults;
            resp.lastResultIndex = lastResultIndex;
            resp.type = imagesRef instanceof InputRefs.ManagedFolderImagesRef ? "managed_folder" : "inline";
            resp.totalResults = totalResults;
            return resp;
        }

        public static ScreenshotterResponseOrError fromError(Throwable e) {
            ScreenshotterResponseOrError resp = new ScreenshotterResponseOrError();
            resp.ok = false;
            resp.throwable = e;
            resp.errorMessage = ExceptionUtils.getMessageWithCauses((Throwable)e);
            return resp;
        }
    }

    public static class ScreenshotterRequest {
        public ScreenshotterInputs inputs = new ScreenshotterInputs();
        public ScreenshotterSettings settings = new ScreenshotterSettings();
    }
}

